/*
 * Decompiled with CFR 0.152.
 */
package activities.service.apiImpl;

import activities.api.ActivityApi;
import activities.api.ActivityConfigurationApi;
import activities.api.ActivityGoodsApi;
import activities.dto.goods.GoodsDto;
import activities.dto.goods.GoodsPictureDto;
import activities.dto.modeldto.ActivityDefinitionDto;
import activities.dto.modeldto.ActivityGoodsDto;
import activities.model.ActivityDefinition;
import activities.model.ActivityGoods;
import activities.model.repository.ActivityDefinitionRepos;
import activities.service.activities.dao.ActivitiesDao;
import activities.service.service.ActivityGoodsService;
import activities.vo.ActivityConfigurationVo;
import activities.vo.ActivityInfoVO;
import activities.vo.ActivityVo;
import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import goods.model.repository.GoodsPictureRepos;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import ma.glasnost.orika.MapperFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import utils.Lang;
import utils.data.BeanMapper;
import utils.lang.ObjectConvert;
import utils.lock.RedisLockUtil;

@MotanService
public class ActivityConfigurationApiImpl
implements ActivityConfigurationApi {
    private static final Logger log = LoggerFactory.getLogger(ActivityConfigurationApiImpl.class);
    @Autowired
    ActivityDefinitionRepos activityDefinitionRepos;
    @Autowired
    RedisTemplate redisTemplate;
    @Autowired
    ActivityApi activityApi;
    @Autowired
    ActivityGoodsApi activityGoodsApi;
    @Autowired
    ActivitiesDao activitiesDao;
    @Autowired
    MapperFacade mapperFacade;
    @Autowired
    ActivityGoodsService activityGoodsService;
    @Autowired
    GoodsPictureRepos goodsPictureRepos;
    @Value(value="${itaipingMobile.organization.code}")
    private String itaipingMobileOrganizationCode;
    @Value(value="${itaipingPC.organization.code}")
    private String itaipingPCOrganizationCode;
    @Value(value="${secKillActivity.activityCode}")
    private String secKillActivityCode;
    @Value(value="${tuanGouActivity.activityCode}")
    private String tuanGouActivityCode;
    @Autowired
    RedisLockUtil redisLockUtil;
    @Autowired
    JdbcTemplate jdbcTemplate;

    public Boolean isInActivity(String organizationCode) {
        Object startActivity = this.redisTemplate.opsForValue().get((Object)("jicaiScore:activity:startActivity:" + organizationCode));
        if (startActivity != null) {
            Object o = this.redisTemplate.opsForValue().get((Object)("jicaiScore:activity:lastActivityTime:" + organizationCode));
            if (o != null && ((Date)o).after(new Date())) {
                return true;
            }
            List activityDefinitions = this.activityDefinitionRepos.findByOrganizationCodeAndEndTimeGreaterThanOrderByEndTimeDesc(organizationCode, new Date());
            if (activityDefinitions == null || activityDefinitions.isEmpty()) {
                this.deleteActivityKeys();
                return false;
            }
            ActivityDefinition activityDefinition = (ActivityDefinition)activityDefinitions.get(0);
            this.redisTemplate.boundValueOps((Object)("jicaiScore:activity:lastActivityTime:" + organizationCode)).set((Object)activityDefinition.getEndTime());
            this.saveActivityKeys("jicaiScore:activity:lastActivityTime:" + organizationCode);
            return true;
        }
        return false;
    }

    public void saveActivityKeys(String key) {
        HashSet activityKeySetObj = this.redisTemplate.boundValueOps((Object)"jicaiScore:activity:inRedis").get();
        if (activityKeySetObj == null) {
            activityKeySetObj = new HashSet();
        }
        Set activityKeySet = activityKeySetObj;
        activityKeySet.add(key);
    }

    public void deleteActivityKeys() {
        Object activityKeySetObj = this.redisTemplate.boundValueOps((Object)"jicaiScore:activity:inRedis").get();
        if (activityKeySetObj != null) {
            Set activityKeySet = (Set)activityKeySetObj;
            for (String s : activityKeySet) {
                if (this.redisTemplate.boundValueOps((Object)s).get() == null) continue;
                this.redisTemplate.delete((Object)s);
            }
        }
    }

    public Boolean isInActivity(String organizationCode, String activityCode) {
        Boolean inActivity = this.isInActivity(organizationCode);
        if (inActivity.booleanValue()) {
            Object o = this.redisTemplate.opsForValue().get((Object)("jicaiScore:activity:lastActivityTime:" + organizationCode + ":" + activityCode));
            if (o != null && ((Date)o).after(new Date())) {
                return true;
            }
            List activityDefinitions = this.activityDefinitionRepos.findByOrganizationCodeAndActivityCodeAndEndTimeGreaterThanOrderByEndTimeDesc(organizationCode, activityCode, new Date());
            if (activityDefinitions == null || activityDefinitions.isEmpty()) {
                if (this.redisTemplate.boundValueOps((Object)("jicaiScore:activity:startActivity:" + organizationCode + ":" + activityCode)).get() != null) {
                    this.redisTemplate.delete((Object)("jicaiScore:activity:startActivity:" + organizationCode + ":" + activityCode));
                }
                if (this.redisTemplate.boundValueOps((Object)("jicaiScore:activity:lastActivityTime:" + organizationCode + ":" + activityCode)).get() != null) {
                    this.redisTemplate.delete((Object)("jicaiScore:activity:lastActivityTime:" + organizationCode + ":" + activityCode));
                }
                return false;
            }
            ActivityDefinition activityDefinition = (ActivityDefinition)activityDefinitions.get(0);
            this.redisTemplate.boundValueOps((Object)("jicaiScore:activity:lastActivityTime:" + organizationCode + ":" + activityCode)).set((Object)activityDefinition.getEndTime());
            this.saveActivityKeys("jicaiScore:activity:lastActivityTime:" + organizationCode + ":" + activityCode);
            return true;
        }
        return false;
    }

    public void startActivity(String organizationCode) {
        this.deleteActivityKeys();
        this.redisTemplate.boundValueOps((Object)("jicaiScore:activity:startActivity:" + organizationCode)).set((Object)("startActivity,organizationCode:" + organizationCode + " time: " + new SimpleDateFormat("yyyy-MM-dd HH-mm-ss").format(new Date())));
    }

    public List<ActivityDefinitionDto> getActivitiesOnGoging(String organizationCode, String activityCode, Date time) {
        List activityDefinitions = this.activityDefinitionRepos.findByOrganizationCodeAndActivityCodeAndEndTimeGreaterThanOrderByBeginTime(organizationCode, activityCode, time);
        ArrayList<Object> activityDefinitionList = new ArrayList<Object>();
        for (ActivityDefinition activityDefinition : activityDefinitions) {
            activityDefinitionList.add(ObjectConvert.convert((Object)activityDefinition, ActivityDefinition.class));
        }
        List activityDefinitionDtoList = BeanMapper.mapList(activityDefinitionList, ActivityDefinition.class, ActivityDefinitionDto.class);
        return activityDefinitionDtoList;
    }

    public ActivityConfigurationVo getActivityByCode(String organizationCode, String activityCode) {
        ActivityConfigurationVo activityConfigurationVo = new ActivityConfigurationVo();
        List resultSuccess = this.initActivity(organizationCode, activityCode);
        if (resultSuccess.size() > 0) {
            String activityBeginTimeKey = this.buildKeyForActivityBeginTime(organizationCode, activityCode);
            String activityEndTimeKey = this.buildKeyForActivityEndTime(organizationCode, activityCode);
            this.redisTemplate.opsForValue().set((Object)activityBeginTimeKey, ((Map)resultSuccess.get(0)).get("beginTime"));
            this.redisTemplate.opsForValue().set((Object)activityEndTimeKey, ((Map)resultSuccess.get(resultSuccess.size() - 1)).get("endTime"));
            this.setActivityKey(organizationCode, activityBeginTimeKey);
            this.setActivityKey(organizationCode, activityEndTimeKey);
            activityConfigurationVo.setActivityTimes(resultSuccess);
            activityConfigurationVo.setActivityStatusStart(Boolean.valueOf(this.activityBeginOrEnd(organizationCode, activityCode, "BEGIN")));
            activityConfigurationVo.setActivityStatusEnd(Boolean.valueOf(this.activityBeginOrEnd(organizationCode, activityCode, "END")));
            activityConfigurationVo.setActivityFlag(activityCode);
        } else {
            activityConfigurationVo.setActivityStatusEnd(Boolean.valueOf(true));
        }
        return activityConfigurationVo;
    }

    public List<Map<String, Object>> initActivity(String organizationCode, String activityCode) {
        List result = null;
        String resultKey = this.buildKeyForActivityInitTime(organizationCode, activityCode);
        this.setActivityKey(organizationCode, resultKey);
        BoundValueOperations boundValueOperations = this.redisTemplate.boundValueOps((Object)resultKey);
        if (!Lang.isEmpty((Object)boundValueOperations) && !Lang.isEmpty((Object)boundValueOperations.get())) {
            result = (List)boundValueOperations.get();
            for (Map map : result) {
                String activityId;
                ActivityDefinitionDto activityDefinitionDto;
                Date endTime = (Date)map.get("endTime");
                if (!endTime.before(new Date()) || !(activityDefinitionDto = this.activityApi.findById(activityId = (String)map.get("id"))).getIsOnline().booleanValue() || !activityDefinitionDto.getEndTime().equals(endTime)) continue;
                activityDefinitionDto.setIsOnline(Boolean.valueOf(false));
                this.activityDefinitionRepos.saveAndFlush(BeanMapper.map((Object)activityDefinitionDto, ActivityDefinition.class));
            }
            boundValueOperations.set((Object)result);
        } else {
            result = this.getAllActivityList(organizationCode, activityCode);
            boundValueOperations.set((Object)result);
        }
        return result;
    }

    public List<Map<String, Object>> getAllActivityList(String organizationCode, String activityCode) {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        List list = this.activityApi.findSecKillActivity(organizationCode, activityCode);
        if (list.size() > 0) {
            for (ActivityDefinitionDto activityDefinition : list) {
                HashMap<String, Object> map = new HashMap<String, Object>(3);
                if (Lang.isEmpty((Object)activityDefinition.getBeginTime())) continue;
                map.put("beginTime", activityDefinition.getBeginTime());
                map.put("endTime", activityDefinition.getEndTime());
                map.put("id", activityDefinition.getId());
                resultList.add(map);
            }
        }
        return resultList;
    }

    public boolean activityBeginOrEnd(String organizationCode, String activityCode, String flag) {
        Date currentTime = new Date();
        Date beginOrEndTime = null;
        boolean beginOrEnd = false;
        switch (flag) {
            case "BEGIN": {
                beginOrEndTime = (Date)this.redisTemplate.boundValueOps((Object)this.buildKeyForActivityBeginTime(organizationCode, activityCode)).get();
                break;
            }
            case "END": {
                beginOrEndTime = (Date)this.redisTemplate.boundValueOps((Object)this.buildKeyForActivityEndTime(organizationCode, activityCode)).get();
            }
        }
        if (!Lang.isEmpty(beginOrEndTime)) {
            beginOrEnd = currentTime.after(beginOrEndTime);
        }
        return beginOrEnd;
    }

    public String reload(String organizationCode, List<String> activityCodes) {
        if (Lang.isEmpty((Object)organizationCode)) {
            return "RELOAD FAIL FOR EMPTY ORGANIZATION CODE!";
        }
        if (Lang.isEmpty(activityCodes)) {
            return "RELOAD FAIL FOR EMPTY ACTIVITY CODE!";
        }
        for (String activityCode : activityCodes) {
            this.clearActivityKeys(organizationCode, activityCode);
            this.activityGoodsService.loadStockToRedis(organizationCode, activityCode);
        }
        return organizationCode + " ACTIVITY DATA RELOAD SUCCESS ";
    }

    public void setActivityKey(String organizationCode, String key) {
        String activityKey = this.buildKeyForActivityKeys(organizationCode);
        BoundValueOperations boundValueOperations = this.redisTemplate.boundValueOps((Object)activityKey);
        HashSet value = boundValueOperations.get();
        if (Lang.isEmpty((Object)value)) {
            value = new HashSet();
        }
        Set activityKeySet = value;
        activityKeySet.add(key);
        boundValueOperations.set((Object)activityKeySet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ActivityVo> getGoodsListByActivityId(String organizationCode, String activityId, String activityCode, String storeCode) {
        List<Object> listImg = new ArrayList<ActivityVo>();
        if (!Lang.isEmpty((Object)activityId)) {
            String activityGoodsKey = this.buildKeyForActivityGoods(organizationCode, activityId, activityCode);
            BoundValueOperations boundValueOperations = this.redisTemplate.boundValueOps((Object)activityGoodsKey);
            this.setActivityKey(organizationCode, activityGoodsKey);
            if (!Lang.isEmpty((Object)boundValueOperations) && !Lang.isEmpty((Object)boundValueOperations.get())) {
                listImg = (List)boundValueOperations.get();
            } else {
                String lockKey = this.buildKeyForLoadActivityGoodsLock(organizationCode, activityId, activityCode, storeCode);
                Boolean isLock = this.redisTemplate.boundValueOps((Object)lockKey).setIfAbsent((Object)true);
                if (isLock.booleanValue()) {
                    try {
                        Long getGoodsTime = System.currentTimeMillis();
                        listImg = this.getActivity(activityId, storeCode);
                        log.info("\u52a0\u8f7d\u6d3b\u52a8\u4ee3\u7801\u4e3a {} \u7684\u5546\u54c1\u5217\u8868\u8017\u65f6 {} ms", (Object)activityCode, (Object)(System.currentTimeMillis() - getGoodsTime));
                        boundValueOperations.set(listImg);
                    }
                    catch (Exception e) {
                        log.error("\u52a0\u8f7d\u6d3b\u52a8\u5546\u54c1\u5217\u8868\u5f02\u5e38", (Throwable)e);
                    }
                    finally {
                        this.redisTemplate.delete((Object)lockKey);
                    }
                } else {
                    log.info("\u5e76\u53d1\u52a0\u8f7d\u6d3b\u52a8\u5546\u54c1\u5217\u8868\u6570\u636e\u7b49\u5f85...");
                    try {
                        Thread.sleep(100L);
                        return this.getGoodsListByActivityId(organizationCode, activityId, activityCode, storeCode);
                    }
                    catch (InterruptedException e) {
                        log.error("\u7ebf\u7a0b\u7b49\u5f85\u5f02\u5e38", (Throwable)e);
                    }
                }
            }
        }
        return listImg;
    }

    public List<GoodsPictureDto> batchQueryGoodsPictureForActivityGoodsList(List<String> goodsIds) {
        long methodStart = System.currentTimeMillis();
        Vector<GoodsPictureDto> goodsPictureDTOsReturn = new Vector<GoodsPictureDto>();
        goodsIds.parallelStream().forEach(goodsId -> {
            String goodsPictureSql = "SELECT * FROM goods_picture gp WHERE gp.goods_id = ? AND gp.show_index = 0";
            List goodsPictureDTOs = this.jdbcTemplate.query(goodsPictureSql, (RowMapper)new BeanPropertyRowMapper(GoodsPictureDto.class), new Object[]{goodsId});
            if (!Lang.isEmpty((Object)goodsPictureDTOs)) {
                String goodsSql = "SELECT * FROM goods g WHERE g.id = ?";
                List goodsDTOs = this.jdbcTemplate.query(goodsSql, (RowMapper)new BeanPropertyRowMapper(GoodsDto.class), new Object[]{goodsId});
                if (!Lang.isEmpty((Object)goodsDTOs)) {
                    GoodsPictureDto goodsPictureDTO = (GoodsPictureDto)goodsPictureDTOs.get(0);
                    GoodsDto goodsDTO = (GoodsDto)goodsDTOs.get(0);
                    goodsPictureDTO.setGoods(goodsDTO);
                    goodsPictureDTOsReturn.add(goodsPictureDTO);
                }
            }
        });
        log.info("\u6279\u91cf\u67e5\u8be2\u6d3b\u52a8\u5546\u54c1\u56fe\u7247\u5217\u8868\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - methodStart));
        return goodsPictureDTOsReturn;
    }

    private List getActivity(String activityDefinitionId, String storeCode) {
        long getActivityDefinitionTime = System.currentTimeMillis();
        ActivityDefinition activityDefinition = (ActivityDefinition)this.activityDefinitionRepos.findOne((Serializable)((Object)activityDefinitionId));
        log.info("\u67e5\u8be2\u6d3b\u52a8\u573a\u6b21\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - getActivityDefinitionTime));
        ArrayList activityVoList = new ArrayList();
        if (!Lang.isEmpty((Object)activityDefinition)) {
            if (!Lang.isEmpty((Object)activityDefinition.getActivityGoodses())) {
                List goodsIds = activityDefinition.getActivityGoodses().stream().map(ActivityGoods::getGoodsId).collect(Collectors.toList());
                List goodsPictureDTOs = this.batchQueryGoodsPictureForActivityGoodsList(goodsIds);
                goodsPictureDTOs.forEach(goodsPictureDTO -> {
                    ActivityVo activityVo = new ActivityVo();
                    activityVo.setGoodsPicture(goodsPictureDTO);
                    int stockNum = 0;
                    int soldNum = 0;
                    for (ActivityGoods activityGoods : activityDefinition.getActivityGoodses()) {
                        if (!activityGoods.getGoodsId().equals(goodsPictureDTO.getGoods().getId())) continue;
                        stockNum = Lang.isEmpty((Object)activityGoods.getStockNum()) ? 0 : activityGoods.getStockNum();
                        soldNum = Lang.isEmpty((Object)activityGoods.getSoldNum()) ? 0 : activityGoods.getSoldNum();
                        break;
                    }
                    String soldPercent = this.calcStockPercent(stockNum, soldNum);
                    activityVo.setStockPercent(soldPercent);
                    activityVoList.add(activityVo);
                });
            }
            log.info("\u6d3b\u52a8\u5546\u54c1\u5217\u8868\u5927\u5c0f {}", (Object)activityVoList.size());
            if (!Lang.isEmpty(activityVoList)) {
                long setActivityPriceTime = System.currentTimeMillis();
                this.activityGoodsApi.setActivityPrice(activityVoList, activityDefinition.getOrganizationCode(), storeCode);
                log.info("\u6279\u91cf\u8bbe\u7f6e\u6d3b\u52a8\u552e\u4ef7\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - setActivityPriceTime));
            }
        }
        return activityVoList;
    }

    public Map<String, Object> getSystemTime(Integer activityIndex, String organizationCode, String activityCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (!Lang.isEmpty((Object)activityIndex) && !Lang.isEmpty((Object)activityCode)) {
            boolean noActivity = false;
            boolean hasStart = false;
            boolean hasEnd = false;
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date currentTime = new Date();
            Date nextSecKillStartTime = null;
            Date currentSecKillEndTime = null;
            if (!this.activityBeginOrEnd(organizationCode, activityCode, "END")) {
                List result;
                String activityInitTimeKey = this.buildKeyForActivityInitTime(organizationCode, activityCode);
                BoundValueOperations boundValueOperations = this.redisTemplate.boundValueOps((Object)activityInitTimeKey);
                this.setActivityKey(organizationCode, activityInitTimeKey);
                if (!Lang.isEmpty((Object)boundValueOperations) && !Lang.isEmpty((Object)boundValueOperations.get()) && (result = (List)boundValueOperations.get()).size() > 0) {
                    Date startTime = (Date)((Map)result.get(activityIndex)).get("beginTime");
                    hasStart = currentTime.after(startTime) || sdf.format(currentTime).equals(sdf.format(startTime));
                    nextSecKillStartTime = (Date)((Map)result.get(activityIndex)).get("beginTime");
                    currentSecKillEndTime = (Date)((Map)result.get(activityIndex)).get("endTime");
                    if (hasStart) {
                        Date endTime;
                        String currentActivityDefinitionId = (String)((Map)result.get(0)).get("id");
                        String currentActivityIdKey = this.buildKeyForCurrentActivityId(organizationCode, activityCode);
                        BoundValueOperations boundValueOperationsId = this.redisTemplate.boundValueOps((Object)currentActivityIdKey);
                        this.setActivityKey(organizationCode, currentActivityIdKey);
                        if (!Lang.isEmpty((Object)boundValueOperationsId) && !Lang.isEmpty((Object)boundValueOperationsId.get())) {
                            String oldActivityDefinitionId = (String)boundValueOperationsId.get();
                            if (!currentActivityDefinitionId.equals(oldActivityDefinitionId)) {
                                boundValueOperationsId.set((Object)currentActivityDefinitionId);
                            }
                        } else {
                            boundValueOperationsId.set((Object)currentActivityDefinitionId);
                        }
                        if (currentTime.after(endTime = (Date)((Map)result.get(activityIndex)).get("endTime")) || sdf.format(currentTime).equals(sdf.format(endTime))) {
                            this.activityApi.setActivityDefinitionIsOnline((String)((Map)result.get(activityIndex)).get("id"));
                            result.remove(activityIndex);
                            boundValueOperations.set((Object)result);
                            hasEnd = true;
                        }
                    }
                }
            } else {
                String currentActivityIdKey = this.buildKeyForCurrentActivityId(organizationCode, activityCode);
                BoundValueOperations boundValueOperations = this.redisTemplate.boundValueOps((Object)currentActivityIdKey);
                if (!Lang.isEmpty((Object)boundValueOperations) && !Lang.isEmpty((Object)boundValueOperations.get())) {
                    this.activityApi.setActivityDefinitionIsOnline((String)boundValueOperations.get());
                    this.redisTemplate.delete((Object)currentActivityIdKey);
                }
                noActivity = true;
            }
            if (activityIndex > 0) {
                map.put("nextSecKillStartTime", nextSecKillStartTime);
            } else {
                map.put("isStart", hasStart);
                map.put("nextSecKillStartTime", nextSecKillStartTime);
                map.put("currentSecKillEndTime", currentSecKillEndTime);
            }
            map.put("isEnd", hasEnd);
            map.put("systemTime", currentTime);
            map.put("noActivity", noActivity);
        }
        return map;
    }

    public String getCurrentActivityId(String organizationCode, String activityCode) {
        String key = this.buildKeyForCurrentActivityId(organizationCode, activityCode);
        String currentActivityId = (String)this.redisTemplate.boundValueOps((Object)key).get();
        return currentActivityId;
    }

    public String getCurrentActivityId(String organizationCode, String goodsId, String activityCode) {
        String key = this.buildKeyForCurrentActivityId(organizationCode, activityCode);
        String currentActivityId = (String)this.redisTemplate.boundValueOps((Object)key).get();
        if (!Lang.isEmpty((Object)currentActivityId) && !Lang.isEmpty((Object)goodsId)) {
            List activityGoodsList = this.activityGoodsApi.findActivityGoodsByGoodsIdAndActivityId(goodsId, currentActivityId);
            if (activityGoodsList.size() != 1) {
                currentActivityId = null;
            }
        } else {
            currentActivityId = null;
        }
        return currentActivityId;
    }

    public boolean redisHas(String key) {
        boolean hasValue = false;
        BoundValueOperations boundValueOperations = this.redisTemplate.boundValueOps((Object)key);
        if (!Lang.isEmpty((Object)boundValueOperations) && !Lang.isEmpty((Object)boundValueOperations.get())) {
            hasValue = true;
        }
        return hasValue;
    }

    public void redisSave(String key, Object obj) {
        BoundValueOperations boundValueOperations = this.redisTemplate.boundValueOps((Object)key);
        boundValueOperations.set(obj);
    }

    public Object redisReturn(String key) {
        BoundValueOperations boundValueOperations = this.redisTemplate.boundValueOps((Object)key);
        return boundValueOperations.get();
    }

    public void deleteRedisKey(String key) {
        this.redisTemplate.delete((Object)key);
    }

    public Map<String, Integer> getStockFromRedis(String organizationCode, String activityCode) {
        HashMap<String, Integer> stockMap = new HashMap<String, Integer>();
        String key = this.buildKeyForActivityStock(organizationCode, activityCode);
        Set keySet = this.redisTemplate.keys((Object)key);
        for (String keyTemp : keySet) {
            stockMap.put(keyTemp, (Integer)this.redisTemplate.boundValueOps((Object)keyTemp).get());
        }
        return stockMap;
    }

    public String getStockPercent(String activityDefinitionId, String activityGoodsId) {
        List activityGoodsList = this.activityGoodsApi.findActivityGoodsByGoodsIdAndActivityId(activityGoodsId, activityDefinitionId);
        return this.calcStockPercent(((ActivityGoodsDto)activityGoodsList.get(0)).getStockNum().intValue(), ((ActivityGoodsDto)activityGoodsList.get(0)).getSoldNum().intValue());
    }

    private String calcStockPercent(int stockNum, int soldNum) {
        String soldPercent = "100%";
        BigDecimal originalStock = new BigDecimal(stockNum).add(new BigDecimal(soldNum));
        if (!originalStock.equals(BigDecimal.ZERO)) {
            BigDecimal sold = new BigDecimal(soldNum).divide(originalStock, 2, 4);
            NumberFormat num = NumberFormat.getPercentInstance();
            num.setMaximumIntegerDigits(3);
            num.setMaximumFractionDigits(2);
            soldPercent = num.format(sold);
        }
        return soldPercent;
    }

    public String buildKeyForActivity(String organizationCode) {
        StringBuilder key = new StringBuilder();
        key.append(organizationCode);
        key.append(":");
        key.append("activity");
        key.append("*");
        return key.toString();
    }

    public String buildKeyForActivityKeys(String organizationCode) {
        StringBuilder key = new StringBuilder();
        key.append(organizationCode);
        key.append(":");
        key.append("activity");
        key.append(":");
        key.append("keys");
        return key.toString();
    }

    public String buildKeyForCurrentActivityId(String organizationCode, String activityCode) {
        StringBuilder key = new StringBuilder();
        key.append(organizationCode);
        key.append(":");
        key.append("activity");
        key.append(":");
        key.append(activityCode);
        key.append(":");
        key.append("current-activity-id");
        return key.toString();
    }

    public String buildKeyForActivityInitTime(String organizationCode, String activityCode) {
        StringBuilder key = new StringBuilder();
        key.append(organizationCode);
        key.append(":");
        key.append("activity");
        key.append(":");
        key.append(activityCode);
        key.append(":");
        key.append("init-time");
        return key.toString();
    }

    public String buildKeyForActivityStock(String organizationCode, String activityCode) {
        StringBuilder key = new StringBuilder();
        key.append(organizationCode);
        key.append(":");
        key.append("activity");
        key.append(":");
        key.append(activityCode);
        key.append(":");
        key.append("stock");
        key.append("*");
        return key.toString();
    }

    public String buildKeyForActivityStock(String organizationCode, String goodsId, String activityId, String activityCode) {
        StringBuilder key = new StringBuilder();
        key.append(organizationCode);
        key.append(":");
        key.append("activity");
        key.append(":");
        key.append(activityCode);
        key.append(":");
        key.append("stock");
        key.append(":");
        key.append(goodsId).append("_").append(activityId);
        return key.toString();
    }

    public Map<String, String> buildKeyForActivityStock(String organizationCode, String activityCode, String activityId, List<String> goodsIds) {
        HashMap<String, String> keyMap = new HashMap<String, String>(goodsIds.size());
        goodsIds.forEach(goodsId -> {
            StringBuilder key = new StringBuilder();
            key.append(organizationCode);
            key.append(":");
            key.append("activity");
            key.append(":");
            key.append(activityCode);
            key.append(":");
            key.append("stock");
            key.append(":");
            key.append((String)goodsId).append("_").append(activityId);
            keyMap.put((String)goodsId, key.toString());
        });
        return keyMap;
    }

    public String buildKeyForActivityGoods(String organizationCode, String activityId, String activityCode) {
        StringBuilder key = new StringBuilder();
        key.append(organizationCode);
        key.append(":");
        key.append("activity");
        key.append(":");
        key.append(activityCode);
        key.append(":");
        key.append("goods");
        key.append(":");
        key.append(activityId);
        return key.toString();
    }

    public String buildKeyForActivityBeginTime(String organizationCode, String activityCode) {
        StringBuilder key = new StringBuilder();
        key.append(organizationCode);
        key.append(":");
        key.append("activity");
        key.append(":");
        key.append(activityCode);
        key.append(":");
        key.append("begin-time");
        return key.toString();
    }

    public String buildKeyForActivityEndTime(String organizationCode, String activityCode) {
        StringBuilder key = new StringBuilder();
        key.append(organizationCode);
        key.append(":");
        key.append("activity");
        key.append(":");
        key.append(activityCode);
        key.append(":");
        key.append("end-time");
        return key.toString();
    }

    private String buildKeyForLoadActivityGoodsLock(String organizationCode, String activityId, String activityCode, String storeCode) {
        StringBuilder key = new StringBuilder();
        key.append(organizationCode);
        key.append(":");
        key.append("activity");
        key.append(":");
        key.append("lock");
        key.append(":");
        key.append(storeCode);
        key.append(":");
        key.append(activityCode);
        key.append(":");
        key.append("goods");
        key.append(":");
        key.append(activityId);
        return key.toString();
    }

    public boolean lockForLoadActivityGoods(String organizationCode, String activityId, String activityCode, String storeCode) {
        String lockKey = this.buildKeyForLoadActivityGoodsLock(organizationCode, activityId, activityCode, storeCode);
        BoundValueOperations loadActivityGoodsLocker = this.redisTemplate.boundValueOps((Object)lockKey);
        Boolean isLocked = loadActivityGoodsLocker.setIfAbsent((Object)true);
        if (isLocked.booleanValue()) {
            loadActivityGoodsLocker.expire(1L, TimeUnit.MINUTES);
        }
        return isLocked;
    }

    public void unlockForLoadActivityGoods(String organizationCode, String activityId, String activityCode, String storeCode) {
        String lockKey = this.buildKeyForLoadActivityGoodsLock(organizationCode, activityId, activityCode, storeCode);
        this.redisTemplate.delete((Object)lockKey);
    }

    public String buildKeyForCurrentActivityInfo(String organizationCode, String activityCode) {
        StringBuilder key = new StringBuilder();
        key.append(organizationCode);
        key.append(":");
        key.append("activity");
        key.append(":");
        key.append(activityCode);
        key.append(":");
        key.append("activity-info");
        return key.toString();
    }

    public void redisSave(Map<Object, Object> map) {
        map.keySet().forEach(key -> this.redisTemplate.boundValueOps(key).set(map.get(key)));
    }

    public void clearActivityKeys(String organizationCode, String activityCode) {
        StringBuilder keyPattern = new StringBuilder();
        keyPattern.append(organizationCode);
        keyPattern.append(":");
        keyPattern.append("activity");
        keyPattern.append(":");
        keyPattern.append(activityCode);
        keyPattern.append("*");
        Set keys = this.redisTemplate.keys((Object)keyPattern.toString());
        this.redisTemplate.delete((Collection)keys);
    }

    public ActivityInfoVO getActivityInfo(String organizationCode, String activityCode) {
        return (ActivityInfoVO)this.redisTemplate.boundValueOps((Object)this.buildKeyForCurrentActivityInfo(organizationCode, activityCode)).get();
    }
}

