/*
 * Decompiled with CFR 0.152.
 */
package activities.service.apiImpl;

import activities.api.ActivityApi;
import activities.api.ActivityConfigurationApi;
import activities.api.ActivityGoodsApi;
import activities.definition.ActivityDefinitionType;
import activities.definition.ActivityPriceType;
import activities.dto.activity.request.ActivityGoodsReqDto;
import activities.dto.activity.response.ActivityGoodsRespDto;
import activities.dto.goods.GoodsDto;
import activities.dto.goods.GoodsPictureDto;
import activities.dto.modeldto.ActivityDefinitionDto;
import activities.dto.modeldto.ActivityGoodsDto;
import activities.model.ActivityDefinition;
import activities.model.ActivityGoods;
import activities.model.repository.ActivityDefinitionRepos;
import activities.model.repository.ActivityGoodsRepos;
import activities.service.apiImpl.ActivityGoodsApiImpl;
import activities.service.service.ActivityGoodsService;
import activities.service.service.ActivityService;
import activities.vo.ActivityVo;
import cms.api.OrganizationApi;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import goods.api.GoodsApi;
import goods.api.SalesPriceRateQueryApi;
import goods.model.Goods;
import goods.model.repository.GoodsRepos;
import goods.vo.SalesPriceQueryVo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import ma.glasnost.orika.MapperFacade;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.annotation.Transactional;
import store.api.StoreApi;
import store.api.dto.modeldto.core.StoreDto;
import utils.Lang;
import utils.data.BeanMapper;
import utils.lang.Copys;
import utils.log.Log;
import utils.log.Logs;

@MotanService
@Transactional
public class ActivityGoodsApiImpl
implements ActivityGoodsApi {
    private static final Log log = Logs.getLog((String)ActivityGoodsApiImpl.class.getName());
    @Autowired
    ActivityGoodsRepos activityGoodsRepos;
    @MotanReferer
    SalesPriceRateQueryApi salesPriceRateQueryApi;
    @MotanReferer
    GoodsApi goodsApi;
    @MotanReferer
    StoreApi storeApi;
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    ActivityDefinitionRepos activityDefinitionRepos;
    @Autowired
    ActivityApi activityApi;
    @Autowired
    MapperFacade mapperFacade;
    @Autowired
    ActivityGoodsService activityGoodsService;
    @Autowired
    ActivityService activityService;
    @Autowired
    ActivityConfigurationApi activityConfigurationApi;
    @Value(value="${itaipingMobile.organization.code}")
    private String itaipingMobileOrganizationCode;
    @Autowired
    GoodsRepos goodsRepos;
    @MotanReferer
    OrganizationApi organizationApi;
    private RedisTemplate redisTemplate;

    @Autowired
    public void setRedisTemplate(RedisTemplate redisTemplate) {
        redisTemplate.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        this.redisTemplate = redisTemplate;
    }

    public List<Map<String, Object>> isActivityGoodsAndGetActivityPriceBatch(List<GoodsDto> goodsTemps, String organizationCode) {
        if (Lang.isEmpty(goodsTemps)) {
            return null;
        }
        ArrayList<Map<String, Object>> prices = new ArrayList<Map<String, Object>>();
        for (GoodsDto goodsTemp : goodsTemps) {
            Map activityPrice = this.isActivityGoodsAndGetActivityPrice(goodsTemp, organizationCode);
            prices.add(activityPrice);
        }
        return prices;
    }

    public Map<String, Object> isActivityGoodsAndGetActivityPrice(GoodsDto goodsParam, String organizationCode) {
        HashMap<String, Object> activitiesGoodsInfo = new HashMap<String, Object>();
        if (Lang.isEmpty((Object)goodsParam)) {
            activitiesGoodsInfo.put("isActivityGoods", false);
            activitiesGoodsInfo.put("activityPrice", new BigDecimal(0));
        } else {
            Goods goods = (Goods)this.mapperFacade.map((Object)goodsParam, Goods.class);
            activitiesGoodsInfo.put("goodsId", goods.getId());
            List pricesInfo = this.activityGoodsRepos.findActivityPrice(goods.getId(), organizationCode);
            if (pricesInfo == null || pricesInfo.isEmpty()) {
                activitiesGoodsInfo.put("isActivityGoods", false);
                return activitiesGoodsInfo;
            }
            Map objectMap = (Map)pricesInfo.get(0);
            activitiesGoodsInfo.put("isActivityGoods", true);
            activitiesGoodsInfo.put("activityId", objectMap.get("activityId"));
            if (ActivityGoodsDto.ACTIVITY_PRICE_TYPE_WITHOUTRATE.equals(objectMap.get("type"))) {
                activitiesGoodsInfo.put("activityPrice", goods.getCostPrice());
            } else if (ActivityGoodsDto.ACTIVITY_PRICE_TYPE_ACPRICE.equals(objectMap.get("type"))) {
                activitiesGoodsInfo.put("activityPrice", new BigDecimal(objectMap.get("activityPrice") + ""));
            } else if (ActivityGoodsDto.ACTIVITY_PRICE_TYPE_WITHRATE.equals(objectMap.get("type"))) {
                BigDecimal salePrice;
                goods = (Goods)this.goodsRepos.findOne((Serializable)((Object)goods.getId()));
                StoreDto store = this.storeApi.getStoreInfo(goods.getStoreId());
                String storeCode = store.getStoreExt().getCode();
                goods.dto.goods.GoodsDto goodsDTO = new goods.dto.goods.GoodsDto();
                Copys.create().from((Object)goods).excludes(new String[]{"product", "goodsAttrs", "goodsPictures", "goodsFashions", "goodsParams", "productFashion"}).to(new Object[]{goodsDTO});
                SalesPriceQueryVo salesPriceQueryVo = new SalesPriceQueryVo(organizationCode, storeCode, goodsDTO);
                List mapList = this.salesPriceRateQueryApi.getSalesPriceListByParams(Arrays.asList(salesPriceQueryVo));
                if (!Lang.isEmpty((Object)mapList) && !Lang.isEmpty((Object)(salePrice = (BigDecimal)((Map)mapList.get(0)).get("salePrice")))) {
                    activitiesGoodsInfo.put("activityPrice", salePrice);
                }
            }
        }
        return activitiesGoodsInfo;
    }

    public ActivityDefinitionType getActivityDefinitionType(ActivityDefinition activityDefinition) {
        Date now = new Date();
        ActivityDefinitionType activityDefinitionType = null;
        if (now.before(activityDefinition.getBeginTime())) {
            activityDefinitionType = ActivityDefinitionType.beforeStart;
        } else if (now.after(activityDefinition.getBeginTime()) && now.before(activityDefinition.getEndTime())) {
            activityDefinitionType = ActivityDefinitionType.onGoing;
        } else if (now.after(activityDefinition.getEndTime())) {
            activityDefinitionType = ActivityDefinitionType.end;
        }
        return activityDefinitionType;
    }

    public ActivityGoodsRespDto isActivityGoodsAndGetActivityPrice(ActivityGoodsReqDto activityGoodsReqDto) {
        ActivityGoods activityGoods = this.activityGoodsRepos.findByGoodsIdAndActivityDefinitionIdAndIsOnlineAndIsDelete(activityGoodsReqDto.getGoodsId(), activityGoodsReqDto.getActivityInfoId(), true, false);
        ActivityGoodsRespDto activityGoodsRespDto = new ActivityGoodsRespDto();
        if (activityGoods != null) {
            goods.dto.goods.GoodsDto goods = null;
            BigDecimal activityPrice = null;
            ActivityDefinition activityDefinition = activityGoods.getActivityDefinition();
            switch (1.$SwitchMap$activities$definition$ActivityPriceType[((ActivityPriceType)ActivityPriceType.activityPriceTypeMap.get(activityGoods.getType())).ordinal()]) {
                case 1: {
                    Goods goodsPO = (Goods)this.goodsRepos.findOne((Serializable)((Object)activityGoods.getGoodsId()));
                    goods = new goods.dto.goods.GoodsDto();
                    Copys.create().from((Object)goodsPO).excludes(new String[]{"product", "goodsAttrs", "goodsPictures", "goodsFashions", "goodsParams", "productFashion"}).to(new Object[]{goods});
                    StoreDto store = this.storeApi.getStoreInfo(goods.getStoreId());
                    String storeCode = store.getStoreExt().getCode();
                    SalesPriceQueryVo salesPriceQueryVo = new SalesPriceQueryVo(activityDefinition.getOrganizationCode(), storeCode, goods);
                    List mapList = this.salesPriceRateQueryApi.getSalesPriceListByParams(Arrays.asList(salesPriceQueryVo));
                    if (Lang.isEmpty((Object)mapList)) break;
                    activityPrice = (BigDecimal)((Map)mapList.get(0)).get("salePrice");
                    break;
                }
                case 2: {
                    activityPrice = this.goodsApi.findCostPriceById(activityGoods.getGoodsId());
                    break;
                }
                case 3: {
                    activityPrice = activityGoods.getGoodsPrice();
                    break;
                }
            }
            activityGoodsRespDto.setActivitylPrice(activityPrice);
            ActivityDefinitionType activityDefinitionType = this.getActivityDefinitionType(activityDefinition);
            activityGoodsRespDto.setActivityDefinitionType(activityDefinitionType);
        } else {
            activityGoodsRespDto.setActivityDefinitionType(ActivityDefinitionType.noExist);
        }
        return activityGoodsRespDto;
    }

    public void increamentSaleCount(String activityDefinitionId, String goodsId, Integer buyCount) {
        String sql = "update Activity_Goods set sold_Num=sold_Num + ? where activity_Definition_id=? and goods_Id=?";
        this.jdbcTemplate.update(sql, new Object[]{buyCount, activityDefinitionId, goodsId});
    }

    public List<ActivityGoodsDto> findActivityGoodsByGoodsIdAndActivityId(String goodsId, String activityId) {
        ActivityDefinition activityDefinition = new ActivityDefinition();
        activityDefinition.setId(activityId);
        List activityGoodsList = this.activityGoodsRepos.findByGoodsIdAndActivityDefinitionAndIsDelete(goodsId, activityDefinition, false);
        return BeanMapper.mapList((Iterable)activityGoodsList, ActivityGoods.class, ActivityGoodsDto.class);
    }

    public boolean changeActivityGoodsStock(String goodsId, String activityId, int count) {
        List activityGoodsList = this.findActivityGoodsByGoodsIdAndActivityId(goodsId, activityId);
        if (activityGoodsList.size() == 1) {
            ActivityGoodsDto activityGoods = (ActivityGoodsDto)activityGoodsList.get(0);
            String key = this.activityConfigurationApi.buildKeyForActivityStock(activityGoods.getActivityDefinition().getOrganizationCode(), goodsId, activityId, activityGoods.getActivityDefinition().getActivityCode());
            BoundValueOperations boundValueOperations = this.redisTemplate.boundValueOps((Object)key);
            if (!Lang.isEmpty((Object)boundValueOperations.get())) {
                log.info((Object)"=====================\u6d3b\u52a8\u5546\u54c1\u51cf\u5e93\u5b58goodsId={}\uff0cactivityId={}\uff0ccount={}", new Object[]{goodsId, activityId, count});
                Long number = boundValueOperations.increment((long)(-count));
                log.info((Object)"=====================\u6d3b\u52a8\u5546\u54c1\u51cf\u5e93\u5b58\u540e\u5269\u4f59goodsId={}\uff0cactivityId={}\uff0ccount={}\uff0cnumber={}", new Object[]{goodsId, activityId, count, number});
                if (number >= 0L) {
                    int updateRow = this.changeActivityGoodsStockFromDataBase(((ActivityGoodsDto)activityGoodsList.get(0)).getId(), count);
                    log.info((Object)"=====================\u6d3b\u52a8\u5546\u54c1\u66f4\u65b0\u6570\u636e\u5e93\u540e\u5f71\u54cd\u884c\u6570goodsId={}\uff0cactivityId={}\uff0ccount={}\uff0cupdateRow={}", new Object[]{goodsId, activityId, count, updateRow});
                    if (updateRow > 0) {
                        return true;
                    }
                    boundValueOperations.increment((long)count);
                } else {
                    boundValueOperations.increment((long)count);
                }
            } else {
                log.error((Object)"\u7f13\u5b58\u4e2d\u6ca1\u6709\u627e\u5230\u5339\u914d\u5546\u54c1ID{}\u4e0e\u573a\u6b21ID{}\u7684\u5e93\u5b58\u6570\u636e\uff01", new Object[]{goodsId, activityId});
            }
        } else {
            log.error((Object)"\u6839\u636e\u5546\u54c1ID{}\u4e0e\u573a\u6b21ID{}\u627e\u5230\u6570\u636e\u96c6\u5408\u5927\u5c0f\u4e0d\u662f\u671f\u671b\u503c[1]\u5b9e\u9645\u5927\u5c0f[{}]", new Object[]{goodsId, activityId, activityGoodsList.size()});
        }
        return false;
    }

    public int getCurrentActivityGoodsStockFromCache(String organizationCode, String goodsId, String activityId, String activityCode) {
        int stock = 0;
        String key = this.activityConfigurationApi.buildKeyForActivityStock(organizationCode, goodsId, activityId, activityCode);
        BoundValueOperations boundValueOperations = this.redisTemplate.boundValueOps((Object)key);
        if (!Lang.isEmpty((Object)boundValueOperations.get())) {
            stock = (Integer)boundValueOperations.get();
        }
        return stock;
    }

    private int changeActivityGoodsStockFromDataBase(String activityGoodsId, int count) {
        String sql = "UPDATE activity_goods ag SET ag.sold_num = (ag.sold_num + ?), ag.stock_num = (ag.stock_num - ?) WHERE ag.id = ? AND ag.stock_num > 0";
        return this.jdbcTemplate.update(sql, new Object[]{count, count, activityGoodsId});
    }

    public BigDecimal getActivityPrice(String goodsId, String organizationCode, String storeCode) {
        Long getSalePriceTime = System.currentTimeMillis();
        BigDecimal salePrice = this.getActivityPriceNew(goodsId, organizationCode, storeCode);
        log.info((Object)"\u83b7\u53d6\u5546\u54c1\u4ef7\u683c goodsId = {}, organizationCode = {}, storeCode = {}, SalePrice = {} \u8017\u65f6 {} ms", new Object[]{goodsId, organizationCode, storeCode, salePrice, System.currentTimeMillis() - getSalePriceTime});
        return salePrice;
    }

    public BigDecimal getEffectiveOrderCount(String memberId, String activityId) {
        return this.activityDefinitionRepos.hasEffectiveOrder(memberId, activityId);
    }

    public void increamentSoldNumAndStockNum(String activityId, String goodsId, Integer buyNum) {
        String sql = "update Activity_Goods set sold_Num = (sold_Num + ?), stock_Num = (stock_Num - ?) where activity_Definition_id = ? and goods_Id = ?";
        this.jdbcTemplate.update(sql, new Object[]{buyNum, buyNum, activityId, goodsId});
    }

    public void backActivityGoodsStockAndSolcNum(String goodsId, String activityId, Integer count, String organizationCode) {
        this.increamentSoldNumAndStockNum(activityId, goodsId, Integer.valueOf(-count.intValue()));
        ActivityDefinitionDto activityDefinition = this.activityApi.findById(activityId);
        String key = this.activityConfigurationApi.buildKeyForActivityStock(organizationCode, goodsId, activityId, activityDefinition.getActivityCode());
        BoundValueOperations boundValueOperations = this.redisTemplate.boundValueOps((Object)key);
        if (!Lang.isEmpty((Object)boundValueOperations.get())) {
            boundValueOperations.increment((long)count.intValue());
        }
    }

    public boolean isActivityLimited(String memberId, String activityId, int limitedCount) {
        BigDecimal count = this.getEffectiveOrderCount(memberId, activityId);
        return count.intValue() >= limitedCount;
    }

    public ActivityDefinitionType getActivityDefinitionType(ActivityDefinitionDto activityDefinition) {
        Date now = new Date();
        ActivityDefinitionType activityDefinitionType = null;
        if (now.before(activityDefinition.getBeginTime())) {
            activityDefinitionType = ActivityDefinitionType.beforeStart;
        } else if (now.after(activityDefinition.getBeginTime()) && now.before(activityDefinition.getEndTime())) {
            activityDefinitionType = ActivityDefinitionType.onGoing;
        } else if (now.after(activityDefinition.getEndTime())) {
            activityDefinitionType = ActivityDefinitionType.end;
        }
        return activityDefinitionType;
    }

    public List<ActivityGoodsDto> findByGiftClass(String giftClass, String activityDefinitionId) {
        List activityGoods = this.activityGoodsRepos.findByGiftClassAndActivityDefinitionId(giftClass, activityDefinitionId);
        activityGoods = activityGoods.stream().filter(activityGoods1 -> activityGoods1.getIsDelete() == false && activityGoods1.getIsOnline() != false).sorted(Comparator.comparing(ActivityGoods::getShowIndex)).collect(Collectors.toList());
        return this.mapperFacade.mapAsList(activityGoods, ActivityGoodsDto.class);
    }

    public ActivityGoodsDto saveActivityGoods(ActivityGoodsDto activityGoodsDto) {
        if (Lang.isEmpty((Object)activityGoodsDto)) {
            return null;
        }
        ActivityGoods activityGoods = (ActivityGoods)this.activityGoodsRepos.save(this.mapperFacade.map((Object)activityGoodsDto, ActivityGoods.class));
        if (Lang.isEmpty((Object)activityGoods)) {
            return null;
        }
        return (ActivityGoodsDto)this.mapperFacade.map((Object)activityGoods, ActivityGoodsDto.class);
    }

    public String isInActivityNow(String goodsId, String organizationCode) {
        List activityMaps = this.activityGoodsRepos.findActivityPrice(goodsId, organizationCode);
        if (Lang.isEmpty((Object)activityMaps)) {
            return null;
        }
        return (String)((Map)activityMaps.get(0)).get("activityId");
    }

    public void setActivityPrice(List<ActivityVo> activityVoList, String organizationCode, String storeCode) {
        ArrayList<goods.dto.goods.GoodsDto> ratePriceQueryGoodsList = new ArrayList<goods.dto.goods.GoodsDto>();
        List goodsIds = activityVoList.stream().map(ActivityVo::getGoodsPicture).map(GoodsPictureDto::getGoods).map(GoodsDto::getId).collect(Collectors.toList());
        long activityMapsTime = System.currentTimeMillis();
        List activityMaps = this.activityGoodsRepos.findActivityPrice(goodsIds, organizationCode);
        log.info((Object)"\u6d3b\u52a8\u4fe1\u606f\u67e5\u8be2\u8017\u65f6 {} ms", new Object[]{System.currentTimeMillis() - activityMapsTime});
        for (ActivityVo activityVO : activityVoList) {
            goods.dto.goods.GoodsDto goodsDTO = (goods.dto.goods.GoodsDto)BeanMapper.map((Object)activityVO.getGoodsPicture().getGoods(), goods.dto.goods.GoodsDto.class);
            if (Lang.isEmpty((Object)activityMaps)) continue;
            for (Map activityMap : activityMaps) {
                String goodsId2 = (String)activityMap.get("goodsId");
                if (!goodsDTO.getId().equals(goodsId2)) continue;
                String keyForPriceType = "type";
                String priceType = (String)activityMap.get(keyForPriceType);
                if (ActivityGoodsDto.ACTIVITY_PRICE_TYPE_ACPRICE.equals(priceType)) {
                    String keyForActivitySetPrice = "activityPrice";
                    Object activityPrice = activityMap.get(keyForActivitySetPrice);
                    if (!Lang.isEmpty(activityPrice)) {
                        activityVO.getGoodsPicture().getGoods().setSalePrice(new BigDecimal(String.valueOf(activityPrice)));
                        continue;
                    }
                    log.warn((Object)"\u4f7f\u7528\u6d3b\u52a8\u914d\u7f6e\u4ef7\u683c\u65b9\u6848\u5931\u8d25 : \u6d3b\u52a8\u914d\u7f6e\u4ef7\u683c\u4e3a\u7a7a, \u5c06\u4f7f\u7528\u9ed8\u8ba4\u8d39\u7387\u4ef7\u683c\u65b9\u6848");
                    continue;
                }
                if (ActivityGoodsDto.ACTIVITY_PRICE_TYPE_WITHOUTRATE.equals(priceType)) {
                    activityVO.getGoodsPicture().getGoods().setSalePrice(goodsDTO.getCostPrice());
                    continue;
                }
                ratePriceQueryGoodsList.add(goodsDTO);
            }
        }
        if (!Lang.isEmpty(ratePriceQueryGoodsList)) {
            String organizationId = this.organizationApi.findOrganizationIdByOrgCode(organizationCode);
            long salesPriceRateQueryTime = System.currentTimeMillis();
            Map salePriceMap = this.salesPriceRateQueryApi.getSaleRatePriceBatchByGoodsList(ratePriceQueryGoodsList, storeCode, organizationId);
            log.info((Object)"\u6279\u91cf\u67e5\u8be2\u8d39\u7387\u4ef7\u683c (GoodsDTO\u96c6\u5408\u65b9\u5f0f) \u8017\u65f6 {} ms", new Object[]{System.currentTimeMillis() - salesPriceRateQueryTime});
            salePriceMap.keySet().forEach(goodsId -> {
                for (ActivityVo activityVo : activityVoList) {
                    if (!goodsId.equals(activityVo.getGoodsPicture().getGoods().getId())) continue;
                    activityVo.getGoodsPicture().getGoods().setSalePrice(((BigDecimal)salePriceMap.get(goodsId)).setScale(2, 0));
                    break;
                }
            });
        }
    }

    public List<ActivityGoodsDto> findByExample(ActivityGoodsDto activityGoodsExample) {
        return this.activityGoodsService.findByExample(activityGoodsExample);
    }

    public boolean checkCacheStock(String organizationCode, String activityId, String activityCode, String goodsId, Integer count) {
        String key = this.activityConfigurationApi.buildKeyForActivityStock(organizationCode, goodsId, activityId, activityCode);
        BoundValueOperations boundValueOperations = this.redisTemplate.boundValueOps((Object)key);
        Long stock = (Long)boundValueOperations.get();
        if (!Lang.isEmpty((Object)stock) && stock - (long)count.intValue() > 0L) {
            return true;
        }
        log.error((Object)"\u7f13\u5b58\u4e2d\u6ca1\u6709\u627e\u5230\u5339\u914d\u5546\u54c1ID{}\u4e0e\u573a\u6b21ID{}\u7684\u5e93\u5b58\u6570\u636e\uff01", new Object[]{goodsId, activityId});
        return false;
    }

    private BigDecimal getActivityPriceNew(String goodsId, String organizationCode, String storeCode) {
        long activityMapsTime = System.currentTimeMillis();
        List activityMaps = this.activityGoodsRepos.findActivityPrice(goodsId, organizationCode);
        log.info((Object)"\u67e5\u8be2\u6d3b\u52a8\u4fe1\u606f\u8017\u65f6 {} ms", new Object[]{System.currentTimeMillis() - activityMapsTime});
        long goodsTime = System.currentTimeMillis();
        Goods goods = (Goods)this.goodsRepos.findOne((Serializable)((Object)goodsId));
        log.info((Object)"\u67e5\u8be2 goods \u8017\u65f6 {} ms", new Object[]{System.currentTimeMillis() - goodsTime});
        if (!Lang.isEmpty((Object)activityMaps)) {
            String keyForPriceType;
            Map activityMap = (Map)activityMaps.get(0);
            String priceType = (String)activityMap.get(keyForPriceType = "type");
            if (ActivityGoodsDto.ACTIVITY_PRICE_TYPE_WITHOUTRATE.equals(priceType)) {
                return goods.getCostPrice();
            }
            if (ActivityGoodsDto.ACTIVITY_PRICE_TYPE_ACPRICE.equals(priceType)) {
                String keyForActivitySetPrice = "activityPrice";
                Object activityPrice = activityMap.get(keyForActivitySetPrice);
                if (!Lang.isEmpty(activityPrice)) {
                    return new BigDecimal(String.valueOf(activityPrice));
                }
                log.warn((Object)"\u4f7f\u7528\u6d3b\u52a8\u914d\u7f6e\u4ef7\u683c\u65b9\u6848\u5931\u8d25 : \u6d3b\u52a8\u914d\u7f6e\u4ef7\u683c\u4e3a\u7a7a, \u5c06\u4f7f\u7528\u9ed8\u8ba4\u8d39\u7387\u4ef7\u683c\u65b9\u6848");
            }
        }
        goods.dto.goods.GoodsDto goodsDto = new goods.dto.goods.GoodsDto();
        Copys.create().from((Object)goods).excludes(new String[]{"product", "goodsAttrs", "goodsPictures", "goodsFashions", "goodsParams", "productFashion"}).to(new Object[]{goodsDto});
        long salePriceTime = System.currentTimeMillis();
        SalesPriceQueryVo salesPriceQueryVo = new SalesPriceQueryVo(organizationCode, storeCode, goodsDto);
        List rateSalePriceMaps = this.salesPriceRateQueryApi.getSalesPriceListByParams(Collections.singletonList(salesPriceQueryVo));
        BigDecimal salePrice = (BigDecimal)((Map)rateSalePriceMaps.get(0)).get("salePrice");
        log.info((Object)"\u6279\u91cf\u67e5\u8be2\u8d39\u7387\u4ef7\u683c\u8017\u65f6 {} ms", new Object[]{System.currentTimeMillis() - salePriceTime});
        return salePrice;
    }
}

