/*
 * Decompiled with CFR 0.152.
 */
package activities.service.apiImpl;

import activities.api.ActivityApi;
import activities.api.ActivityConfigurationApi;
import activities.dto.modeldto.ActivityDefinitionDto;
import activities.model.ActivityDefinition;
import activities.model.ActivityGoods;
import activities.model.ActivityTheme;
import activities.model.repository.ActivityDefinitionRepos;
import activities.model.repository.ActivityThemeRepos;
import activities.service.service.ActivityService;
import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ma.glasnost.orika.MapperFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import utils.Lang;
import utils.data.BeanMapper;
import utils.lang.Copys;

@MotanService
public class ActivityImpl
implements ActivityApi {
    private static final Logger log = LoggerFactory.getLogger(ActivityImpl.class);
    @Autowired
    ActivityDefinitionRepos activityDefinitionRepos;
    @Autowired
    ActivityThemeRepos activityThemeRepos;
    @Autowired
    ActivityConfigurationApi activityConfigurationApi;
    @Autowired
    MapperFacade mapperFacade;
    @Autowired
    private ActivityService activityService;

    public ActivityDefinitionDto findByOrganizationCodeAndActivityCode(String organizationCode, String activityCode) {
        ActivityDefinition activityDefinition = this.activityDefinitionRepos.findByOrganizationCodeAndActivityCode(organizationCode, activityCode);
        this.copyValueForActivityDefinition(activityDefinition);
        return (ActivityDefinitionDto)BeanMapper.map((Object)activityDefinition, ActivityDefinitionDto.class);
    }

    public void copyValueForActivityDefinition(ActivityDefinition activityDefinition) {
        ArrayList<ActivityTheme> activityThemeList = new ArrayList<ActivityTheme>();
        ArrayList<ActivityGoods> activityGoodsList = new ArrayList<ActivityGoods>();
        if (activityDefinition != null) {
            if (activityDefinition.getActivityThemes() != null) {
                for (ActivityTheme activityTheme : activityDefinition.getActivityThemes()) {
                    ActivityTheme activityTheme1 = new ActivityTheme();
                    Copys.create().excludes(new String[]{"activityDefinition"}).from((Object)activityTheme).to(new Object[]{activityTheme1});
                    activityThemeList.add(activityTheme1);
                }
                activityDefinition.setActivityThemes(activityThemeList);
            }
            if (activityDefinition.getActivityGoodses() != null) {
                for (ActivityGoods activityGoods : activityDefinition.getActivityGoodses()) {
                    ActivityGoods activityGoods1 = new ActivityGoods();
                    Copys.create().excludes(new String[]{"activityDefinition"}).from((Object)activityGoods).to(new Object[]{activityGoods1});
                    activityGoodsList.add(activityGoods1);
                }
                activityDefinition.setActivityGoodses(activityGoodsList);
            }
        }
    }

    public List<ActivityDefinitionDto> findSecKillActivity(String organizationCode, String activityCode) {
        List list = this.activityDefinitionRepos.findByOrganizationCodeAndActivityCodeAndIsOnline(organizationCode, activityCode, true, new Sort(Sort.Direction.ASC, new String[]{"beginTime"}));
        ArrayList<ActivityDefinition> activityDefinitions = new ArrayList<ActivityDefinition>();
        for (ActivityDefinition activityDefinition : list) {
            if (Lang.isEmpty((Object)activityDefinition.getEndTime())) continue;
            if (activityDefinition.getEndTime().before(new Date())) {
                activityDefinition.setIsOnline(Boolean.valueOf(false));
                this.activityDefinitionRepos.saveAndFlush((Object)activityDefinition);
                continue;
            }
            activityDefinitions.add(activityDefinition);
        }
        if (list.size() != 0 && activityDefinitions.size() == 0) {
            ArrayList<String> activityCodeList = new ArrayList<String>();
            activityCodeList.add(activityCode);
            this.activityConfigurationApi.reload(organizationCode, activityCodeList);
        }
        return this.mapperFacade.mapAsList(activityDefinitions, ActivityDefinitionDto.class);
    }

    public ActivityDefinitionDto findById(String id) {
        ActivityDefinition activityDefinition = (ActivityDefinition)this.activityDefinitionRepos.findOne((Serializable)((Object)id));
        this.copyValueForActivityDefinition(activityDefinition);
        return (ActivityDefinitionDto)BeanMapper.map((Object)activityDefinition, ActivityDefinitionDto.class);
    }

    public boolean hasEffectiveOrder(String memberId, String activtyId) {
        BigDecimal count = this.activityDefinitionRepos.hasEffectiveOrder(memberId, activtyId);
        return count.intValue() > 0;
    }

    public void setActivityDefinitionIsOnline(String activtyId) {
        ActivityDefinition activityDefinition = (ActivityDefinition)this.activityDefinitionRepos.findOne((Serializable)((Object)activtyId));
        this.copyValueForActivityDefinition(activityDefinition);
        activityDefinition.setIsOnline(Boolean.valueOf(false));
        this.activityDefinitionRepos.save((Object)activityDefinition);
    }

    public ActivityDefinitionDto findByOrganizationCode(String organizationCode, String ctAtivityCode) {
        ActivityDefinition activityDefinition = this.activityDefinitionRepos.findByOrganizationCodeAndActivityCode(organizationCode, ctAtivityCode);
        return (ActivityDefinitionDto)BeanMapper.map((Object)activityDefinition, ActivityDefinitionDto.class);
    }

    public List<ActivityDefinitionDto> findByExample(ActivityDefinitionDto activityDefinitionDto) {
        return this.activityService.findByExample(activityDefinitionDto);
    }

    public ActivityDefinitionDto saveOrUpdate(ActivityDefinitionDto activityDefinitionDto) {
        return this.activityService.saveOrUpdate(activityDefinitionDto);
    }
}

