/*
 * Decompiled with CFR 0.152.
 */
package activities.service.apiImpl;

import activities.api.GroupBuyingApi;
import activities.dto.activity.request.OrderRequstVo;
import activities.dto.activity.response.OrderResponseVo;
import activities.dto.groupbuying.request.GbActivityInfoReqDto;
import activities.dto.groupbuying.request.GbGroupInfoReqDto;
import activities.dto.groupbuying.request.GbGroupJoinReqDto;
import activities.dto.groupbuying.request.GroupBuyingGoodsReqDto;
import activities.dto.groupbuying.request.GroupInfoHandleRequestDto;
import activities.dto.groupbuying.response.GbActivityInfoRespDto;
import activities.dto.groupbuying.response.GbGroupInfoRespDto;
import activities.dto.groupbuying.response.GbGroupJoinRespDto;
import activities.dto.groupbuying.response.GbOrderInfoDto;
import activities.dto.groupbuying.response.GroupBuyingGoodsRespDto;
import activities.dto.groupbuying.response.GroupInfoHandleResponseDto;
import activities.model.groupbuying.GbOrderInfo;
import activities.service.service.GroupBuyingService;
import cart.api.dto.payment.PaymentReturnVo;
import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import ma.glasnost.orika.MapperFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import sinomall.config.api.base.BaseResponse;
import utils.Lang;
import utils.lock.RedisLockUtil;

@MotanService
public class GroupBuyingApiImpl
implements GroupBuyingApi {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    GroupBuyingService groupBuyingService;
    @Autowired
    RedisLockUtil redisLockUtil;
    @Autowired
    MapperFacade mapperFacade;

    public GroupBuyingGoodsRespDto queryGroupBuyingGoodsPrice(GroupBuyingGoodsReqDto groupBuyingGoodsReqDto) {
        return this.groupBuyingService.queryGroupBuyingGoodsPrice(groupBuyingGoodsReqDto);
    }

    public GbGroupJoinRespDto queryGbGroupJoinNumber(GbGroupJoinReqDto gbGroupJoinReqDto) {
        return this.groupBuyingService.queryGbGroupJoinNumber(gbGroupJoinReqDto);
    }

    public OrderResponseVo createOrder(OrderRequstVo orderRequstVo) {
        return this.groupBuyingService.createOrder(orderRequstVo);
    }

    public GroupInfoHandleResponseDto handleGroupInfo(GroupInfoHandleRequestDto hanleGroupRequestDto) {
        try {
            if (!StringUtils.isEmpty((Object)hanleGroupRequestDto.getGbGroupId())) {
                this.redisLockUtil.lock("ACTIVITY:PINGTUAN:LOCK:" + hanleGroupRequestDto.getGbGroupId());
            }
            GroupInfoHandleResponseDto groupInfoHandleResponseDto = this.groupBuyingService.handleGroupInfo(hanleGroupRequestDto);
            return groupInfoHandleResponseDto;
        }
        catch (Exception e) {
            this.logger.error("\u5904\u7406\u56e2\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            throw e;
        }
        finally {
            if (!StringUtils.isEmpty((Object)hanleGroupRequestDto.getGbGroupId())) {
                this.redisLockUtil.unlock("ACTIVITY:PINGTUAN:LOCK:" + hanleGroupRequestDto.getGbGroupId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseResponse cancelGbOrder(String orderNo) {
        GbOrderInfo gbOrderInfo = this.groupBuyingService.findByOrderNo(orderNo);
        if (gbOrderInfo != null) {
            String groupInfoId = "";
            try {
                this.redisLockUtil.lock("ACTIVITY:PINGTUAN:LOCK::order:" + gbOrderInfo.getOrderNo());
                if (gbOrderInfo.getGbGroupJoin() != null && gbOrderInfo.getGbGroupJoin().getGbGroupInfo() != null) {
                    groupInfoId = gbOrderInfo.getGbGroupJoin().getGbGroupInfo().getId();
                    this.redisLockUtil.lock("ACTIVITY:PINGTUAN:LOCK::group:" + groupInfoId);
                }
                BaseResponse baseResponse = this.groupBuyingService.cancelGbOrder(gbOrderInfo);
                return baseResponse;
            }
            catch (Exception e) {
                this.logger.error("\u53d6\u6d88\u56e2\u8d2d\u8ba2\u5355\u5931\u8d25", (Throwable)e);
                BaseResponse baseResponse = new BaseResponse("error", "\u62fc\u56e2\u8ba2\u5355\u53d6\u6d88\u5931\u8d25");
                return baseResponse;
            }
            finally {
                this.redisLockUtil.unlock("ACTIVITY:PINGTUAN:LOCK::order:" + gbOrderInfo.getOrderNo());
                this.redisLockUtil.unlock("ACTIVITY:PINGTUAN:LOCK::group:" + groupInfoId);
            }
        }
        return new BaseResponse("success", "\u8be5\u8ba2\u5355\u4e0d\u662f\u62fc\u56e2\u8ba2\u5355");
    }

    public BaseResponse gbPayback(activities.vo.payment.PaymentReturnVo paymentReturnVoParam) {
        PaymentReturnVo paymentReturnVo = Lang.isEmpty((Object)paymentReturnVoParam) ? null : (PaymentReturnVo)this.mapperFacade.map((Object)paymentReturnVoParam, PaymentReturnVo.class);
        return this.groupBuyingService.gbPayback(paymentReturnVo);
    }

    public GbOrderInfoDto queryGroupOrderInfo(String orderNo) {
        return this.groupBuyingService.queryGroupOrderInfo(orderNo);
    }

    public String findOrderNoByMemberIdAndGroupId(String memberId, String groupId) {
        return this.groupBuyingService.findOrderNoByMemberIdAndGroupId(memberId, groupId);
    }

    public GbGroupInfoRespDto queryGbGroupInfo(GbGroupInfoReqDto gbGroupInfoReqDto) {
        return this.groupBuyingService.queryGbGroupInfoRespDto(gbGroupInfoReqDto);
    }

    public GbActivityInfoRespDto queryGbActivityInfoById(GbActivityInfoReqDto gbActivityInfoReqDto) {
        return this.groupBuyingService.queryGbActivityInfoRespDto(gbActivityInfoReqDto);
    }

    public void queryActivityGroupStatusAndHandle() {
        this.groupBuyingService.queryActivityGroupStatusAndHandle();
    }
}

