/*
 * Decompiled with CFR 0.152.
 */
package activities.service.config;

import activities.service.hibernate.CacheEventListener;
import javax.persistence.EntityManagerFactory;
import org.hibernate.SessionFactory;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.hibernate.internal.SessionFactoryImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;

@Configuration
@ComponentScan(value={"utils.sql"})
@EntityScan(basePackages={"tp.score.model", "activities.model", "goods.model"})
@EnableJpaRepositories(basePackages={"tp.score.model.repository", "activities.model.repository", "goods.model.repository"})
public class JpaConfig {
    @Autowired
    private EntityManagerFactory entityManagerFactory;

    CacheEventListener cacheEventListener() {
        return new CacheEventListener();
    }

    public void registerListeners() {
        SessionFactory sessionFactory = (SessionFactory)this.entityManagerFactory.unwrap(SessionFactory.class);
        CacheEventListener cacheEventListener = this.cacheEventListener();
        EventListenerRegistry registry = (EventListenerRegistry)((SessionFactoryImpl)sessionFactory).getServiceRegistry().getService(EventListenerRegistry.class);
        registry.getEventListenerGroup(EventType.POST_INSERT).appendListener((Object)cacheEventListener);
        registry.getEventListenerGroup(EventType.POST_UPDATE).appendListener((Object)cacheEventListener);
        registry.getEventListenerGroup(EventType.POST_DELETE).appendListener((Object)cacheEventListener);
    }
}

