/*
 * Decompiled with CFR 0.152.
 */
package activities.service.service;

import activities.api.ActivityConfigurationApi;
import activities.dto.modeldto.ActivityGoodsDto;
import activities.model.ActivityGoods;
import activities.model.repository.ActivityGoodsRepos;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import utils.Lang;
import utils.data.BeanMapper;
import utils.log.Log;
import utils.log.Logs;

@Component
@Transactional(readOnly=true)
public class ActivityGoodsService {
    private static final Log log = Logs.getLog((String)ActivityGoodsService.class.getName());
    @Autowired
    private RedisTemplate redisTemplate;
    @Autowired
    ActivityGoodsRepos activityGoodsRepos;
    @Autowired
    ActivityConfigurationApi activityConfigurationApi;

    public void loadStockToRedis(String organizationCode, String activityCode) {
        int success = 0;
        log.info((Object)"\u6d3b\u52a8\u4fe1\u606f organizationCode : {}, activityCode: {}", new Object[]{organizationCode, activityCode});
        List activityGoodsList = this.activityGoodsRepos.findActivityGoods(organizationCode, activityCode);
        log.info((Object)"\u5bf9\u5e94\u6d3b\u52a8\u5546\u54c1\u6570\u91cf\uff1a{}", new Object[]{activityGoodsList.size()});
        for (ActivityGoods ag : activityGoodsList) {
            if (!Lang.isEmpty((Object)ag.getStockNum())) {
                String key = this.activityConfigurationApi.buildKeyForActivityStock(organizationCode, ag.getGoodsId(), ag.getActivityDefinition().getId(), activityCode);
                this.activityConfigurationApi.setActivityKey(organizationCode, key);
                BoundValueOperations boundValueOperations = this.redisTemplate.boundValueOps((Object)key);
                log.info((Object)"===\u521d\u59cb\u5316\u6d3b\u52a8\u5546\u54c1\u5e93\u5b58key={}\uff0cstockNum={}", new Object[]{key, ag.getStockNum()});
                boundValueOperations.set((Object)ag.getStockNum());
                ++success;
                continue;
            }
            log.error((Object)"\u7f13\u5b58\u6d3b\u52a8\u5546\u54c1\u914d\u7f6e\u5e93\u5b58\u5931\u8d25\uff0c\u914d\u7f6e\u5e93\u5b58\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5 activity_goods \u8868\u4e3b\u952e\u4e3a {} \u7684\u6570\u636e", new Object[]{ag.getId()});
        }
        log.info((Object)"\u6210\u529f\u7f13\u5b58\u6d3b\u52a8\u5546\u54c1\u6570\u91cf\uff1a{}", new Object[]{success});
    }

    public List<ActivityGoodsDto> findByExample(ActivityGoodsDto activityGoodsDto) {
        ActivityGoods activityGoods = (ActivityGoods)BeanMapper.map((Object)activityGoodsDto, ActivityGoods.class);
        List activityDefinitions = this.activityGoodsRepos.findAll(this.createExample(activityGoods));
        return BeanMapper.mapList((Iterable)activityDefinitions, ActivityGoods.class, ActivityGoodsDto.class);
    }

    private Example<ActivityGoods> createExample(ActivityGoods entity) {
        ExampleMatcher matcher = ExampleMatcher.matching().withIgnoreNullValues();
        return Example.of((Object)entity, (ExampleMatcher)matcher);
    }
}

