/*
 * Decompiled with CFR 0.152.
 */
package activities.service.service.impl;

import activities.api.ActivityGoodsApi;
import activities.definition.ActivityBuyWayDefinitionType;
import activities.definition.ActivityDefinitionType;
import activities.definition.ActivityPriceType;
import activities.definition.GbActivityStatus;
import activities.definition.GbGroupInfoStatus;
import activities.dto.activity.request.ActivityGoodsReqDto;
import activities.dto.activity.request.OrderRequstVo;
import activities.dto.activity.response.ActivityGoodsRespDto;
import activities.dto.activity.response.OrderResponseVo;
import activities.dto.groupbuying.request.GbActivityInfoReqDto;
import activities.dto.groupbuying.request.GbGroupInfoReqDto;
import activities.dto.groupbuying.request.GbGroupJoinReqDto;
import activities.dto.groupbuying.request.GroupBuyingGoodsReqDto;
import activities.dto.groupbuying.request.GroupInfoHandleRequestDto;
import activities.dto.groupbuying.response.GbActivityInfoRespDto;
import activities.dto.groupbuying.response.GbGroupInfoRespDto;
import activities.dto.groupbuying.response.GbGroupJoinRespDto;
import activities.dto.groupbuying.response.GbOrderInfoDto;
import activities.dto.groupbuying.response.GroupBuyingGoodsRespDto;
import activities.dto.groupbuying.response.GroupInfoHandleResponseDto;
import activities.dto.modeldto.ActivityDefinitionDto;
import activities.dto.modeldto.groupbuying.GbActivityInfoDto;
import activities.model.ActivityDefinition;
import activities.model.ActivityGoods;
import activities.model.groupbuying.GbActivityInfo;
import activities.model.groupbuying.GbGoods;
import activities.model.groupbuying.GbGroupInfo;
import activities.model.groupbuying.GbGroupJoin;
import activities.model.groupbuying.GbOrderInfo;
import activities.model.repository.ActivityGoodsRepos;
import activities.model.repository.GbActivityInfoRepo;
import activities.model.repository.GbGoodsRepo;
import activities.model.repository.GbGroupInfoRepo;
import activities.model.repository.GbGroupJoinRepo;
import activities.model.repository.GbOrderInfoRepo;
import activities.model.specification.GbJoinSpecification;
import activities.service.service.GroupBuyingService;
import activities.service.service.impl.GroupBuyingServiceImpl;
import cart.api.OrderItemApi;
import cart.api.OrderMainApi;
import cart.api.PaymentApi;
import cart.api.dto.order.OrderItemDto;
import cart.api.dto.order.OrderMainDto;
import cart.api.dto.payment.PaymentDto;
import cart.api.dto.payment.PaymentReturnVo;
import cart.api.dto.response.PayResultDto;
import cart.api.vo.FashionDetailVo;
import cart.api.vo.TempOrderItemVo;
import cart.api.vo.TempOrderStoreVo;
import cart.api.vo.TempOrderVo;
import cms.api.OrganizationApi;
import com.alibaba.fastjson.JSON;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import goods.api.ProductFashionApi;
import goods.api.SalesPriceRateQueryApi;
import goods.dto.goods.GoodsDto;
import goods.model.Goods;
import goods.model.repository.GoodsRepos;
import goods.vo.FashionIdAndCountVo;
import goods.vo.SalesPriceQueryVo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import ma.glasnost.orika.MapperFacade;
import member.api.MemberAddressApi;
import member.api.MemberApi;
import member.api.vo.MemberAddressVo;
import member.api.vo.response.MemberAddressResponseVo;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import sinomall.config.api.base.BaseResponse;
import store.api.StoreApi;
import utils.Lang;
import utils.data.BeanMapper;
import utils.lang.Copys;
import utils.lock.RedisLockUtil;

@Service
public class GroupBuyingServiceImpl
implements GroupBuyingService {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    GbActivityInfoRepo gbActivityInfoRepo;
    @Autowired
    GbGoodsRepo gbGoodsRepo;
    @Autowired
    GbGroupInfoRepo gbGroupInfoRepo;
    @Autowired
    GbGroupJoinRepo gbGroupJoinRepo;
    @Autowired
    GoodsRepos goodsRepos;
    @MotanReferer
    MemberApi memberApi;
    @MotanReferer
    SalesPriceRateQueryApi salesPriceRateQueryApi;
    @MotanReferer
    StoreApi storeApi;
    @Autowired
    ActivityGoodsApi activityGoodsApi;
    @MotanReferer
    MemberAddressApi memberAddressApi;
    @MotanReferer
    OrderMainApi orderMainApi;
    @MotanReferer
    ProductFashionApi productFashionApi;
    @MotanReferer
    OrganizationApi organizationApi;
    @Autowired
    ActivityGoodsRepos activityGoodsRepos;
    @Autowired
    GbOrderInfoRepo gbOrderInfoRepo;
    @Autowired
    RedisLockUtil redisLockUtil;
    @MotanReferer
    OrderItemApi orderItemApi;
    @MotanReferer
    PaymentApi paymentApi;
    @Autowired
    MapperFacade mapperFacade;

    public GroupBuyingGoodsRespDto queryGroupBuyingGoodsPrice(GroupBuyingGoodsReqDto groupBuyingGoodsReqDto) {
        GbGoods gbGoods = this.gbGoodsRepo.findByGbActivityInfoIdAndActivityGoodsGoodsIdAndIsDelete(groupBuyingGoodsReqDto.getGbActivityInfoId(), groupBuyingGoodsReqDto.getGoodsId(), false);
        GroupBuyingGoodsRespDto groupBuyingGoodsRespDto = new GroupBuyingGoodsRespDto();
        if (gbGoods != null) {
            ActivityGoods activityGoods = gbGoods.getActivityGoods();
            ActivityDefinition activityDefinition = activityGoods.getActivityDefinition();
            BigDecimal groupBuyinlPrice = null;
            Goods goodsPO = (Goods)this.goodsRepos.findOne((Serializable)((Object)groupBuyingGoodsReqDto.getGoodsId()));
            GoodsDto goods = new GoodsDto();
            Copys.create().from((Object)goodsPO).excludes(new String[]{"product", "goodsAttrs", "goodsPictures", "goodsFashions", "goodsParams", "productFashion"}).to(new Object[]{goods}).clear();
            switch (1.$SwitchMap$activities$definition$ActivityPriceType[((ActivityPriceType)ActivityPriceType.activityPriceTypeMap.get(gbGoods.getPriceType())).ordinal()]) {
                case 1: {
                    String storeCode = this.storeApi.findStoreCodeById(goods.getStoreId());
                    SalesPriceQueryVo salesPriceQueryVo = new SalesPriceQueryVo(activityDefinition.getOrganizationCode(), storeCode, goods);
                    List mapList = this.salesPriceRateQueryApi.getSalesPriceListByParams(Arrays.asList(salesPriceQueryVo));
                    if (Lang.isEmpty((Object)mapList)) break;
                    groupBuyinlPrice = (BigDecimal)((Map)mapList.get(0)).get("salePrice");
                    break;
                }
                case 2: {
                    groupBuyinlPrice = this.goodsRepos.findCostPriceById(groupBuyingGoodsReqDto.getGoodsId());
                }
                case 3: {
                    groupBuyinlPrice = gbGoods.getGbPrice();
                }
            }
            groupBuyingGoodsRespDto.setGroupBuyinlPrice(groupBuyinlPrice);
            groupBuyingGoodsRespDto.setBanNum(activityGoods.getBanNum());
            groupBuyingGoodsRespDto.setSoldNum(activityGoods.getSoldNum());
            groupBuyingGoodsRespDto.setStockNum(activityGoods.getStockNum());
            ActivityGoodsReqDto activityGoodsReqDto = new ActivityGoodsReqDto();
            activityGoodsReqDto.setActivityInfoId(activityDefinition.getId());
            activityGoodsReqDto.setGoodsId(groupBuyingGoodsReqDto.getGoodsId());
            ActivityGoodsRespDto activityGoodsRespDto = this.activityGoodsApi.isActivityGoodsAndGetActivityPrice(activityGoodsReqDto);
            groupBuyingGoodsRespDto.setNormalPrice(activityGoodsRespDto.getActivitylPrice());
            groupBuyingGoodsRespDto.setActivityDefinitionType(activityGoodsRespDto.getActivityDefinitionType());
        } else {
            groupBuyingGoodsRespDto.setActivityDefinitionType(ActivityDefinitionType.noExist);
        }
        return groupBuyingGoodsRespDto;
    }

    public GbGroupInfoRespDto queryGbGroupInfoRespDto(GbGroupInfoReqDto gbGroupInfoReqDto) {
        GbGroupInfo gbGroupInfo = (GbGroupInfo)this.gbGroupInfoRepo.findOne((Serializable)((Object)gbGroupInfoReqDto.getGroupId()));
        if (gbGroupInfo != null) {
            GbGroupInfoRespDto gbGroupInfoRespDto = new GbGroupInfoRespDto();
            gbGroupInfoRespDto.setGroupStartTime(gbGroupInfo.getGroupStartTime());
            gbGroupInfoRespDto.setGroupEndTime(gbGroupInfo.getGroupEndTime());
            gbGroupInfoRespDto.setNumberParticipation(gbGroupInfo.getNumberParticipation());
            GbActivityInfo gbActivityInfo = gbGroupInfo.getGbActivityInfo();
            gbGroupInfoRespDto.setTotalNumber(gbActivityInfo.getNumberNeed());
            gbGroupInfoRespDto.setGbActivityInfoId(gbActivityInfo.getId());
            gbGroupInfoRespDto.setGbGroupInfoStatus((GbGroupInfoStatus)GbGroupInfoStatus.gbGroupInfoStatusHashMap.get(gbGroupInfo.getStatus()));
            ActivityDefinition activityDefinition = gbActivityInfo.getActivityDefinition();
            ActivityDefinitionType activityDefinitionType = this.activityGoodsApi.getActivityDefinitionType((ActivityDefinitionDto)BeanMapper.map((Object)activityDefinition, ActivityDefinitionDto.class));
            gbGroupInfoRespDto.setActivityDefinitionType(activityDefinitionType);
            return gbGroupInfoRespDto;
        }
        return null;
    }

    public GbGroupJoinRespDto queryGbGroupJoinNumber(GbGroupJoinReqDto gbGroupJoinReqDto) {
        GbGroupJoinRespDto gbGroupJoinRespDto = new GbGroupJoinRespDto();
        gbGroupJoinRespDto.setJoinNumber(Integer.valueOf(0));
        GbJoinSpecification gbJoinSpecification = new GbJoinSpecification();
        gbJoinSpecification.setGbActivityInfoId(gbGroupJoinReqDto.getGbActivityInfoId());
        gbJoinSpecification.setGbGroupInfoId(gbGroupJoinReqDto.getGbGroupInfoId());
        gbJoinSpecification.setMemberId(gbGroupJoinReqDto.getMemberId());
        List gbGroupJoins = this.gbGroupJoinRepo.findAll((Specification)gbJoinSpecification);
        if (gbGroupJoins != null && !gbGroupJoins.isEmpty()) {
            gbGroupJoinRespDto.setJoinNumber(Integer.valueOf(gbGroupJoins.size()));
        }
        for (GbGroupJoin gbGroupJoin : gbGroupJoins) {
            if (!gbGroupJoin.getIsLeader().booleanValue()) continue;
            gbGroupJoinRespDto.setIsLeader(Boolean.valueOf(true));
            break;
        }
        return gbGroupJoinRespDto;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public OrderResponseVo createOrder(OrderRequstVo orderRequstVo) {
        GbActivityInfo gbActivityInfo = null;
        if (!StringUtils.isEmpty((Object)orderRequstVo.getActivityInfoId())) {
            gbActivityInfo = (GbActivityInfo)this.gbActivityInfoRepo.findOne((Serializable)((Object)orderRequstVo.getActivityInfoId()));
        } else {
            if (StringUtils.isEmpty((Object)orderRequstVo.getGbGroupId())) throw new RuntimeException("\u53c2\u6570\u4e0d\u6b63\u786e\uff0cactivityInfoId\u4e0egbGroupId\u4e0d\u80fd\u90fd\u4e3a\u7a7a");
            GbGroupInfo gbGroupInfo = (GbGroupInfo)this.gbGroupInfoRepo.findOne((Serializable)((Object)orderRequstVo.getGbGroupId()));
            gbActivityInfo = gbGroupInfo.getGbActivityInfo();
        }
        String activityId = gbActivityInfo.getActivityDefinition().getId();
        try {
            long start = System.currentTimeMillis();
            MemberAddressVo memberAddressVo = Lang.isEmpty((Object)orderRequstVo.getMemberAddressVo()) ? null : (MemberAddressVo)this.mapperFacade.map((Object)orderRequstVo.getMemberAddressVo(), MemberAddressVo.class);
            MemberAddressResponseVo memberAddressResponseVo = this.memberAddressApi.saveOrUpdateAddress(memberAddressVo);
            this.logger.info("\u62fc\u56e2\u5904\u7406\u5730\u5740\u4fe1\u606f\u8017\u65f6:{}", (Object)(System.currentTimeMillis() - start));
            if (!BaseResponse.SUCCESS.equals(memberAddressResponseVo.getBaseResponse().getStatus())) {
                this.logger.error("===============\u4fdd\u5b58\u5730\u5740\u51fa\u9519==========");
                new RuntimeException("\u4fdd\u5b58\u5730\u5740\u51fa\u9519");
            }
            String productFashionIdStr = orderRequstVo.getProductFashionIdStr();
            String countsStr = orderRequstVo.getCountsStr();
            String goodsIdStr = orderRequstVo.getGoodsIdStr();
            if (!Lang.isEmpty((Object)productFashionIdStr) && !Lang.isEmpty((Object)countsStr)) {
                String[] productFashionIds = productFashionIdStr.split(",");
                String[] buyCounts = countsStr.split(",");
                String[] goodsIds = goodsIdStr.split(",");
                ArrayList<FashionIdAndCountVo> fashionIdAndCountVoList = new ArrayList<FashionIdAndCountVo>();
                ArrayList<String> fashionIdList = new ArrayList<String>();
                ArrayList<Integer> fashionCountList = new ArrayList<Integer>();
                for (int i = 0; i < productFashionIds.length; ++i) {
                    if (Lang.isEmpty((Object)productFashionIds[i])) continue;
                    fashionIdList.add(productFashionIds[i].trim());
                    fashionCountList.add(Integer.parseInt(buyCounts[i]));
                    fashionIdAndCountVoList.add(new FashionIdAndCountVo(productFashionIds[i].trim(), goodsIds[i].trim(), Integer.valueOf(Integer.parseInt(buyCounts[i]))));
                }
                start = System.currentTimeMillis();
                Map stockQueyrRes = this.productFashionApi.queryFashionStockStatus(fashionIdAndCountVoList, orderRequstVo.getAreaCode(), orderRequstVo.getOrganizationCode());
                boolean noStockFlag = true;
                this.logger.info("\u62fc\u56e2\u67e5\u8be2\u5e93\u5b58\u8017\u65f6:{}", (Object)(System.currentTimeMillis() - start));
                if ("success".equals((String)stockQueyrRes.get("status"))) {
                    noStockFlag = noStockFlag && (Boolean)((Map)stockQueyrRes.get("data")).get("noStockFlag") != false;
                } else {
                    if (noStockFlag) {
                        // empty if block
                    }
                    noStockFlag = false;
                }
                if (!noStockFlag) {
                    start = System.currentTimeMillis();
                    List fashionDetailVos = this.mapperFacade.mapAsList(fashionIdAndCountVoList, FashionDetailVo.class);
                    TempOrderVo tempOrderVo = this.orderMainApi.newTempOrderByFasions(fashionDetailVos, orderRequstVo.getOrganizationCode(), orderRequstVo.getAreaCode());
                    this.logger.info("\u62fc\u56e2\u521b\u5efa\u4e34\u65f6\u8ba2\u5355\u8017\u65f6:{}", (Object)(System.currentTimeMillis() - start));
                    for (TempOrderStoreVo tempOrderStoreVo : tempOrderVo.getStoreList()) {
                        for (TempOrderItemVo tempOrderItemVo : tempOrderStoreVo.getOrderItems()) {
                            GbGoods gbGoods = this.gbGoodsRepo.findByGbActivityInfoIdAndActivityGoodsGoodsIdAndIsDelete(gbActivityInfo.getId(), tempOrderItemVo.getGoodsId(), false);
                            if (ActivityBuyWayDefinitionType.gbBuy.equals((Object)orderRequstVo.getActivityBuyWayDefinitionType()) || ActivityBuyWayDefinitionType.createGbBuy.equals((Object)orderRequstVo.getActivityBuyWayDefinitionType())) {
                                tempOrderItemVo.setSalePrice(gbGoods.getGbPrice());
                                continue;
                            }
                            if (!ActivityBuyWayDefinitionType.gbSingleBuy.equals((Object)orderRequstVo.getActivityBuyWayDefinitionType())) continue;
                            tempOrderItemVo.setSalePrice(gbGoods.getActivityGoods().getGoodsPrice());
                        }
                    }
                    tempOrderVo.setRealOrganizationId(this.organizationApi.findOrganizationByOrgCode(orderRequstVo.getOrganizationCode()).getId());
                    for (TempOrderStoreVo tempOrderStoreVo : tempOrderVo.getStoreList()) {
                        for (TempOrderItemVo tempOrderItemVo : tempOrderStoreVo.getOrderItems()) {
                            int downGoodsStock = this.activityGoodsRepos.countDownGoodsStock(activityId, tempOrderItemVo.getGoodsId(), tempOrderItemVo.getCount());
                            if (downGoodsStock != 0) continue;
                            this.logger.error("\u5e93\u5b58\u4e0d\u8db3========activityId={},goodsId={},count={}", new Object[]{activityId, tempOrderItemVo.getGoodsId(), tempOrderItemVo.getCount()});
                            return new OrderResponseVo(BaseResponse.ERROR, "activityGood stock overed");
                        }
                    }
                    String userId = this.memberApi.getMemberInfo(orderRequstVo.getMemberId()).getUser().getId();
                    start = System.currentTimeMillis();
                    Map ordersInfoMap = this.orderMainApi.createOrder(tempOrderVo, memberAddressResponseVo.getMemberAddressId(), userId, orderRequstVo.getMemberId(), orderRequstVo.getPayMethodCode());
                    this.logger.info("\u62fc\u56e2\u521b\u5efa\u4e3b\u8ba2\u5355\u8017\u65f6:{}", (Object)(System.currentTimeMillis() - start));
                    if ("error".equals(ordersInfoMap.get("status"))) return new OrderResponseVo(BaseResponse.ERROR, BaseResponse.ERROR_MESSAGE);
                    Map resData = (Map)ordersInfoMap.get("data");
                    List sucOrders = (List)resData.get("sucOrderList");
                    StringBuilder orderNos = new StringBuilder();
                    for (OrderMainDto sucOrder : sucOrders) {
                        orderNos.append(sucOrder.getOrderNo()).append(",");
                    }
                    return new OrderResponseVo(BaseResponse.SUCCESS, BaseResponse.SUCCESS_MESSAGE, orderNos.substring(0, orderNos.length() - 1));
                }
                this.logger.info("\u4e0b\u5355\u5931\u8d25\u5e93\u5b58\u4e0d\u8db3 \u8bf7\u6c42\u53c2\u6570 = {}", (Object)JSON.toJSONString((Object)orderRequstVo));
                return new OrderResponseVo(BaseResponse.ERROR, "Overed Stock!");
            }
            this.logger.error("===============\u5546\u54c1\u4fe1\u606f\u6709\u8bef==========");
            new RuntimeException("\u5546\u54c1\u4fe1\u606f\u6709\u8bef");
            return new OrderResponseVo(BaseResponse.ERROR, BaseResponse.ERROR_MESSAGE);
        }
        catch (Exception e) {
            this.logger.error("\u521b\u5efa\u8ba2\u5355\u5931\u8d25 orderRequstVo={}========", JSON.toJSON((Object)orderRequstVo), (Object)e);
            throw e;
        }
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public GroupInfoHandleResponseDto handleGroupInfo(GroupInfoHandleRequestDto handleGroupRequestDto) {
        GroupInfoHandleResponseDto gbGroupInfoHandleResponseDto = new GroupInfoHandleResponseDto();
        gbGroupInfoHandleResponseDto.setStatus("success");
        gbGroupInfoHandleResponseDto.setResponseMsg("\u8c03\u7528\u6210\u529f");
        GbGroupInfo gbGroupInfo = null;
        GbActivityInfo gbActivityInfo = null;
        GbGroupJoin gbGroupJoin = null;
        if (!StringUtils.isEmpty((Object)handleGroupRequestDto.getGbGroupId())) {
            gbGroupInfo = (GbGroupInfo)this.gbGroupInfoRepo.findOne((Serializable)((Object)handleGroupRequestDto.getGbGroupId()));
            gbActivityInfo = gbGroupInfo.getGbActivityInfo();
            int countNum = this.gbGroupJoinRepo.countByGbGroupInfoIdAndIsDelete(gbGroupInfo.getId(), false);
            if (countNum >= gbActivityInfo.getNumberNeed()) {
                gbGroupInfoHandleResponseDto.setStatus("error");
                gbGroupInfoHandleResponseDto.setResponseMsg("\u56e2\u4eba\u6570\u5df2\u6ee1");
                return gbGroupInfoHandleResponseDto;
            }
        } else if (!StringUtils.isEmpty((Object)handleGroupRequestDto.getGbActivityInfoId())) {
            gbActivityInfo = (GbActivityInfo)this.gbActivityInfoRepo.findOne((Serializable)((Object)handleGroupRequestDto.getGbActivityInfoId()));
        }
        switch (1.$SwitchMap$activities$definition$ActivityBuyWayDefinitionType[handleGroupRequestDto.getActivityBuyWayDefinitionType().ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                ActivityDefinition activityDefinition = gbActivityInfo.getActivityDefinition();
                gbGroupInfo = new GbGroupInfo();
                gbGroupInfo.setGbActivityInfo(gbActivityInfo);
                gbGroupInfo.setMemberId(handleGroupRequestDto.getMemberId());
                gbGroupInfo.setStatus(GbGroupInfoStatus.onGing.getCode());
                gbGroupInfo.setGroupStartTime(activityDefinition.getBeginTime());
                gbGroupInfo.setGroupEndTime(activityDefinition.getEndTime());
                this.gbGroupInfoRepo.saveAndFlush((Object)gbGroupInfo);
                gbGroupJoin = this.getGbGroupJoin(handleGroupRequestDto, gbGroupInfo);
                gbGroupJoin.setIsLeader(Boolean.valueOf(true));
                gbGroupInfoHandleResponseDto.setGroupId(gbGroupInfo.getId());
                break;
            }
            case 3: {
                gbGroupJoin = this.getGbGroupJoin(handleGroupRequestDto, gbGroupInfo);
                gbGroupJoin.setIsLeader(Boolean.valueOf(false));
                gbGroupInfoHandleResponseDto.setGroupId(gbGroupInfo.getId());
            }
        }
        GbOrderInfo gbOrderInfo = new GbOrderInfo();
        gbOrderInfo.setTypeBuy(handleGroupRequestDto.getActivityBuyWayDefinitionType().getCode());
        gbOrderInfo.setOrderNo(handleGroupRequestDto.getOrderNo());
        gbOrderInfo.setChannel(handleGroupRequestDto.getChannel());
        if (gbGroupJoin != null) {
            this.gbGroupJoinRepo.saveAndFlush((Object)gbGroupJoin);
            gbOrderInfo.setGbGroupJoin(gbGroupJoin);
        }
        gbOrderInfo.setGbActivityInfo(gbActivityInfo);
        if (gbGroupInfo != null && gbActivityInfo.getNumberNeed() <= gbGroupInfo.getNumberParticipation()) {
            gbGroupInfo.setStatus(GbGroupInfoStatus.finish.getCode());
            this.gbGroupInfoRepo.saveAndFlush((Object)gbGroupInfo);
        }
        this.gbOrderInfoRepo.saveAndFlush((Object)gbOrderInfo);
        return gbGroupInfoHandleResponseDto;
    }

    public GbActivityInfoRespDto queryGbActivityInfoRespDto(GbActivityInfoReqDto gbActivityInfoReqDto) {
        GbActivityInfoRespDto gbActivityInfoRespDto = new GbActivityInfoRespDto();
        GbActivityInfoDto gbActivityInfo = (GbActivityInfoDto)BeanMapper.map((Object)this.gbActivityInfoRepo.findOne((Serializable)((Object)gbActivityInfoReqDto.getActivityId())), GbActivityInfoDto.class);
        gbActivityInfoRespDto.setActivityDefinition(gbActivityInfo.getActivityDefinition());
        gbActivityInfoRespDto.setNumberNeed(gbActivityInfo.getNumberNeed());
        return gbActivityInfoRespDto;
    }

    public BaseResponse gbPayback(PaymentReturnVo paymentReturnVo) {
        PayResultDto payResultDto = this.orderMainApi.finishPay(paymentReturnVo);
        List orderNos = payResultDto.getOrderNos();
        if (orderNos != null && !orderNos.isEmpty()) {
            String orderNo = (String)orderNos.get(0);
            GbOrderInfo orderInfo = this.gbOrderInfoRepo.findByOrderNoAndIsDelete(orderNo, false);
            OrderMainDto orderMain = this.orderMainApi.findByOrderNo(orderNo);
            ActivityBuyWayDefinitionType activityBuyWayDefinitionType = (ActivityBuyWayDefinitionType)ActivityBuyWayDefinitionType.activityBuyWayDefinitionTypeHashMap.get(orderInfo.getTypeBuy());
            switch (1.$SwitchMap$activities$definition$ActivityBuyWayDefinitionType[activityBuyWayDefinitionType.ordinal()]) {
                case 1: {
                    this.orderMainApi.confirmOrder(orderNo);
                    break;
                }
                default: {
                    GbGroupJoin gbGroupJoinCurrent = orderInfo.getGbGroupJoin();
                    GbGroupInfo gbGroupInfo = gbGroupJoinCurrent.getGbGroupInfo();
                    gbGroupJoinCurrent.setIsDelivery(Boolean.valueOf(true));
                    this.gbGroupJoinRepo.saveAndFlush((Object)gbGroupJoinCurrent);
                    if (GbGroupInfoStatus.finish.getCode().equals(gbGroupInfo.getStatus())) {
                        this.logger.info("\u56e2gbGroupInfo={}\u5df2\u6ee1\u5458", (Object)JSON.toJSONString((Object)gbGroupInfo));
                        List gbGroupJoins = this.gbGroupJoinRepo.findByGbGroupInfoIdAndIsDeliveryAndIsDelete(gbGroupInfo.getId(), Boolean.valueOf(true), Boolean.valueOf(false));
                        if (gbGroupJoins.size() >= gbGroupInfo.getNumberParticipation()) {
                            this.logger.info("\u56e2gbGroupInfo={}\u5df2\u5168\u90e8\u652f\u4ed8\uff0c\u542f\u52a8\u4eac\u4e1c\u9884\u5360\u5e93\u5b58", (Object)JSON.toJSONString((Object)gbGroupInfo));
                            gbGroupInfo.setStatus(GbGroupInfoStatus.payFinish.getCode());
                            this.gbGroupInfoRepo.saveAndFlush((Object)gbGroupInfo);
                            for (GbGroupJoin gbGroupJoin : gbGroupJoins) {
                                List gbOrderInfos = this.gbOrderInfoRepo.findByGbGroupJoinId(gbGroupJoin.getId());
                                for (GbOrderInfo gbOrderInfo : gbOrderInfos) {
                                    orderMain = this.orderMainApi.findByOrderNo(gbOrderInfo.getOrderNo());
                                    this.orderMainApi.confirmOrder(gbOrderInfo.getOrderNo());
                                    this.logger.info("==========\u9884\u5360\u5e93\u5b58\u6210\u529f\uff0corderNo={}", (Object)orderNo);
                                }
                            }
                            break;
                        }
                        this.orderMainApi.updateOrderStatus(orderMain.getId(), "100");
                        break;
                    }
                    this.orderMainApi.updateOrderStatus(orderMain.getId(), "100");
                }
            }
            return new BaseResponse("success", "\u652f\u4ed8\u56de\u8c03\u6210\u529f");
        }
        return new BaseResponse("error", "\u652f\u4ed8\u56de\u8c03\u5931\u8d25");
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public BaseResponse cancelGbOrder(GbOrderInfo gbOrderInfo) {
        if (gbOrderInfo != null) {
            if ((gbOrderInfo = (GbOrderInfo)this.gbOrderInfoRepo.findOne((Serializable)((Object)gbOrderInfo.getId()))).getIsDelete().booleanValue()) {
                return new BaseResponse("success", "\u8be5\u8ba2\u5355\u5df2\u7ecf\u53d6\u6d88\uff0c\u4e0d\u80fd\u91cd\u590d\u53d6\u6d88");
            }
            gbOrderInfo.setIsDelete(Boolean.valueOf(true));
            this.gbOrderInfoRepo.saveAndFlush((Object)gbOrderInfo);
            GbGroupJoin gbGroupJoin = gbOrderInfo.getGbGroupJoin();
            if (gbGroupJoin != null && !gbGroupJoin.getIsDelete().booleanValue()) {
                gbGroupJoin.setIsDelete(Boolean.valueOf(true));
                gbGroupJoin.setIsDelivery(Boolean.valueOf(false));
                GbGroupInfo gbGroupInfo = gbGroupJoin.getGbGroupInfo();
                try {
                    gbGroupInfo.setNumberParticipation(Integer.valueOf(gbGroupInfo.getNumberParticipation() - 1));
                    gbGroupInfo.setStatus(GbGroupInfoStatus.onGing.getCode());
                    this.gbGroupInfoRepo.saveAndFlush((Object)gbGroupInfo);
                    this.gbGroupJoinRepo.saveAndFlush((Object)gbGroupJoin);
                    String activity = gbGroupJoin.getGbGroupInfo().getGbActivityInfo().getActivityDefinition().getId();
                    if (activity != null) {
                        List orderItemDtos = this.orderItemApi.findByOrderNo(gbOrderInfo.getOrderNo());
                        for (OrderItemDto orderItemDto : orderItemDtos) {
                            int downGoodsStock = this.activityGoodsRepos.countDownGoodsStock(activity, orderItemDto.getGoodsId(), Integer.valueOf(0 - orderItemDto.getCount()));
                            if (downGoodsStock != 0) continue;
                            this.logger.error("\u8fd4\u8fd8\u5e93\u5b58\u5931\u8d25orderNo={},goodsId={}", (Object)gbOrderInfo.getOrderNo(), (Object)orderItemDto.getGoodsId());
                        }
                    }
                }
                catch (Exception e) {
                    this.logger.error("\u56e2\u8d2d\u8ba2\u5355\u53d6\u6d88\u5931\u8d25");
                    throw e;
                }
            }
        }
        return new BaseResponse("success", gbOrderInfo.getOrderNo(), "\u8be5\u8ba2\u5355\u4e0d\u662f\u62fc\u56e2\u8ba2\u5355");
    }

    public GbOrderInfo findByOrderNo(String orderNo) {
        return this.gbOrderInfoRepo.findByOrderNoAndIsDelete(orderNo, false);
    }

    public GbOrderInfoDto queryGroupOrderInfo(String orderNo) {
        GbOrderInfoDto gbOrderInfoDto = new GbOrderInfoDto();
        GbOrderInfo orderInfo = this.findByOrderNo(orderNo);
        if (orderInfo != null) {
            gbOrderInfoDto.setGbChannel(orderInfo.getChannel());
            List orderItemDtos = this.orderItemApi.findByOrderNo(orderNo);
            if (orderItemDtos != null) {
                gbOrderInfoDto.setGoodsId(((OrderItemDto)orderItemDtos.get(0)).getGoodsId());
            }
            if (orderInfo.getGbGroupJoin() != null) {
                gbOrderInfoDto.setGroupId(orderInfo.getGbGroupJoin().getGbGroupInfo().getId());
            }
            gbOrderInfoDto.setActivityBuyWayDefinitionType((ActivityBuyWayDefinitionType)ActivityBuyWayDefinitionType.activityBuyWayDefinitionTypeHashMap.get(orderInfo.getTypeBuy()));
        }
        return gbOrderInfoDto;
    }

    public String findOrderNoByMemberIdAndGroupId(String memberId, String groupId) {
        List gbOrderInfos = this.gbOrderInfoRepo.findByGbGroupJoinMemberIdAndGbGroupJoinGbGroupInfoIdAndIsDelete(memberId, groupId, false);
        if (gbOrderInfos != null && !gbOrderInfos.isEmpty()) {
            return ((GbOrderInfo)gbOrderInfos.get(0)).getOrderNo();
        }
        return null;
    }

    public GbGroupJoin getGbGroupJoin(GroupInfoHandleRequestDto handleGroupRequestDto, GbGroupInfo gbGroupInfo) {
        GbGroupJoin gbGroupJoin = new GbGroupJoin();
        gbGroupJoin.setGbGroupInfo(gbGroupInfo);
        gbGroupJoin.setDateJoin(new Date());
        gbGroupJoin.setMemberId(handleGroupRequestDto.getMemberId());
        gbGroupJoin.setIsDelivery(Boolean.valueOf(false));
        gbGroupInfo.setNumberParticipation(Integer.valueOf(gbGroupInfo.getNumberParticipation() == null ? 1 : gbGroupInfo.getNumberParticipation() + 1));
        return gbGroupJoin;
    }

    public void queryActivityGroupStatusAndHandle() {
        this.logger.info("\u8fdb\u5165\u626b\u63cf\u8fc7\u671f\u5f85\u6210\u56e2\u6d3b\u52a8");
        try {
            List gbActivity = this.gbActivityInfoRepo.findByActivityDefinitionEndTimeLessThanAndExpiredSynchronizeIsNull(DateUtils.addHours((Date)new Date(), (int)-2));
            if (gbActivity != null) {
                this.logger.info("\u5f00\u59cb\u626b\u63cf\u8fc7\u671f\u6d3b\u52a8\u4e0b\u5f85\u6210\u56e2\u7684\u56e2");
                for (GbActivityInfo gbActivityInfo : gbActivity) {
                    this.logger.info("===============\u6d3b\u52a8\u4fe1\u606f============gbActivityInfo=" + gbActivityInfo);
                    List gbGroupInfos = gbActivityInfo.getGbGroupInfos();
                    for (GbGroupInfo gbGroupInfo : gbGroupInfos) {
                        this.logger.info("===============\u56e2\u4fe1\u606f============gbGroupInfo=" + gbGroupInfo);
                        if (!GbGroupInfoStatus.onGing.getCode().equals(gbGroupInfo.getStatus()) && !GbGroupInfoStatus.finish.getCode().equals(gbGroupInfo.getStatus())) continue;
                        List gbGroupJoins = this.gbGroupJoinRepo.findByGbGroupInfoIdAndIsDeliveryAndIsDelete(gbGroupInfo.getId(), Boolean.valueOf(true), Boolean.valueOf(false));
                        for (GbGroupJoin gbGroupJoin : gbGroupJoins) {
                            OrderMainDto orderMain;
                            List gbOrderInfos = this.gbOrderInfoRepo.findByGbGroupJoinId(gbGroupJoin.getId());
                            if (gbOrderInfos == null) continue;
                            GbOrderInfo gbOrderInfo = (GbOrderInfo)gbOrderInfos.get(0);
                            this.logger.info("===============\u8ba2\u5355\u4fe1\u606f============gbOrderInfo=" + gbOrderInfo);
                            if (StringUtils.isEmpty((Object)gbOrderInfo.getOrderNo()) || (orderMain = this.orderMainApi.findByOrderNo(gbOrderInfo.getOrderNo())) == null) continue;
                            Map returnMap = this.orderMainApi.occupyStock(orderMain);
                            PaymentDto paymentInfo = this.paymentApi.findPaymentById(orderMain.getPaymentId());
                            if (!"1".equals(paymentInfo.getStatus())) continue;
                            this.orderMainApi.confirmOrder(gbOrderInfo.getOrderNo());
                            this.logger.info("\u8fc7\u671f\u6d3b\u52a8\u4e0b\u5f85\u6210\u56e2\u5df2\u786e\u8ba4\u9884\u5360\u5e93\u5b58");
                        }
                    }
                    gbActivityInfo.setExpiredSynchronize(GbActivityStatus.expiredSynchronize.getCode());
                    this.gbActivityInfoRepo.saveAndFlush((Object)gbActivityInfo);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u626b\u63cf\u8fc7\u671f\u6d3b\u52a8\u4e0b\u5f85\u6210\u56e2\u7684\u56e2\u5931\u8d25", (Throwable)e);
        }
    }
}

