package activities.web.config;

import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @author xujingfeng
 * @version created at 2017/12/25
 * @since 1.8
 */
@Configuration
@EnableConfigurationProperties(RedisProperties.class)
public class RedissonConfig {

    RedisProperties redisProperties;

    public RedissonConfig(RedisProperties redisProperties) {
        this.redisProperties = redisProperties;
    }

    @Bean
    public RedissonClient redisClient(){
        Config config = new Config();
        String[] redisNodes=redisProperties.getSentinel().getNodes().split(",");
        String masterHost=redisNodes[0];
        String slaveHost1=redisNodes[1];
        String slaveHost2=redisNodes[2];
        config.useSentinelServers()
                //设置sentinel.conf配置里的sentinel别名
                //比如sentinel.conf里配置为sentinel monitor my-sentinel-name 127.0.0.1 6379 2,那么这里就配置my-sentinel-name
                // .setMasterName("my-sentinel-name")
                //这里设置sentinel节点的服务IP和端口，sentinel是采用Paxos拜占庭协议，一般sentinel至少3个节点
                //记住这里不是配置redis节点的服务端口和IP，sentinel会自己把请求转发给后面monitor的redis节点
                .addSentinelAddress("redis://"+masterHost)
                .addSentinelAddress("redis://"+slaveHost1)
                .addSentinelAddress("redis://"+slaveHost2).setDatabase(redisProperties.getDatabase()).setMasterName(redisProperties.getSentinel().getMaster()).setPassword(redisProperties.getPassword()).setMasterConnectionPoolSize(500).setSlaveConnectionPoolSize(500).setIdleConnectionTimeout(1000).setConnectTimeout(30000).setPingTimeout(30000).setReconnectionTimeout(30000);
//        config.useSingleServer().setAddress("redis://"+redisProperties.getHost()+":"+redisProperties.getPort())
//                .setDatabase(redisProperties.getDatabase()).setTimeout(3600);

//        config.setMasterConnectionPoolSize(500);//设置对于master节点的连接池中连接数最大为500
//        config.setSlaveConnectionPoolSize(500);//设置对于slave节点的连接池中连接数最大为500
//        config.setIdleConnectionTimeout(10000)//如果当前连接池里的连接数量超过了最小空闲连接数，而同时有连接空闲时间超过了该数值，那么这些连接将会自动被关闭，并从连接池里去掉。时间单位是毫秒。
//        config.setConnectTimeout(30000)//同任何节点建立连接时的等待超时。时间单位是毫秒。
//        config.setTimeout(3000)//等待节点回复命令的时间。该时间从命令发送成功时开始计时。
//        config.setPingTimeout(30000)
//        config.setReconnectionTimeout(3000)//当与某个节点的连接断开时，等待与其重新建立连接的时间间隔。时间单位是毫秒。

        RedissonClient redissonClient = Redisson.create(config);
        return redissonClient;
    }



}
