package activities.web.config;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.session.data.redis.RedisFlushMode;
import org.springframework.session.data.redis.config.annotation.web.http.EnableRedisHttpSession;
import org.springframework.session.web.http.CookieSerializer;
import org.springframework.session.web.http.DefaultCookieSerializer;

/**
 * Created by xiaoqian on 2016/10/24.
 */
@Configuration
@EnableRedisHttpSession(redisFlushMode = RedisFlushMode.IMMEDIATE)
public class SessionConfig {

    @Autowired
    ServerProperties serverProperties;

    @Bean
    public CookieSerializer cookieSerializer() {
        DefaultCookieSerializer serializer = new DefaultCookieSerializer();
        serializer.setCookieName(serverProperties.getSession().getCookie().getName());
        serializer.setCookiePath(serverProperties.getSession().getCookie().getPath());
        //serializer.setCookieMaxAge(serverProperties.getSession().getCookie().getMaxAge());
        serializer.setDomainName(serverProperties.getSession().getCookie().getDomain());
        // serializer.setUseSecureCookie(serverProperties.getSession().getCookie().getMaxAge());
        if(serverProperties.getSession().getCookie().getSecure()!=null){
            serializer.setUseSecureCookie(serverProperties.getSession().getCookie().getSecure());
        }
        serializer.setDomainNamePattern("^.+?\\.(\\w+\\.[a-z]+)$");
        return serializer;
    }

    @Value("${login.appId}")
    private String appId;//预支付地址

    @Value("${login.session.mobile}")
    private String loginMobile;

    @Value("${login.session.uid}")
    private String sessionUserId;

    @Value("${cookieDomain}")
    private String cookieDomain;

    public String getSessionUserId() {
        return sessionUserId;
    }

    public String getAppId() {
        return appId;
    }

    public String getLoginMobile() {
        return loginMobile;
    }

    public String getCookieDomain() {
        return cookieDomain;
    }
}
