package activities.web.config;


import activities.web.interceptors.CommonInterceptor;
import exception.mapping.GlobalSimpleMappingExceptionResolver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.servlet.resource.VersionResourceResolver;
import utils.springmvc.ContentParaVersionStrategy;
import utils.springmvc.converter.fastjson.HibernateFastJsonConverter;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

/**
 * Created by xiaoqian on 2016/10/12.
 */
@Configuration
public class SpringMvcConfig {


    @Configuration
    @AutoConfigureOrder()
    protected static class MvcConfigurerAdapter extends WebMvcConfigurerAdapter {

        @Autowired
        CommonInterceptor commonInterceptor;

        @Override
        public void addInterceptors(InterceptorRegistry registry) {
            registry.addInterceptor(commonInterceptor).addPathPatterns("/**");

        }

        /** 使用fastjson 替换默认的jackson，以便于序列化Hibernate对象 */
        @Override
        public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
            super.configureMessageConverters(converters);
            Charset defCharset = Charset.forName("UTF-8");
            HibernateFastJsonConverter fastConverter = new HibernateFastJsonConverter();

            /** 配置FastJson */
            List<MediaType> mediaTypes = new ArrayList();
//            mediaTypes.add(new MediaType("text", "html", defCharset));
            mediaTypes.add(new MediaType("text", "json", defCharset));
            mediaTypes.add(new MediaType("application", "json", defCharset));
            fastConverter.setSupportedMediaTypes(mediaTypes);

//            fastConverter.setFeatures(SerializerFeature.DisableCircularReferenceDetect);


            converters.add(fastConverter);
        }

        @Override
        public void addResourceHandlers(ResourceHandlerRegistry registry) {
            registry.addResourceHandler("/**")
                    .addResourceLocations("classpath:/META-INF/resources/"
                            , "classpath:/resources/", "classpath:/static/"
                            , "classpath:/public/")
                    .setCachePeriod(365 * 24 * 3600 * 1000)
                            // .setCacheControl(new CacheControl())
                    .resourceChain(true).addResolver(new VersionResourceResolver()
                    .addVersionStrategy(new ContentParaVersionStrategy(), "/**"));
        }

    };

    @Bean(name="simpleMappingExceptionResolver")
    @ConditionalOnProperty("exception.enable")
    @Profile("test")//test环境才生效
    public GlobalSimpleMappingExceptionResolver
    createSimpleMappingExceptionResolver() {
        GlobalSimpleMappingExceptionResolver r =
                new GlobalSimpleMappingExceptionResolver();

        Properties mappings = new Properties();
        mappings.setProperty("DatabaseException", "defaultErrorPage");
        mappings.setProperty("InvalidCreditCardException", "defaultErrorPage");
        mappings.setProperty("CustomException","defaultErrorPage");
        mappings.setProperty("MotanServiceException","defaultErrorPage");
        mappings.setProperty("NullPointerException","defaultErrorPage");
        mappings.setProperty("SpelEvaluationException","defaultErrorPage");

        r.setExceptionMappings(mappings);  // None by default
        r.setDefaultErrorView("error");    // No default
        r.setExceptionAttribute("ex");     // Default is "exception"
        r.setWarnLogCategory("error");     // No default
        return r;
    }

}
