package activities.web.config;


import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.embedded.FilterRegistrationBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import utils.filter.FrontEndLoginCheckFilter;
import utils.filter.FrontEndLoginItaipingCheckFilter;
import utils.filter.FrontEndLoginScoreCheckFilter;
import utils.filter.InjectionAttackFilter;

import java.util.List;
import java.util.Properties;

//import utils.filter.CNTPSSOLoginCheckFilter;

/**
 * Created by xiaoqian on 2016/10/24.
 */
@Configuration
@ConfigurationProperties(prefix = "security")
public class WebConfig {


    //    @Autowired
//    private javax.sql.DataSource dataSource;
    @Bean
    public FrontEndLoginItaipingCheckFilter frontEndLoginCheckFilter(
            @Value("${login.excludeUrls}") String excludeUrls,
            @Value("${login.loginUrl}") String loginUrl,
            @Value("${login.checkUrls}") String checkUrls,
            @Value("${login.defaultSuccessUrl}") String defaultSuccessUrl
    ) {
        FrontEndLoginItaipingCheckFilter frontEndLoginCheckFilter = new FrontEndLoginItaipingCheckFilter();
        frontEndLoginCheckFilter.setExcludeUrls(excludeUrls);
        frontEndLoginCheckFilter.setLoginUrl(loginUrl);
        frontEndLoginCheckFilter.setCheckUrls(checkUrls);
        frontEndLoginCheckFilter.setDefaultSuccessUrl(defaultSuccessUrl);

        return frontEndLoginCheckFilter;
    }

    private List<String> urls;

    public List<String> getUrls() {
        return urls;
    }

    public void setUrls(List<String> urls) {
        this.urls = urls;
    }

    @Bean
    FilterRegistrationBean filterRegistrationBean() {
        InjectionAttackFilter filter = new InjectionAttackFilter();
        filter.setFilterXSS(true);
        filter.setFilterSQL(true);
        filter.setClickJacking(true);
        FilterRegistrationBean registrationBean = new FilterRegistrationBean(filter);
        registrationBean.setUrlPatterns(urls);
        return registrationBean;
    }


}
