package activities.web.controller;

import activities.api.ActivityApi;
import activities.api.ActivityConfigurationApi;
import activities.api.ActivityGoodsApi;
import activities.dto.modeldto.ActivityDefinitionDto;
import activities.dto.modeldto.ActivityGoodsDto;
import activities.dto.modeldto.ActivityThemeDto;
import activities.model.ActivityDefinition;
import activities.model.ActivityGoods;
import activities.model.ActivityTheme;
import activities.model.repository.ActivityDefinitionRepos;
import activities.model.repository.ActivityGoodsRepos;
import activities.model.repository.ActivityThemeRepos;
import cms.api.OrganizationApi;
import com.alibaba.fastjson.JSON;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import goods.api.GoodsApi;
import goods.api.GoodsConfigApi;
import goods.api.GoodsPictureApi;
import goods.api.SalesPriceRateQueryApi;
import goods.dto.goods.GoodsPictureDto;
import goods.model.Goods;
import goods.model.repository.GoodsConfigRepos;
import goods.model.repository.GoodsRepos;
import goods.vo.SalesPriceQueryVo;
import jd.api.service.product.JdProductApi;
import lombok.extern.slf4j.Slf4j;
import ma.glasnost.orika.MapperFacade;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import store.api.StoreApi;
import store.api.dto.modeldto.core.StoreDto;
import suning.api.SnCommonConvertApi;
import utils.Lang;
import utils.excel.ReadExcelUtil;

import java.io.File;
import java.math.BigDecimal;
import java.util.*;

/**
 * Created by renjunlin on 2017/7/4.
 */
@Slf4j
@Controller
@RequestMapping(value = "/Activity")
public class ActivityController {

    @MotanReferer
    ActivityApi activityApi;

    @MotanReferer
    ActivityConfigurationApi activityConfigurationApi;

    @MotanReferer
    ActivityGoodsApi activityGoodsApi;

    @MotanReferer
    GoodsPictureApi goodsPictureApi;
    @MotanReferer
    SalesPriceRateQueryApi salesPriceRateQueryApi;
    @Autowired
    MapperFacade mapperFacade;


    @Value("${Activity.activityCode}")
    private String activityCode;
    @Value("${organization.code}")
    private String organizationCode;
    @Value("${store.code}")
    private String storeCode;

    @MotanReferer
    StoreApi storeApi;

    @Autowired
    GoodsRepos goodsRepos;

    @MotanReferer
    JdProductApi jdProductApi;

    @MotanReferer
    SnCommonConvertApi snCommonConvertApi;

    @MotanReferer
    GoodsConfigApi goodsConfigApi;

    @MotanReferer
    OrganizationApi organizationApi;


    @RequestMapping(value = "/ctActivity", method = RequestMethod.GET)
    public String ctActivity(Map map) {
        ActivityDefinitionDto activityDefinition = activityApi.findByOrganizationCodeAndActivityCode(organizationCode, activityCode);
        List<ActivityThemeDto> activityThemes = activityDefinition.getActivityThemes();
        List<Map> listMap = new ArrayList<>();


        for (ActivityThemeDto activityTheme : activityThemes) {
            Map mapList = new HashMap<>();
            if (activityTheme.getActivityGoodses() != null) {
                List<GoodsPictureDto> goodsList = new ArrayList<GoodsPictureDto>();
                for (ActivityGoodsDto activityGood : activityTheme.getActivityGoodses()) {
                    GoodsPictureDto goods = goodsPictureApi.findGoodsPicture(activityGood.getGoodsId());
                    if (goods == null) {   //如果商品图片没有的话不展示处理
                        log.error("======商品{}无图片，不展示=======", activityGood.getGoodsId());
                        continue;
                    }
                    List<Map> Price = salesPriceRateQueryApi.getSalesPriceListByParams(Arrays.asList(new SalesPriceQueryVo(organizationCode, storeCode, goods.getGoods())));
                    if (!Lang.isEmpty(Price) && Price.size() > 0) {
                        goods.getGoods().setSalePrice((BigDecimal) Price.get(0).get("salePrice"));
                    }
                    Boolean state = activityConfigurationApi.isInActivity(organizationCode);
                    if (state) {
                        Map activityPriceMap = activityGoodsApi.isActivityGoodsAndGetActivityPrice(Lang.isEmpty(goods.getGoods()) ? null : mapperFacade.map(goods.getGoods(), activities.dto.goods.GoodsDto.class), organizationCode);
                        Boolean isActivityGoods = (Boolean) activityPriceMap.get("isActivityGoods");
                        if (isActivityGoods) {
                            BigDecimal activityPrice = (BigDecimal) activityPriceMap.get("activityPrice");
                            goods.getGoods().setSalePrice(activityPrice);
                        }
                    }
                    goodsList.add(goods);
                }
                mapList.put(activityTheme.getName(), goodsList);
                listMap.add(mapList);
            }
        }
        map.put("listMaps", listMap);
        map.put("activityThemes", activityThemes);
        return "activity/ctActivity";


    }

    @Autowired
    ActivityDefinitionRepos activityDefinitionRepos;

    @MotanReferer
    GoodsApi goodsApi;

    @Autowired
    ActivityThemeRepos activityThemeRepos;

    @Autowired
    ActivityGoodsRepos activityGoodsRepos;

    @Autowired
    GoodsConfigRepos goodsConfigRepos;

    @RequestMapping(value = "/activityExcel", method = RequestMethod.GET)
    public void activityExcel() {

        File file = new File("H:\\temp/粮油商品.xlsx");
        try {
            List list = ReadExcelUtil.readExcel(file);
            for (int i = 0; i < list.size(); i++) {
                List content = (List) list.get(i);
                String themeId = (String) content.get(0);
                String groupIndex = (String) content.get(1);
                for (int j = 2; j < 8; j++) {
                    ActivityGoods activityGoods = new ActivityGoods();
                    activityGoods.setActivityDefinition(activityDefinitionRepos.findOne("17f7182d-940e-4398-a5cb-0f1ddfac33f3"));
                    activityGoods.setActivityTheme(activityThemeRepos.findOne(themeId));
                    activityGoods.setGroupIndex(Integer.valueOf(groupIndex));
                    activityGoods.setShowIndex(j - 2);
                    String sku = (String) content.get(j);
                    if (j <= 4) {
                        String jdStoreId = "8ce42ec1-8c83-4f22-80c6-e31cdc0dab14";
                        if (!Lang.isEmpty(sku)) {
                            List<goods.dto.goods.GoodsDto> goodslist = goodsApi.findByCodeAndSkuAndStoreIdAndIsdeleteAndState(sku, sku, jdStoreId, false, 1);
                            if (!Lang.isEmpty(goodslist)) {
                                activityGoods.setGoodsId(goodslist.get(0).getId());
                            }
                        } else {
                            activityGoods.setGoodsId("");
                        }
                    } else if (j >= 5 && j <= 7) {
                        String snStoreId = "4750f2b3-fbad-4b98-80ad-dc0801f38250";
                        if (!Lang.isEmpty(sku)) {
                            List<goods.dto.goods.GoodsDto> goodslist = goodsApi.findByCodeAndSkuAndStoreIdAndIsdeleteAndState(sku, sku, snStoreId, false, 1);
                            if (!Lang.isEmpty(goodslist)) {
                                activityGoods.setGoodsId(goodslist.get(0).getId());
                            }
                        } else {
                            activityGoods.setGoodsId("");
                        }
                    }
                    activityGoodsRepos.save(activityGoods);
                }

            }
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    @ResponseBody
    @RequestMapping(value = "/activityImport", method = RequestMethod.GET)
    public String activityImport(String activityCode, String imageFolderName, String filePath) {
        String paramCheck = "";
        if(Lang.isEmpty(activityCode)) {
            paramCheck += "请传入活动代码 activityCode <br>";
        }
        if(Lang.isEmpty(imageFolderName)) {
            paramCheck += "请传入活动图片文件夹名称 imageFolderName  <br>";
        }
        if(Lang.isEmpty(filePath)) {
            paramCheck += "请传入商品列表EXCEL文件路径 filePath  <br>";
        }
        if(!Lang.isEmpty(paramCheck)) {
            return paramCheck;
        }

        String storeCodeJD = "jd";
        String storeCodeSN = "suning";
        String organizationCode = "jicai";
        //String activityCode = "apple";
        String themeImagePathPrefix = "../activity/image/"+ imageFolderName +"/";
        String themeImagePathSuffix = ".jpg";
        //String filePath = "E:\\上线准备\\集采定制化苹果专区\\商品列表\\品类定制化专区.xlsx";
        File file = new File(filePath);
        if (!file.exists()) {
            return "活动专区数据导入失败 : \"" + filePath + "\" 文件路径不存在";
        }
        List<String> badSkuJD = new ArrayList<>();
        List<String> badSkuSN = new ArrayList<>();
        try {
            StoreDto storeJD = storeApi.findByCode(storeCodeJD);
            if (Lang.isEmpty(storeJD)) {
                return "活动专区数据导入失败 : 京东店铺代码 \"" + storeCodeJD + "\" 有误";
            }
            StoreDto storeSN = storeApi.findByCode(storeCodeSN);
            if (Lang.isEmpty(storeSN)) {
                return "活动专区数据导入失败 : 苏宁店铺代码 \"" + storeCodeSN + "\" 有误";
            }
            ActivityDefinition activity = activityDefinitionRepos.findByOrganizationCodeAndActivityCode(organizationCode, activityCode);
            if (Lang.isEmpty(activity)) {
                return "活动专区数据导入失败 :  根据机构代码 = " + organizationCode + ", 活动代码 = " + activityCode + " 无法找到活动场次数据";
            }
            List<String> upSkus = new ArrayList<>();
            List<List<List<String>>> list = ReadExcelUtil.readExcel(file);
            int groupIndex = 0;
            int themeIndex = 0;
            int lineIndex = 0;
            ActivityTheme activityTheme = null;
            for (List<String> content : list.get(0)) {
                lineIndex++;
                log.info("正在处理第 {} 行", lineIndex);
                if (lineIndex == 1) {
                    continue;
                }

                String themeName = content.get(0);
                if (!Lang.isEmpty(themeName)) {
                    themeName = themeName.trim();
                    activityTheme = new ActivityTheme();
                    activityTheme.setActivityDefinition(activity);
                    activityTheme.setName(themeName);
                    activityTheme.setShowIndex(themeIndex);
                    activityTheme.setImgPath(themeImagePathPrefix + themeName.replaceAll(" ", "-").replaceAll("/", "") + themeImagePathSuffix);
                    activityTheme = activityThemeRepos.save(activityTheme);

                    groupIndex = 0;
                    themeIndex++;
                } else {
                    groupIndex++;
                }

                boolean emptyGoods = true;
                for (int j = 1; j < 8; j++) {
                    String sku = content.get(j);
                    if(!Lang.isEmpty(sku)) {
                        emptyGoods = false;
                        break;
                    }
                }
                if(emptyGoods) {
                    continue;
                }

                for (int j = 2; j < 8; j++) {
                    ActivityGoods activityGoods = new ActivityGoods();
                    activityGoods.setActivityDefinition(activity);
                    activityGoods.setActivityTheme(activityTheme);
                    activityGoods.setGroupIndex(groupIndex);
                    activityGoods.setShowIndex(j - 2);
                    String sku = content.get(j);
                    String goodsId = "";
                    if (!Lang.isEmpty(sku)) {
                        List<Goods> goodsList;
                        if (j <= 4) {
                            goodsList = goodsRepos.findByCodeAndSkuAndStoreIdAndIsDeleteAndState(sku, sku, storeJD.getId(), false, 1);
                            if (Lang.isEmpty(goodsList)) {
                                try {
                                    jdProductApi.addJdGood(Long.parseLong(sku));
                                } catch (Exception e) {
                                    log.error("京东同步异常", e);
                                }
                                goodsList = goodsRepos.findBySku(sku);
                                if (Lang.isEmpty(goodsList)) {
                                    badSkuJD.add(sku);
                                    log.error("京东 SKU {} 同步失败", sku);
                                } else {
                                    Goods goods = goodsList.get(0);
                                    if(goods.getIsDelete() || !Lang.equals(1, goods.getState())) {
                                        upSkus.add(sku);
                                    }
                                }
                            }
                        } else {
                            goodsList = goodsRepos.findByCodeAndSkuAndStoreIdAndIsDeleteAndState(sku, sku, storeSN.getId(), false, 1);
                            if (Lang.isEmpty(goodsList)) {
                                try {
                                    snCommonConvertApi.addProdBySkus(null, sku, null, null, null);
                                } catch (Exception e) {
                                    log.error("苏宁同步异常", e);
                                }
                                goodsList = goodsRepos.findBySku(sku);
                                if (Lang.isEmpty(goodsList)) {
                                    badSkuSN.add(sku);
                                    log.error("苏宁 SKU {} 同步失败", sku);
                                } else {
                                    Goods goods = goodsList.get(0);
                                    if(goods.getIsDelete() || !Lang.equals(1, goods.getState())) {
                                        upSkus.add(sku);
                                    }
                                }
                            }
                        }
                        if (!Lang.isEmpty(goodsList)) {
                            goodsId = goodsList.get(0).getId();
                        }

                    }
                    activityGoods.setGoodsId(goodsId);
                    activityGoodsRepos.save(activityGoods);
                }
            }

            log.info("活动专区数据导入成功");
            log.info("京东同步 SKU 失败数据 {}", JSON.toJSONString(badSkuJD));
            log.info("苏宁同步 SKU 失败数据 {}", JSON.toJSONString(badSkuSN));
            log.info("需要手动维护 Goods 表 isDelete, state 字段 SKU 数据 {}", JSON.toJSONString(upSkus));

            // 商品上架
            if(!Lang.isEmpty(upSkus)) {
                String organizationId = organizationApi.findOrganizationIdByOrgCode(organizationCode);
//                goodsConfigApi.goodsUpDown(null, Collections.singletonList(organizationId), null, upSkus, null, 1);
            }

            return "活动专区数据导入成功 <br> 京东同步 SKU 失败数据 = " + JSON.toJSONString(badSkuJD) + " <br> 苏宁同步 SKU 失败数据 = " + JSON.toJSONString(badSkuSN) + " <br> 需要手动维护 Goods 表 isDelete, state 字段 SKU 数据 = " + JSON.toJSONString(upSkus);
        } catch (Exception e) {
            log.error("活动专区数据导入异常", e);
            return "活动专区数据导入失败 : " + e.getMessage();
        }
    }

    @ResponseBody
    @GetMapping("/syncTemp")
    public void syncTemp() {
        List<String> badSkuJD = new ArrayList<>();
        List<String> upSkus = new ArrayList<>();
        String skusStr = "3531528,1744803,229798,1530064,2378068,4847276,3699623,4328004,3748936,4785544,1080068,1516151,2209999,1265668,1337503";
        String organizationCode = "chengtongrenli";
        String storeCodeJD = "jd";
        StoreDto storeJD = storeApi.findByCode(storeCodeJD);
        List<String> skuList = Arrays.asList(skusStr.split(","));
        for (String sku : skuList) {
            List<Goods> goodsList = goodsRepos.findByCodeAndSkuAndStoreIdAndIsDeleteAndState(sku, sku, storeJD.getId(), false, 1);
            if (Lang.isEmpty(goodsList)) {
                try {
                    jdProductApi.addJdGood(Long.parseLong(sku));
                } catch (Exception e) {
                    log.error("京东同步异常", e);
                }
                goodsList = goodsRepos.findBySku(sku);
                if (Lang.isEmpty(goodsList)) {
                    badSkuJD.add(sku);
                    log.error("京东 SKU {} 同步失败", sku);
                } else {
                    Goods goods = goodsList.get(0);
                    if(goods.getIsDelete() || !Lang.equals(1, goods.getState())) {
                        upSkus.add(sku);
                    }
                }
            }
        }
        String organizationId = organizationApi.findOrganizationIdByOrgCode(organizationCode);
        //goodsConfigApi.goodsUpDown(null, Collections.singletonList(organizationId), null, skuList, null, 1);

        log.info("同步失败 : {}", JSON.toJSONString(badSkuJD));
        log.info("需要手动维护 Goods 表 isDelete, state 字段 SKU 数据 {}", JSON.toJSONString(upSkus));


        //goodsConfigRepos.findBySkuAndOrganizationCode()

    }

}
