package activities.web.controller;

import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import lombok.extern.slf4j.Slf4j;
import member.api.AddressCommonApi;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import utils.GlobalContants;
import utils.Lang;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by Liang Wenxu on 2016/11/14.
 */
@Slf4j
@Controller
@RequestMapping("/areaCommon")
public class AddressController {

    @RequestMapping("/findAllByParent")
    @ResponseBody
    public Map<String, Object> findAddressByParent(
            Integer level, String parent, Boolean withChildren) {
        Map<String, Object> resData = new HashMap<>(3);
        resData.put(GlobalContants.ResponseString.STATUS, GlobalContants.ResponseStatus.SUCCESS);
        resData.put(GlobalContants.ResponseString.MESSAGE, GlobalContants.ResponseStatus.SUCCESS);
        AddressCommonApi.AddressLevel addrLevel = level == null ? null : AddressCommonApi.AddressLevel.getLevel(level);
        withChildren = withChildren == null ? false : withChildren;

        List<member.api.vo.AddressVo> apiRes;
        if (Lang.isEmpty(parent)) {
            apiRes = addressCommonApi.addressVoList(addrLevel, null, withChildren);
        } else {
            apiRes = addressCommonApi.addressVoList(addrLevel, parent, withChildren);
        }

        resData.put(GlobalContants.ResponseString.DATA, apiRes);
        return resData;
    }

    @RequestMapping("/findAll")
    @ResponseBody
    public Map<String, Object> findAddress(
            String id, Integer level, String parentId, Boolean withChildren,
            Map model, HttpServletRequest request, HttpServletResponse response) {
        Map<String, Object> resData = new HashMap<>(3);
        resData.put(GlobalContants.ResponseString.STATUS, GlobalContants.ResponseStatus.SUCCESS);
        resData.put(GlobalContants.ResponseString.MESSAGE, GlobalContants.ResponseStatus.SUCCESS);
        AddressCommonApi.AddressLevel addrLevel = level == null ? null : AddressCommonApi.AddressLevel.getLevel(level);
        withChildren = withChildren == null ? false : withChildren;

        List<member.api.vo.AddressVo> apiRes = null;
        if (!Lang.isEmpty(id)) {
            apiRes = new ArrayList<>();
            apiRes.add(addressCommonApi.findVoById(id, true));
        } else if (Lang.isEmpty(parentId)) {
            apiRes = addressCommonApi.addressVoList(addrLevel, null, withChildren);
        } else {
            String[] pidArr;
            if (parentId.contains(",")) {
                pidArr = parentId.split(",");
                for (String pid : pidArr) {
                    apiRes.addAll(addressCommonApi.addressVoList(addrLevel, pid, withChildren));
                }
            } else {
                apiRes = addressCommonApi.addressVoList(addrLevel, parentId, withChildren);
            }
        }
        resData.put(GlobalContants.ResponseString.DATA, apiRes);
        return resData;
    }

    @MotanReferer
    AddressCommonApi addressCommonApi;
}
