package activities.web.controller;

import activities.api.ActivityConfigurationApi;
import activities.api.ActivityGoodsApi;
import activities.api.TestApi;
import activities.dto.modeldto.ActivityDefinitionDto;
import activities.web.service.ActivityDefinitionService;
import cms.api.dto.OrganizationDto;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import goods.api.GoodsApi;
import goods.dto.goods.GoodsDto;
import ma.glasnost.orika.MapperFacade;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import utils.Lang;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created by oracle on 2017-05-15.
 */
@Controller
public class TestApiController {
    @MotanReferer
    TestApi testApi;

    @MotanReferer
    ActivityConfigurationApi activityConfigurationApi;
    @MotanReferer
    ActivityGoodsApi activityGoodsApi;
    @MotanReferer
    GoodsApi goodsApi;
    @Autowired
    ActivityDefinitionService activityDefinitionService;
    @Autowired
    MapperFacade  mapperFacade;


    @RequestMapping("/testAPi")
    @ResponseBody
    public Map testApi(Map map) {
        OrganizationDto organization = new OrganizationDto();
        organization.setOrgCode("chengtongrenli");
        // map = activityDefinitionService.ActivityDate(organization,map);
        return map;
    }

    @RequestMapping("/testActivityConfigurationApi")
    @ResponseBody
    public Object activityConfigurationApi() {
        String organizationCode = "";
        activityConfigurationApi.startActivity("chengtongrenli");
        Boolean inActivity = activityConfigurationApi.isInActivity("chengtongrenli");
        System.out.println("inActivity = " + inActivity);
        Boolean activity = activityConfigurationApi.isInActivity("chengtongrenli", "chengtong_activity_01");
        System.out.println("activity = " + activity);
        List<ActivityDefinitionDto> activityDefinitions = activityConfigurationApi.getActivitiesOnGoging("chengtongrenli", "chengtong_activity_01", new Date());
        for (ActivityDefinitionDto activityDefinition : activityDefinitions) {
            System.out.println("activityDefinition = " + activityDefinition);
        }
        return "test success";
    }

    @RequestMapping("/testActivityGoodsApi")
    @ResponseBody
    public Object activityGoodsApi() {
//        Goods goods = goodsApi.findById("f9086ff6-f823-49b3-a613-2531e55a5d2d");
        GoodsDto goods = goodsApi.findById("fff53dc8-5e91-49f4-8796-5dc2b8953596");
        activities.dto.goods.GoodsDto activityGoods = Lang.isEmpty(goods) ? null : mapperFacade.map(goods, activities.dto.goods.GoodsDto.class);
        Map<String, Object> activityPrice = activityGoodsApi.isActivityGoodsAndGetActivityPrice(activityGoods, "chengtongrenli");
        System.out.println("activityPrice = " + activityPrice);
        List<Map<String, Object>> activityPriceBatch = activityGoodsApi.isActivityGoodsAndGetActivityPriceBatch(Arrays.asList(activityGoods), "chengtongrenli");
        System.out.println("activityPriceBatch = " + activityPriceBatch);
        return "test success";
    }


}
