package activities.web.req.ct.score.activity;

import lombok.*;
import utils.Lang;

import java.io.Serializable;

/**
 * 诚通下单请求数据封装对象
 *
 * @author FatAss
 * @date 2018-08-10
 */
@Data
@ToString
@EqualsAndHashCode
@NoArgsConstructor
@AllArgsConstructor
public class MakeOrderReq implements Serializable {

    /**
     * 请求id
     */
    private String requestId;

    /**
     * 商品id
     */
    private String goodsId;

    /**
     * 收货人
     */
    private String username;

    /**
     * 收货人
     */
    private String tel;

    /**
     * 收货人联系电话
     */
    private String phone;

    /**
     * 详细地址(不含含省市)
     */
    private String detailAddress;

    /**
     * 详细地址(含含省市)
     */
    private String addressDetail;

    /**
     * 省份代码
     */
    private String provinceCode;

    /**
     * 省份名称
     */
    private String provinceName;

    /**
     * 城市代码
     */
    private String cityCode;

    /**
     * 城市名称
     */
    private String cityName;

    /**
     * 地区代码
     */
    private String areaCode;

    /**
     * 地区名称
     */
    private String areaName;

    /**
     * 城镇代码
     */
    private String townCode;

    /**
     * 城镇名称
     */
    private String townName;

    /**
     * 邮件
     */
    private String email;

    /**
     * 拼接完整地址
     * @return addressDetail
     */
    public String getAddressDetail() {
        if(Lang.isEmpty(addressDetail)) {
            StringBuilder addressDetailBuilder = new StringBuilder();
            if(!Lang.isEmpty(provinceName)) {
                addressDetailBuilder.append(provinceName).append(" ");
            }
            if(!Lang.isEmpty(cityName)) {
                addressDetailBuilder.append(cityName).append(" ");
            }
            if(!Lang.isEmpty(areaName)) {
                addressDetailBuilder.append(areaName).append(" ");
            }
            if(!Lang.isEmpty(townName)) {
                addressDetailBuilder.append(townName).append(" ");
            }
            if(!Lang.isEmpty(detailAddress)) {
                addressDetailBuilder.append(detailAddress).append(" ");
            }
            addressDetail = addressDetailBuilder.toString().trim();
        }
        return addressDetail;
    }

}
