package activities.web.service;

import cart.api.vo.FashionDetailVo;
import cart.api.vo.TempOrderVo;
import goods.model.ProductFashion;
import member.api.dto.shop.MemberAddressDto;
import member.api.vo.MemberVo;
import sinomall.global.common.response.BaseResponse;

import java.util.List;

/**
 * @author FatAss
 * @date 2018-08-10
 */
public interface ActivitiesService {

    /**
     * 下单
     *
     * @param tempOrderVo         临时订单
     * @param address             地址
     * @param memberVo            用户
     * @param fashionDetailVoList 商品
     * @param areaCode            地址代码
     * @return BaseResponse<String>
     */
    BaseResponse<String> makeOrder(TempOrderVo tempOrderVo, MemberAddressDto address, MemberVo memberVo, List<FashionDetailVo> fashionDetailVoList, String areaCode);

    /**
     * 封装 FashionDetailVo 集合
     *
     * @param goodsId goodsId
     * @return ProductFashion
     */
    List<FashionDetailVo> getFashionDetailVoListByGoodsId(String goodsId);
}
