package activities.web.service.Impl;

import activities.web.service.ActivitiesService;
import cart.api.OrderMainApi;
import cart.api.PaymentApi;
import cart.api.dto.order.OrderMainDto;
import cart.api.dto.payment.PaymentConfigDto;
import cart.api.dto.payment.PaymentDto;
import cart.api.vo.FashionDetailVo;
import cart.api.vo.TempOrderItemVo;
import cart.api.vo.TempOrderStoreVo;
import cart.api.vo.TempOrderVo;
import com.alibaba.fastjson.JSON;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import goods.api.ProductFashionApi;
import goods.model.Goods;
import goods.model.ProductFashion;
import goods.model.repository.GoodsRepos;
import lombok.extern.slf4j.Slf4j;
import ma.glasnost.orika.MapperFacade;
import member.api.MemberAddressApi;
import member.api.dto.shop.MemberAddressDto;
import member.api.vo.MemberVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import sinomall.global.common.response.BaseResponse;
import utils.GlobalContants;
import utils.Lang;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author FatAss
 * @date 2018-08-10
 */
@Slf4j
@Service
public class ActivitiesServiceImpl implements ActivitiesService {

    @MotanReferer
    ProductFashionApi productFashionApi;

    @MotanReferer
    MemberAddressApi memberAddressApi;

    @MotanReferer
    OrderMainApi orderMainApi;

    @MotanReferer
    PaymentApi paymentApi;

    private final MapperFacade mapperFacade;

    private final GoodsRepos goodsRepos;

    @Autowired
    public ActivitiesServiceImpl(MapperFacade mapperFacade, GoodsRepos goodsRepos) {
        this.mapperFacade = mapperFacade;
        this.goodsRepos = goodsRepos;
    }

    @Override
    public BaseResponse<String> makeOrder(TempOrderVo tempOrderVo, MemberAddressDto address, MemberVo memberVo, List<FashionDetailVo> fashionDetailVoList, String areaCode) {
        log.info("正在查询第三方库存, memberId {}, areaCode {}", memberVo.getMember().getId(), areaCode);
        long queryFashionStockStatusTime = System.currentTimeMillis();
        Map stockQueryResp = productFashionApi.queryFashionStockStatus(mapperFacade.mapAsList(fashionDetailVoList, goods.vo.FashionIdAndCountVo.class), areaCode, tempOrderVo.getRealOrganizationId());
        log.info("查询第三方库存耗时 {} ms, memberId {}, 结果 {}", System.currentTimeMillis() - queryFashionStockStatusTime, memberVo.getMember().getId(), JSON.toJSONString(stockQueryResp));

        String status = (String) stockQueryResp.get("status");
        if (GlobalContants.ResponseStatus.ERROR.equals(status)) {
            log.error("第三方库存查询失败 memberId {}, status {}", memberVo.getMember().getId(), status);
            return new BaseResponse<>("info", "商品库存查询失败, 请更换商品或收货地址或稍后再试");
        } else {
            boolean noStockFlag = (Boolean) ((Map) stockQueryResp.get(GlobalContants.ResponseString.DATA)).get("noStockFlag");
            if (noStockFlag) {
                log.info("商品库存不足 memberId {}, fashionDetailVoList {}, areaCode {}", memberVo.getMember().getId(), JSON.toJSONString(fashionDetailVoList), areaCode);
                return new BaseResponse<>("info", "您选择商品该地区库存不足, 请更换商品或收获地址");
            } else {
                long saveMemberAddressTime = System.currentTimeMillis();
                log.info("正在保存 memberAddress memberId {}", memberVo.getMember().getId());
                MemberAddressDto memberAddress = memberAddressApi.saveOrUpdateAddress(address);
                log.info("保存 memberAddress 耗时 {} ms, memberId {}", System.currentTimeMillis() - saveMemberAddressTime, memberVo.getMember().getId());

                if (tempOrderVo.getOrderAttrs() == null) {
                    tempOrderVo.setOrderAttrs(new ArrayList<>());
                }
                /** 运费 */
                double shippingFee = 0.00;
                for (TempOrderStoreVo group : tempOrderVo.getStoreList()) {
                    BigDecimal fee = orderMainApi.queryShippingFee(group.getStoreId(), group.getOrderItems(), memberAddress.getId());
                    if (fee != null) {
                        shippingFee += fee.doubleValue();
                    }
                    group.setShippingFee(fee);
                }
                BigDecimal sumPriceBig = BigDecimal.ZERO;
                List<TempOrderStoreVo> storeList = tempOrderVo.getStoreList();
                for (TempOrderStoreVo tempOrderStoreVo : storeList) {
                    for (TempOrderItemVo tempOrderItemVo : tempOrderStoreVo.getOrderItems()) {
                        FashionDetailVo fashionDetailVo = new FashionDetailVo();
                        fashionDetailVo.setCount(tempOrderItemVo.getCount());
                        fashionDetailVo.setGoodsId(tempOrderItemVo.getGoodsId());
                        fashionDetailVo.setProductFashionId(tempOrderItemVo.getProductFashionId());
                        fashionDetailVoList.add(fashionDetailVo);
                        sumPriceBig = sumPriceBig.add(tempOrderItemVo.getSalePrice().multiply(new BigDecimal(tempOrderItemVo.getCount())));
                    }
                }
                tempOrderVo.setSumShippingFee(new BigDecimal(shippingFee));
                BigDecimal totalPriceBigDecimal = sumPriceBig.add(tempOrderVo.getSumShippingFee());
                tempOrderVo.setNeedPayPrice(totalPriceBigDecimal);
                tempOrderVo.setSumScore(BigDecimal.ZERO);
                tempOrderVo.setSumPrice(sumPriceBig);

                long createOrderTime = System.currentTimeMillis();
                log.info("正在创建订单 memberId {}", memberVo.getMember().getId());
                Map resMap = orderMainApi.createOrder(tempOrderVo, memberAddress.getId(), memberVo.getUser().getId(), memberVo.getMember().getId(), PaymentConfigDto.PAYMENT_CONFIG_CODE_FREE_GET);
                log.info("创建订单 耗时 {} ms, memberId {}, api结果 {}", System.currentTimeMillis() - createOrderTime, memberVo.getMember().getId(), JSON.toJSONString(resMap));

                if (resMap.get(GlobalContants.ResponseString.STATUS) != GlobalContants.ResponseStatus.ERROR) {
                    Map resData = (Map) resMap.get("data");
                    if(Lang.isEmpty(resData) || Lang.isEmpty(resData.get("sucOrderList"))) {
                        log.info("创建订单失败 memberId {}", memberVo.getMember().getId());
                        return new BaseResponse<>(GlobalContants.ResponseStatus.ERROR, "请联系诚意通客服专线 400-820-2095");
                    }
                    List<OrderMainDto> sucOrders = (List<OrderMainDto>) resData.get("sucOrderList");
                    Map<String, Object> returnMap;
                    if(sucOrders.size() == 1) {
                        OrderMainDto orderMain = sucOrders.get(0);
                        long preemptionStockTime = System.currentTimeMillis();
                        log.info("正在预占库存 memberId {}, 订单号 {}", memberVo.getMember().getId(), orderMain.getOrderNo());
                        returnMap = orderMainApi.occupyStock(orderMain);
                        log.info("预占库存耗时 {} ms, memberId {}, 订单号 {}, 结果 {}", System.currentTimeMillis() - preemptionStockTime, memberVo.getMember().getId(), orderMain.getOrderNo(), JSON.toJSONString(returnMap));

                        String returnCode = returnMap.get("returnCode").toString();
                        if (!GlobalContants.ResponseStatus.SUCCESS.equals(returnCode)) {
                            log.info("预占库存失败 memberId {}, 订单号 {}, returnCode = {}", memberVo.getMember().getId(), orderMain.getOrderNo(), returnCode);
                            orderMainApi.cancelOrder(orderMain.getOrderNo(), OrderMainApi.CancelOrderType.ERROR);
                            return new BaseResponse<>(GlobalContants.ResponseStatus.ERROR, "请联系诚意通客服专线 400-820-2095");
                        } else {
                            log.info("预占库存成功, memberId {}, 订单号 {}, returnCode = {}", memberVo.getMember().getId(), orderMain.getOrderNo(), returnCode);
                            paymentApi.updatePaymentStatus(orderMain.getPaymentId(), PaymentDto.PAY_STATUS_PAID);
                            long confirmTime = System.currentTimeMillis();
                            log.info("正在确认订单, memberId {}, 订单号 {}", memberVo.getMember().getId(), orderMain.getOrderNo());
                            orderMainApi.confirmOrder(orderMain.getOrderNo());
                            log.info("确认订单耗时 {} ms, memberId {}, 订单号 {}", System.currentTimeMillis() - confirmTime, memberVo.getMember().getId(), orderMain.getOrderNo());
                            return new BaseResponse<>(true, "请求成功", orderMain.getOrderNo());
                        }
                    } else {
                        log.info("订单数量异常 memberId {}", memberVo.getMember().getId());
                        return new BaseResponse<>(GlobalContants.ResponseStatus.ERROR, "请联系诚意通客服专线 400-820-2095");
                    }
                } else {
                    log.info("创建订单失败 memberId {}", memberVo.getMember().getId());
                    return new BaseResponse<>(GlobalContants.ResponseStatus.ERROR, "请联系诚意通客服专线 400-820-2095");
                }
            }
        }
    }

    @Override
    public List<FashionDetailVo> getFashionDetailVoListByGoodsId(String goodsId) {
        List<FashionDetailVo> fashionDetailVoList = new ArrayList<>();
        ProductFashion productFashion = null;
        Goods goodsPO = goodsRepos.findOne(goodsId);
        // 获取 productFashion
        if(!Lang.isEmpty(goodsPO)) {
            if(!Lang.isEmpty(goodsPO.getProductFashion()) && goodsPO.getSku().equals(goodsPO.getProductFashion().getProductCode())) {
                productFashion = goodsPO.getProductFashion();
            } else if(!Lang.isEmpty(goodsPO.getProduct())) {
                List<ProductFashion> productFashions = goodsPO.getProduct().getProductFashions();
                if (!Lang.isEmpty(productFashions)) {
                    if (productFashions.size() == 1 && goodsPO.getSku().equals( productFashions.get(0).getProductCode())) {
                        productFashion = productFashions.get(0);
                    } else {
                        for (ProductFashion pf : productFashions) {
                            if (pf.getProductCode().equals(goodsPO.getSku())) {
                                productFashion = pf;
                                break;
                            }
                        }
                    }
                }
            }
        }
        if(!Lang.isEmpty(productFashion)) {
            FashionDetailVo fashionDetailVo = new FashionDetailVo();
            fashionDetailVo.setGoodsId(goodsId);
            fashionDetailVo.setCount(1);
            fashionDetailVo.setProductFashionId(productFashion.getId());
            fashionDetailVoList.add(fashionDetailVo);
        }
        return fashionDetailVoList;
    }
}

