/*
 * Decompiled with CFR 0.152.
 */
package activities.web.config;

import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.redisson.config.SentinelServersConfig;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={RedisProperties.class})
public class RedissonConfig {
    RedisProperties redisProperties;

    public RedissonConfig(RedisProperties redisProperties) {
        this.redisProperties = redisProperties;
    }

    @Bean
    public RedissonClient redisClient() {
        Config config = new Config();
        String[] redisNodes = this.redisProperties.getSentinel().getNodes().split(",");
        String masterHost = redisNodes[0];
        String slaveHost1 = redisNodes[1];
        String slaveHost2 = redisNodes[2];
        ((SentinelServersConfig)((SentinelServersConfig)((SentinelServersConfig)((SentinelServersConfig)((SentinelServersConfig)((SentinelServersConfig)config.useSentinelServers().addSentinelAddress(new String[]{"redis://" + masterHost}).addSentinelAddress(new String[]{"redis://" + slaveHost1}).addSentinelAddress(new String[]{"redis://" + slaveHost2}).setDatabase(this.redisProperties.getDatabase()).setMasterName(this.redisProperties.getSentinel().getMaster()).setPassword(this.redisProperties.getPassword())).setMasterConnectionPoolSize(500)).setSlaveConnectionPoolSize(500)).setIdleConnectionTimeout(1000)).setConnectTimeout(30000)).setPingTimeout(30000)).setReconnectionTimeout(30000);
        RedissonClient redissonClient = Redisson.create((Config)config);
        return redissonClient;
    }
}

