/*
 * Decompiled with CFR 0.152.
 */
package activities.web.config;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.session.data.redis.RedisFlushMode;
import org.springframework.session.data.redis.config.annotation.web.http.EnableRedisHttpSession;
import org.springframework.session.web.http.CookieSerializer;
import org.springframework.session.web.http.DefaultCookieSerializer;

@Configuration
@EnableRedisHttpSession(redisFlushMode=RedisFlushMode.IMMEDIATE)
public class SessionConfig {
    @Autowired
    ServerProperties serverProperties;
    @Value(value="${login.appId}")
    private String appId;
    @Value(value="${login.session.mobile}")
    private String loginMobile;
    @Value(value="${login.session.uid}")
    private String sessionUserId;
    @Value(value="${cookieDomain}")
    private String cookieDomain;

    @Bean
    public CookieSerializer cookieSerializer() {
        DefaultCookieSerializer serializer = new DefaultCookieSerializer();
        serializer.setCookieName(this.serverProperties.getSession().getCookie().getName());
        serializer.setCookiePath(this.serverProperties.getSession().getCookie().getPath());
        serializer.setDomainName(this.serverProperties.getSession().getCookie().getDomain());
        if (this.serverProperties.getSession().getCookie().getSecure() != null) {
            serializer.setUseSecureCookie(this.serverProperties.getSession().getCookie().getSecure().booleanValue());
        }
        serializer.setDomainNamePattern("^.+?\\.(\\w+\\.[a-z]+)$");
        return serializer;
    }

    public String getSessionUserId() {
        return this.sessionUserId;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getLoginMobile() {
        return this.loginMobile;
    }

    public String getCookieDomain() {
        return this.cookieDomain;
    }
}

