/*
 * Decompiled with CFR 0.152.
 */
package activities.web.config;

import java.util.Collection;
import java.util.List;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.embedded.FilterRegistrationBean;
import org.springframework.boot.context.embedded.ServletRegistrationBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import utils.filter.FrontEndLoginItaipingCheckFilter;
import utils.filter.InjectionAttackFilter;

@Configuration
@ConfigurationProperties(prefix="security")
public class WebConfig {
    private List<String> urls;

    @Bean
    public FrontEndLoginItaipingCheckFilter frontEndLoginCheckFilter(@Value(value="${login.excludeUrls}") String excludeUrls, @Value(value="${login.loginUrl}") String loginUrl, @Value(value="${login.checkUrls}") String checkUrls, @Value(value="${login.defaultSuccessUrl}") String defaultSuccessUrl) {
        FrontEndLoginItaipingCheckFilter frontEndLoginCheckFilter = new FrontEndLoginItaipingCheckFilter();
        frontEndLoginCheckFilter.setExcludeUrls(excludeUrls);
        frontEndLoginCheckFilter.setLoginUrl(loginUrl);
        frontEndLoginCheckFilter.setCheckUrls(checkUrls);
        frontEndLoginCheckFilter.setDefaultSuccessUrl(defaultSuccessUrl);
        return frontEndLoginCheckFilter;
    }

    public List<String> getUrls() {
        return this.urls;
    }

    public void setUrls(List<String> urls) {
        this.urls = urls;
    }

    @Bean
    FilterRegistrationBean filterRegistrationBean() {
        InjectionAttackFilter filter = new InjectionAttackFilter();
        filter.setFilterXSS(true);
        filter.setFilterSQL(true);
        filter.setClickJacking(true);
        FilterRegistrationBean registrationBean = new FilterRegistrationBean((Filter)filter, new ServletRegistrationBean[0]);
        registrationBean.setUrlPatterns((Collection)this.urls);
        return registrationBean;
    }
}

