/*
 * Decompiled with CFR 0.152.
 */
package activities.web.controller;

import activities.api.ActivityApi;
import activities.api.ActivityConfigurationApi;
import activities.api.ActivityGoodsApi;
import activities.dto.goods.GoodsDto;
import activities.dto.modeldto.ActivityDefinitionDto;
import activities.dto.modeldto.ActivityGoodsDto;
import activities.dto.modeldto.ActivityThemeDto;
import activities.model.ActivityDefinition;
import activities.model.ActivityGoods;
import activities.model.ActivityTheme;
import activities.model.repository.ActivityDefinitionRepos;
import activities.model.repository.ActivityGoodsRepos;
import activities.model.repository.ActivityThemeRepos;
import cms.api.OrganizationApi;
import com.alibaba.fastjson.JSON;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import goods.api.GoodsApi;
import goods.api.GoodsConfigApi;
import goods.api.GoodsPictureApi;
import goods.api.SalesPriceRateQueryApi;
import goods.dto.goods.GoodsPictureDto;
import goods.model.Goods;
import goods.model.repository.GoodsConfigRepos;
import goods.model.repository.GoodsRepos;
import goods.vo.SalesPriceQueryVo;
import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jd.api.service.product.JdProductApi;
import ma.glasnost.orika.MapperFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import store.api.StoreApi;
import store.api.dto.modeldto.core.StoreDto;
import suning.api.SnCommonConvertApi;
import utils.Lang;
import utils.excel.ReadExcelUtil;

@Controller
@RequestMapping(value={"/Activity"})
public class ActivityController {
    private static final Logger log = LoggerFactory.getLogger(ActivityController.class);
    @MotanReferer
    ActivityApi activityApi;
    @MotanReferer
    ActivityConfigurationApi activityConfigurationApi;
    @MotanReferer
    ActivityGoodsApi activityGoodsApi;
    @MotanReferer
    GoodsPictureApi goodsPictureApi;
    @MotanReferer
    SalesPriceRateQueryApi salesPriceRateQueryApi;
    @Autowired
    MapperFacade mapperFacade;
    @Value(value="${Activity.activityCode}")
    private String activityCode;
    @Value(value="${organization.code}")
    private String organizationCode;
    @Value(value="${store.code}")
    private String storeCode;
    @MotanReferer
    StoreApi storeApi;
    @Autowired
    GoodsRepos goodsRepos;
    @MotanReferer
    JdProductApi jdProductApi;
    @MotanReferer
    SnCommonConvertApi snCommonConvertApi;
    @MotanReferer
    GoodsConfigApi goodsConfigApi;
    @MotanReferer
    OrganizationApi organizationApi;
    @Autowired
    ActivityDefinitionRepos activityDefinitionRepos;
    @MotanReferer
    GoodsApi goodsApi;
    @Autowired
    ActivityThemeRepos activityThemeRepos;
    @Autowired
    ActivityGoodsRepos activityGoodsRepos;
    @Autowired
    GoodsConfigRepos goodsConfigRepos;

    @RequestMapping(value={"/ctActivity"}, method={RequestMethod.GET})
    public String ctActivity(Map map) {
        ActivityDefinitionDto activityDefinition = this.activityApi.findByOrganizationCodeAndActivityCode(this.organizationCode, this.activityCode);
        List activityThemes = activityDefinition.getActivityThemes();
        ArrayList listMap = new ArrayList();
        for (ActivityThemeDto activityTheme : activityThemes) {
            HashMap mapList = new HashMap();
            if (activityTheme.getActivityGoodses() == null) continue;
            ArrayList<GoodsPictureDto> goodsList = new ArrayList<GoodsPictureDto>();
            for (ActivityGoodsDto activityGood : activityTheme.getActivityGoodses()) {
                Map activityPriceMap;
                Boolean isActivityGoods;
                Boolean state;
                GoodsPictureDto goods = this.goodsPictureApi.findGoodsPicture(activityGood.getGoodsId());
                if (goods == null) {
                    log.error("======\u5546\u54c1{}\u65e0\u56fe\u7247\uff0c\u4e0d\u5c55\u793a=======", (Object)activityGood.getGoodsId());
                    continue;
                }
                List Price = this.salesPriceRateQueryApi.getSalesPriceListByParams(Arrays.asList(new SalesPriceQueryVo(this.organizationCode, this.storeCode, goods.getGoods())));
                if (!Lang.isEmpty((Object)Price) && Price.size() > 0) {
                    goods.getGoods().setSalePrice((BigDecimal)((Map)Price.get(0)).get("salePrice"));
                }
                if ((state = this.activityConfigurationApi.isInActivity(this.organizationCode)).booleanValue() && (isActivityGoods = (Boolean)(activityPriceMap = this.activityGoodsApi.isActivityGoodsAndGetActivityPrice(Lang.isEmpty((Object)goods.getGoods()) ? null : (GoodsDto)this.mapperFacade.map((Object)goods.getGoods(), GoodsDto.class), this.organizationCode)).get("isActivityGoods")).booleanValue()) {
                    BigDecimal activityPrice = (BigDecimal)activityPriceMap.get("activityPrice");
                    goods.getGoods().setSalePrice(activityPrice);
                }
                goodsList.add(goods);
            }
            mapList.put(activityTheme.getName(), goodsList);
            listMap.add(mapList);
        }
        map.put("listMaps", listMap);
        map.put("activityThemes", activityThemes);
        return "activity/ctActivity";
    }

    @RequestMapping(value={"/activityExcel"}, method={RequestMethod.GET})
    public void activityExcel() {
        File file = new File("H:\\temp/\u7cae\u6cb9\u5546\u54c1.xlsx");
        try {
            List list = ReadExcelUtil.readExcel((File)file);
            for (int i = 0; i < list.size(); ++i) {
                List content = (List)list.get(i);
                String themeId = (String)content.get(0);
                String groupIndex = (String)content.get(1);
                for (int j = 2; j < 8; ++j) {
                    List goodslist;
                    ActivityGoods activityGoods = new ActivityGoods();
                    activityGoods.setActivityDefinition((ActivityDefinition)this.activityDefinitionRepos.findOne((Serializable)((Object)"17f7182d-940e-4398-a5cb-0f1ddfac33f3")));
                    activityGoods.setActivityTheme((ActivityTheme)this.activityThemeRepos.findOne((Serializable)((Object)themeId)));
                    activityGoods.setGroupIndex(Integer.valueOf(groupIndex));
                    activityGoods.setShowIndex(Integer.valueOf(j - 2));
                    String sku = (String)content.get(j);
                    if (j <= 4) {
                        String jdStoreId = "8ce42ec1-8c83-4f22-80c6-e31cdc0dab14";
                        if (!Lang.isEmpty((Object)sku)) {
                            goodslist = this.goodsApi.findByCodeAndSkuAndStoreIdAndIsdeleteAndState(sku, sku, jdStoreId, false, Integer.valueOf(1));
                            if (!Lang.isEmpty((Object)goodslist)) {
                                activityGoods.setGoodsId(((goods.dto.goods.GoodsDto)goodslist.get(0)).getId());
                            }
                        } else {
                            activityGoods.setGoodsId("");
                        }
                    } else if (j >= 5 && j <= 7) {
                        String snStoreId = "4750f2b3-fbad-4b98-80ad-dc0801f38250";
                        if (!Lang.isEmpty((Object)sku)) {
                            goodslist = this.goodsApi.findByCodeAndSkuAndStoreIdAndIsdeleteAndState(sku, sku, snStoreId, false, Integer.valueOf(1));
                            if (!Lang.isEmpty((Object)goodslist)) {
                                activityGoods.setGoodsId(((goods.dto.goods.GoodsDto)goodslist.get(0)).getId());
                            }
                        } else {
                            activityGoods.setGoodsId("");
                        }
                    }
                    this.activityGoodsRepos.save((Object)activityGoods);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @ResponseBody
    @RequestMapping(value={"/activityImport"}, method={RequestMethod.GET})
    public String activityImport(String activityCode, String imageFolderName, String filePath) {
        String paramCheck = "";
        if (Lang.isEmpty((Object)activityCode)) {
            paramCheck = paramCheck + "\u8bf7\u4f20\u5165\u6d3b\u52a8\u4ee3\u7801 activityCode <br>";
        }
        if (Lang.isEmpty((Object)imageFolderName)) {
            paramCheck = paramCheck + "\u8bf7\u4f20\u5165\u6d3b\u52a8\u56fe\u7247\u6587\u4ef6\u5939\u540d\u79f0 imageFolderName  <br>";
        }
        if (Lang.isEmpty((Object)filePath)) {
            paramCheck = paramCheck + "\u8bf7\u4f20\u5165\u5546\u54c1\u5217\u8868EXCEL\u6587\u4ef6\u8def\u5f84 filePath  <br>";
        }
        if (!Lang.isEmpty((Object)paramCheck)) {
            return paramCheck;
        }
        String storeCodeJD = "jd";
        String storeCodeSN = "suning";
        String organizationCode = "jicai";
        String themeImagePathPrefix = "../activity/image/" + imageFolderName + "/";
        String themeImagePathSuffix = ".jpg";
        File file = new File(filePath);
        if (!file.exists()) {
            return "\u6d3b\u52a8\u4e13\u533a\u6570\u636e\u5bfc\u5165\u5931\u8d25 : \"" + filePath + "\" \u6587\u4ef6\u8def\u5f84\u4e0d\u5b58\u5728";
        }
        ArrayList<String> badSkuJD = new ArrayList<String>();
        ArrayList<String> badSkuSN = new ArrayList<String>();
        try {
            StoreDto storeJD = this.storeApi.findByCode(storeCodeJD);
            if (Lang.isEmpty((Object)storeJD)) {
                return "\u6d3b\u52a8\u4e13\u533a\u6570\u636e\u5bfc\u5165\u5931\u8d25 : \u4eac\u4e1c\u5e97\u94fa\u4ee3\u7801 \"" + storeCodeJD + "\" \u6709\u8bef";
            }
            StoreDto storeSN = this.storeApi.findByCode(storeCodeSN);
            if (Lang.isEmpty((Object)storeSN)) {
                return "\u6d3b\u52a8\u4e13\u533a\u6570\u636e\u5bfc\u5165\u5931\u8d25 : \u82cf\u5b81\u5e97\u94fa\u4ee3\u7801 \"" + storeCodeSN + "\" \u6709\u8bef";
            }
            ActivityDefinition activity = this.activityDefinitionRepos.findByOrganizationCodeAndActivityCode(organizationCode, activityCode);
            if (Lang.isEmpty((Object)activity)) {
                return "\u6d3b\u52a8\u4e13\u533a\u6570\u636e\u5bfc\u5165\u5931\u8d25 :  \u6839\u636e\u673a\u6784\u4ee3\u7801 = " + organizationCode + ", \u6d3b\u52a8\u4ee3\u7801 = " + activityCode + " \u65e0\u6cd5\u627e\u5230\u6d3b\u52a8\u573a\u6b21\u6570\u636e";
            }
            ArrayList<String> upSkus = new ArrayList<String>();
            List list = ReadExcelUtil.readExcel((File)file);
            int groupIndex = 0;
            int themeIndex = 0;
            int lineIndex = 0;
            ActivityTheme activityTheme = null;
            for (List content : (List)list.get(0)) {
                int j;
                log.info("\u6b63\u5728\u5904\u7406\u7b2c {} \u884c", (Object)(++lineIndex));
                if (lineIndex == 1) continue;
                String themeName = (String)content.get(0);
                if (!Lang.isEmpty((Object)themeName)) {
                    themeName = themeName.trim();
                    activityTheme = new ActivityTheme();
                    activityTheme.setActivityDefinition(activity);
                    activityTheme.setName(themeName);
                    activityTheme.setShowIndex(Integer.valueOf(themeIndex));
                    activityTheme.setImgPath(themeImagePathPrefix + themeName.replaceAll(" ", "-").replaceAll("/", "") + themeImagePathSuffix);
                    activityTheme = (ActivityTheme)this.activityThemeRepos.save((Object)activityTheme);
                    groupIndex = 0;
                    ++themeIndex;
                } else {
                    ++groupIndex;
                }
                boolean emptyGoods = true;
                for (j = 1; j < 8; ++j) {
                    String sku = (String)content.get(j);
                    if (Lang.isEmpty((Object)sku)) continue;
                    emptyGoods = false;
                    break;
                }
                if (emptyGoods) continue;
                for (j = 2; j < 8; ++j) {
                    ActivityGoods activityGoods = new ActivityGoods();
                    activityGoods.setActivityDefinition(activity);
                    activityGoods.setActivityTheme(activityTheme);
                    activityGoods.setGroupIndex(Integer.valueOf(groupIndex));
                    activityGoods.setShowIndex(Integer.valueOf(j - 2));
                    String sku = (String)content.get(j);
                    String goodsId = "";
                    if (!Lang.isEmpty((Object)sku)) {
                        Goods goods;
                        List goodsList;
                        if (j <= 4) {
                            goodsList = this.goodsRepos.findByCodeAndSkuAndStoreIdAndIsDeleteAndState(sku, sku, storeJD.getId(), false, Integer.valueOf(1));
                            if (Lang.isEmpty((Object)goodsList)) {
                                try {
                                    this.jdProductApi.addJdGood(Long.valueOf(Long.parseLong(sku)));
                                }
                                catch (Exception e) {
                                    log.error("\u4eac\u4e1c\u540c\u6b65\u5f02\u5e38", (Throwable)e);
                                }
                                goodsList = this.goodsRepos.findBySku(sku);
                                if (Lang.isEmpty((Object)goodsList)) {
                                    badSkuJD.add(sku);
                                    log.error("\u4eac\u4e1c SKU {} \u540c\u6b65\u5931\u8d25", (Object)sku);
                                } else {
                                    goods = (Goods)goodsList.get(0);
                                    if (goods.getIsDelete().booleanValue() || !Lang.equals((Object)1, (Object)goods.getState())) {
                                        upSkus.add(sku);
                                    }
                                }
                            }
                        } else {
                            goodsList = this.goodsRepos.findByCodeAndSkuAndStoreIdAndIsDeleteAndState(sku, sku, storeSN.getId(), false, Integer.valueOf(1));
                            if (Lang.isEmpty((Object)goodsList)) {
                                try {
                                    this.snCommonConvertApi.addProdBySkus(null, sku, null, null, null);
                                }
                                catch (Exception e) {
                                    log.error("\u82cf\u5b81\u540c\u6b65\u5f02\u5e38", (Throwable)e);
                                }
                                goodsList = this.goodsRepos.findBySku(sku);
                                if (Lang.isEmpty((Object)goodsList)) {
                                    badSkuSN.add(sku);
                                    log.error("\u82cf\u5b81 SKU {} \u540c\u6b65\u5931\u8d25", (Object)sku);
                                } else {
                                    goods = (Goods)goodsList.get(0);
                                    if (goods.getIsDelete().booleanValue() || !Lang.equals((Object)1, (Object)goods.getState())) {
                                        upSkus.add(sku);
                                    }
                                }
                            }
                        }
                        if (!Lang.isEmpty((Object)goodsList)) {
                            goodsId = ((Goods)goodsList.get(0)).getId();
                        }
                    }
                    activityGoods.setGoodsId(goodsId);
                    this.activityGoodsRepos.save((Object)activityGoods);
                }
            }
            log.info("\u6d3b\u52a8\u4e13\u533a\u6570\u636e\u5bfc\u5165\u6210\u529f");
            log.info("\u4eac\u4e1c\u540c\u6b65 SKU \u5931\u8d25\u6570\u636e {}", (Object)JSON.toJSONString(badSkuJD));
            log.info("\u82cf\u5b81\u540c\u6b65 SKU \u5931\u8d25\u6570\u636e {}", (Object)JSON.toJSONString(badSkuSN));
            log.info("\u9700\u8981\u624b\u52a8\u7ef4\u62a4 Goods \u8868 isDelete, state \u5b57\u6bb5 SKU \u6570\u636e {}", (Object)JSON.toJSONString(upSkus));
            if (!Lang.isEmpty(upSkus)) {
                String string = this.organizationApi.findOrganizationIdByOrgCode(organizationCode);
            }
            return "\u6d3b\u52a8\u4e13\u533a\u6570\u636e\u5bfc\u5165\u6210\u529f <br> \u4eac\u4e1c\u540c\u6b65 SKU \u5931\u8d25\u6570\u636e = " + JSON.toJSONString(badSkuJD) + " <br> \u82cf\u5b81\u540c\u6b65 SKU \u5931\u8d25\u6570\u636e = " + JSON.toJSONString(badSkuSN) + " <br> \u9700\u8981\u624b\u52a8\u7ef4\u62a4 Goods \u8868 isDelete, state \u5b57\u6bb5 SKU \u6570\u636e = " + JSON.toJSONString(upSkus);
        }
        catch (Exception e) {
            log.error("\u6d3b\u52a8\u4e13\u533a\u6570\u636e\u5bfc\u5165\u5f02\u5e38", (Throwable)e);
            return "\u6d3b\u52a8\u4e13\u533a\u6570\u636e\u5bfc\u5165\u5931\u8d25 : " + e.getMessage();
        }
    }

    @ResponseBody
    @GetMapping(value={"/syncTemp"})
    public void syncTemp() {
        ArrayList<String> badSkuJD = new ArrayList<String>();
        ArrayList<String> upSkus = new ArrayList<String>();
        String skusStr = "3531528,1744803,229798,1530064,2378068,4847276,3699623,4328004,3748936,4785544,1080068,1516151,2209999,1265668,1337503";
        String organizationCode = "chengtongrenli";
        String storeCodeJD = "jd";
        StoreDto storeJD = this.storeApi.findByCode(storeCodeJD);
        List<String> skuList = Arrays.asList(skusStr.split(","));
        for (String sku : skuList) {
            List goodsList = this.goodsRepos.findByCodeAndSkuAndStoreIdAndIsDeleteAndState(sku, sku, storeJD.getId(), false, Integer.valueOf(1));
            if (!Lang.isEmpty((Object)goodsList)) continue;
            try {
                this.jdProductApi.addJdGood(Long.valueOf(Long.parseLong(sku)));
            }
            catch (Exception e) {
                log.error("\u4eac\u4e1c\u540c\u6b65\u5f02\u5e38", (Throwable)e);
            }
            goodsList = this.goodsRepos.findBySku(sku);
            if (Lang.isEmpty((Object)goodsList)) {
                badSkuJD.add(sku);
                log.error("\u4eac\u4e1c SKU {} \u540c\u6b65\u5931\u8d25", (Object)sku);
                continue;
            }
            Goods goods = (Goods)goodsList.get(0);
            if (!goods.getIsDelete().booleanValue() && Lang.equals((Object)1, (Object)goods.getState())) continue;
            upSkus.add(sku);
        }
        String organizationId = this.organizationApi.findOrganizationIdByOrgCode(organizationCode);
        log.info("\u540c\u6b65\u5931\u8d25 : {}", (Object)JSON.toJSONString(badSkuJD));
        log.info("\u9700\u8981\u624b\u52a8\u7ef4\u62a4 Goods \u8868 isDelete, state \u5b57\u6bb5 SKU \u6570\u636e {}", (Object)JSON.toJSONString(upSkus));
    }
}

