/*
 * Decompiled with CFR 0.152.
 */
package activities.web.controller;

import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import member.api.AddressCommonApi;
import member.api.vo.AddressVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import utils.Lang;

@Controller
@RequestMapping(value={"/areaCommon"})
public class AddressController {
    private static final Logger log = LoggerFactory.getLogger(AddressController.class);
    @MotanReferer
    AddressCommonApi addressCommonApi;

    @RequestMapping(value={"/findAllByParent"})
    @ResponseBody
    public Map<String, Object> findAddressByParent(Integer level, String parent, Boolean withChildren) {
        HashMap<String, Object> resData = new HashMap<String, Object>(3);
        resData.put("status", "success");
        resData.put("message", "success");
        AddressCommonApi.AddressLevel addrLevel = level == null ? null : AddressCommonApi.AddressLevel.getLevel((int)level);
        withChildren = withChildren == null ? false : withChildren;
        List apiRes = Lang.isEmpty((Object)parent) ? this.addressCommonApi.addressVoList(addrLevel, null, withChildren) : this.addressCommonApi.addressVoList(addrLevel, parent, withChildren);
        resData.put("data", apiRes);
        return resData;
    }

    @RequestMapping(value={"/findAll"})
    @ResponseBody
    public Map<String, Object> findAddress(String id, Integer level, String parentId, Boolean withChildren, Map model, HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> resData = new HashMap<String, Object>(3);
        resData.put("status", "success");
        resData.put("message", "success");
        AddressCommonApi.AddressLevel addrLevel = level == null ? null : AddressCommonApi.AddressLevel.getLevel((int)level);
        withChildren = withChildren == null ? false : withChildren;
        List apiRes = null;
        if (!Lang.isEmpty((Object)id)) {
            apiRes = new ArrayList<AddressVo>();
            apiRes.add(this.addressCommonApi.findVoById(id, Boolean.valueOf(true)));
        } else if (Lang.isEmpty((Object)parentId)) {
            apiRes = this.addressCommonApi.addressVoList(addrLevel, null, withChildren);
        } else if (parentId.contains(",")) {
            String[] pidArr;
            for (String pid : pidArr = parentId.split(",")) {
                apiRes.addAll(this.addressCommonApi.addressVoList(addrLevel, pid, withChildren));
            }
        } else {
            apiRes = this.addressCommonApi.addressVoList(addrLevel, parentId, withChildren);
        }
        resData.put("data", apiRes);
        return resData;
    }
}

