/*
 * Decompiled with CFR 0.152.
 */
package activities.web.controller;

import activities.api.ActivityGoodsApi;
import activities.vo.ActivityGoodsVo;
import activities.vo.ActivityInfoVO;
import activities.web.req.ct.score.activity.MakeOrderReq;
import activities.web.service.ActivitiesService;
import activities.web.service.ActivityDefinitionService;
import cart.api.OrderMainApi;
import cart.api.vo.TempOrderItemVo;
import cart.api.vo.TempOrderStoreVo;
import cart.api.vo.TempOrderVo;
import com.alibaba.fastjson.JSON;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import member.api.dto.core.CoreUserDto;
import member.api.dto.shop.MemberAddressDto;
import member.api.vo.MemberVo;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import sinomall.global.common.response.BaseResponse;
import utils.Lang;
import utils.data.BeanMapper;

@Controller
public class CtScoreActivityController {
    private static final Logger log = LoggerFactory.getLogger(CtScoreActivityController.class);
    @MotanReferer
    private OrderMainApi orderMainApi;
    @MotanReferer
    private ActivityGoodsApi activityGoodsApi;
    private final RedisTemplate redisTemplate;
    private final ActivityDefinitionService activityDefinitionService;
    private final RedissonClient redisClient;
    private final ActivitiesService activitiesService;
    @Value(value="${organization.code}")
    private String organizationCode;
    @Value(value="${ct-score.activity.code}")
    private String activityCode;
    private static final String MEMBER_ACTIVITY_ID = "MEMBER_ACTIVITY_ID";
    private static final String MAKE_ORDER_LOCK_REQUEST_KEY_PREFIX = "CT-SCORE-ACTIVITY:MAKE-ORDER:REQUEST-ID:";
    private static final String MAKE_ORDER_LOCK_USER_KEY_PREFIX = "CT-SCORE-ACTIVITY:MAKE-ORDER:MEMBER-ID:";
    private static final String MEMBER_VO_SESSION_KEY = "member_vo_json_itaiping";
    private static final String ACTIVITY_INFO_CACHE_KEY = "ACTIVITY-WEB:CT-SCORE:ACTIVITY-INFO";
    private static final String FASHION_DETAIL_VO_LIST_BY_GOODS_ID_CACHE_KEY_PREFIX = "ACTIVITY-WEB:CT-SCORE:FASHION-DETAIL-VOS:GOODS-ID:";
    private static final String CLEAR_ACTIVITY_CACHE_KEY = "clearCache";

    @Autowired
    public CtScoreActivityController(RedisTemplate redisTemplate, ActivityDefinitionService activityDefinitionService, RedissonClient redisClient, ActivitiesService activitiesService) {
        this.redisTemplate = redisTemplate;
        this.activityDefinitionService = activityDefinitionService;
        this.redisClient = redisClient;
        this.activitiesService = activitiesService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"control.html"})
    public String control(Map<String, Object> map, HttpServletRequest request) {
        long methodStartTime = System.currentTimeMillis();
        log.info("### \u8bda\u901a\u9886\u53d6\u6d3b\u52a8\u52a0\u8f7d\u9875\u9762\u5f00\u59cb...");
        if (!Lang.isEmpty((Object)request.getParameter(CLEAR_ACTIVITY_CACHE_KEY))) {
            this.redisTemplate.delete((Object)ACTIVITY_INFO_CACHE_KEY);
            log.info("\u6d3b\u52a8\u7f13\u5b58\u6e05\u9664\u6210\u529f");
        }
        try {
            MemberVo memberVo = (MemberVo)JSON.parseObject((String)((String)request.getSession().getAttribute(MEMBER_VO_SESSION_KEY)), MemberVo.class);
            if (Lang.isEmpty((Object)memberVo)) {
                log.info("\u672a\u767b\u5f55\u8df3\u8f6c\u8bda\u901a\u767b\u5f55\u9875\u9762");
                String string = "redirect:../score";
                return string;
            }
            BoundValueOperations activityInfoCache = this.redisTemplate.boundValueOps((Object)ACTIVITY_INFO_CACHE_KEY);
            ActivityInfoVO activityInfoVO = (ActivityInfoVO)activityInfoCache.get();
            if (Lang.isEmpty((Object)activityInfoVO) && !Lang.isEmpty((Object)(activityInfoVO = this.activityDefinitionService.getActivityData(this.organizationCode, this.activityCode)))) {
                activityInfoCache.set((Object)activityInfoVO, 1L, TimeUnit.DAYS);
            }
            Date currentTime = new Date();
            if (Lang.isEmpty((Object)activityInfoVO)) {
                log.info("\u5f53\u524d\u6ca1\u6709\u6d3b\u52a8\u6570\u636e");
                String string = "ctScoreActivity/common";
                return string;
            }
            if (!Lang.isEmpty((Object)activityInfoVO.getBeginTime()) && currentTime.before(activityInfoVO.getBeginTime())) {
                log.info("\u6d3b\u52a8\u6682\u672a\u5f00\u59cb");
                map.put("status", "HAS_NOT_STARTED");
                String string = "ctScoreActivity/common";
                return string;
            }
            if (!Lang.isEmpty((Object)activityInfoVO.getEndTime()) && currentTime.after(activityInfoVO.getEndTime())) {
                log.info("\u6d3b\u52a8\u5df2\u7ed3\u675f");
                String string = "ctScoreActivity/common";
                return string;
            }
            BigDecimal orderCount = this.activityGoodsApi.getEffectiveOrderCount(memberVo.getMember().getId(), activityInfoVO.getActivityId());
            if (orderCount.intValue() > 0) {
                log.info("\u7528\u6237\u5df2\u53c2\u4e0e\u6d3b\u52a8, memberId {}", (Object)memberVo.getMember().getId());
                map.put("status", "SUCCESS");
                String string = "ctScoreActivity/common";
                return string;
            }
            request.getSession().setAttribute(MEMBER_ACTIVITY_ID, (Object)activityInfoVO.getActivityId());
            List listActivityGoodsVo = null;
            if (CoreUserDto.USER_TYPE_CT_SCORE_ACTIVITY.equals(memberVo.getUser().getUserType())) {
                if (activityInfoVO.getActivityGoodsVOs().stream().anyMatch(activityGoodsVo -> activityGoodsVo.getGiftClass().equals(memberVo.getUser().getSource()))) {
                    listActivityGoodsVo = activityInfoVO.getActivityGoodsVOs().stream().filter(activityGoodsVo -> activityGoodsVo.getGiftClass().equals(memberVo.getUser().getSource())).sorted(Comparator.comparing(ActivityGoodsVo::getShowIndex)).collect(Collectors.toList());
                }
            } else {
                log.info("\u975e\u6cd5\u7528\u6237, userSource {}, memberId {}", (Object)memberVo.getUser().getSource(), (Object)memberVo.getMember().getId());
                String string = "redirect:../score";
                return string;
            }
            map.put("listActivityGoodsVo", listActivityGoodsVo);
            String string = "ctScoreActivity/goodss";
            return string;
        }
        catch (Exception e) {
            log.error("\u52a0\u8f7d\u6d3b\u52a8\u9875\u9762\u5f02\u5e38", (Throwable)e);
            String string = "ctScoreActivity/common";
            return string;
        }
        finally {
            log.info("### \u8bda\u901a\u9886\u53d6\u6d3b\u52a8\u52a0\u8f7d\u603b\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - methodStartTime));
        }
    }

    @RequestMapping(value={"success.html"})
    public String success(Map<String, Object> map) {
        map.put("status", "SUCCESS");
        return "ctScoreActivity/common";
    }

    @RequestMapping(value={"end.html"})
    public String end() {
        return "ctScoreActivity/common";
    }

    @RequestMapping(value={"goods.html"})
    public String goods() {
        return "duanwu/goodss";
    }

    @RequestMapping(value={"noBegin.html"})
    public String noBegin(Map<String, Object> map) {
        map.put("status", "HAS_NOT_STARTED");
        return "ctScoreActivity/common";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ResponseBody
    @RequestMapping(value={"/ct-score-activity/order"})
    public BaseResponse makeOrder(@RequestBody MakeOrderReq makeOrderReq, HttpServletRequest request) {
        log.info("\u8bda\u901a\u793c\u5305\u9886\u53d6\u6d3b\u52a8\u8bf7\u6c42\u4e0b\u5355 \u53c2\u6570 {}", (Object)JSON.toJSONString((Object)makeOrderReq));
        ActivityInfoVO activityInfoVO = (ActivityInfoVO)this.redisTemplate.boundValueOps((Object)ACTIVITY_INFO_CACHE_KEY).get();
        MemberVo memberVo = (MemberVo)JSON.parseObject((String)((String)request.getSession().getAttribute(MEMBER_VO_SESSION_KEY)), MemberVo.class);
        if (Lang.isEmpty((Object)makeOrderReq) || Lang.isEmpty((Object)makeOrderReq.getRequestId())) {
            log.error("\u8bf7\u6c42id\u4e0d\u80fd\u4e3a\u7a7a");
            return new BaseResponse("error", "\u8bf7\u6c42\u53c2\u6570 [requestId] \u8bf7\u6c42id \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Lang.isEmpty((Object)makeOrderReq.getGoodsId())) {
            log.error("\u672a\u9009\u62e9\u5546\u54c1");
            return new BaseResponse("error", "\u8bf7\u6c42\u53c2\u6570 [goodsId] \u5546\u54c1id \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Lang.isEmpty((Object)activityInfoVO)) {
            log.error("\u65e0\u6cd5\u83b7\u53d6\u6d3b\u52a8\u6570\u636e");
            return new BaseResponse("info", "\u6d3b\u52a8\u6570\u636e\u83b7\u53d6\u5931\u8d25, \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        if (Lang.isEmpty((Object)memberVo)) {
            log.info("\u4ece session \u83b7\u53d6 memberVo \u5931\u8d25");
            return new BaseResponse("info", "\u767b\u5f55\u5931\u6548, \u8bf7\u91cd\u65b0\u767b\u5f55");
        }
        if (!CoreUserDto.USER_TYPE_CT_SCORE_ACTIVITY.equals(memberVo.getUser().getUserType())) {
            log.error("\u65e0\u6548\u7684\u7528\u6237, memberID {}", (Object)memberVo.getMember().getId());
            return new BaseResponse("info", "\u60a8\u6ca1\u6709\u8d44\u683c\u53c2\u4e0e\u672c\u6b21\u6d3b\u52a8");
        }
        if (activityInfoVO.getActivityGoodsVOs().stream().noneMatch(activityGoodsVo -> activityGoodsVo.getGoodsId().equals(makeOrderReq.getGoodsId()) && activityGoodsVo.getGiftClass().equals(memberVo.getUser().getSource()))) {
            log.warn("\u975e\u6cd5\u7684 goodsId {}, memberId {}", (Object)makeOrderReq.getGoodsId(), (Object)memberVo.getMember().getId());
            return new BaseResponse("info", "\u60a8\u9009\u62e9\u7684\u5546\u54c1\u65e0\u6548, \u8bf7\u66f4\u6362\u5546\u54c1\u540e");
        }
        String requestLockKey = MAKE_ORDER_LOCK_REQUEST_KEY_PREFIX + memberVo.getMember().getId() + "_" + makeOrderReq.getRequestId();
        BoundValueOperations requestLocker = this.redisTemplate.boundValueOps((Object)requestLockKey);
        if (requestLocker.setIfAbsent((Object)true).booleanValue()) {
            requestLocker.expire(30L, TimeUnit.MINUTES);
            RLock userLocker = null;
            long orderTime = System.currentTimeMillis();
            try {
                String userLockKey = MAKE_ORDER_LOCK_USER_KEY_PREFIX + memberVo.getMember().getId();
                userLocker = this.redisClient.getLock(userLockKey);
                userLocker.lock(10L, TimeUnit.MINUTES);
                if (userLocker.isLocked()) {
                    String minAddressCode;
                    BigDecimal orderCount = this.activityGoodsApi.getEffectiveOrderCount(memberVo.getMember().getId(), activityInfoVO.getActivityId());
                    if (orderCount.intValue() > 0) {
                        log.info("\u7528\u6237\u5df2\u53c2\u4e0e\u6d3b\u52a8, memberId {}", (Object)memberVo.getMember().getId());
                        BaseResponse baseResponse = new BaseResponse("info", "\u60a8\u5df2\u53c2\u4e0e\u6d3b\u52a8");
                        return baseResponse;
                    }
                    BoundValueOperations fashionDetailVoListCache = this.redisTemplate.boundValueOps((Object)(FASHION_DETAIL_VO_LIST_BY_GOODS_ID_CACHE_KEY_PREFIX + makeOrderReq.getGoodsId()));
                    List fashionDetailVoList = (List)fashionDetailVoListCache.get();
                    if (Lang.isEmpty((Object)fashionDetailVoList) && !Lang.isEmpty((Object)(fashionDetailVoList = this.activitiesService.getFashionDetailVoListByGoodsId(makeOrderReq.getGoodsId())))) {
                        fashionDetailVoListCache.set((Object)fashionDetailVoList, 10L, TimeUnit.MINUTES);
                    }
                    if (Lang.isEmpty((Object)fashionDetailVoList)) {
                        log.error("goodsId {} \u65e0\u6cd5\u627e\u5230 ProductFashion \u6570\u636e", (Object)makeOrderReq.getGoodsId());
                        BaseResponse baseResponse = new BaseResponse("info", "\u8be5\u5546\u54c1\u65e0\u6cd5\u8d2d\u4e70, \u8bf7\u9009\u62e9\u5176\u4ed6\u5546\u54c1");
                        return baseResponse;
                    }
                    MemberAddressDto address = (MemberAddressDto)BeanMapper.map((Object)makeOrderReq, MemberAddressDto.class);
                    address.setMember(memberVo.getMember());
                    String string = minAddressCode = Lang.isEmpty((Object)address.getTownCode()) ? address.getAreaCode() : address.getTownCode();
                    if (Lang.isEmpty((Object)minAddressCode)) {
                        log.error("\u5730\u5740\u6570\u636e\u6709\u8bef, MemberAddress {}", (Object)JSON.toJSONString((Object)address));
                        BaseResponse baseResponse = new BaseResponse("info", "\u60a8\u9009\u62e9\u7684\u5730\u5740\u6682\u4e0d\u53ef\u7528, \u8bf7\u66f4\u6362\u5176\u4ed6\u5730\u5740");
                        return baseResponse;
                    }
                    long createTempOrderTime = System.currentTimeMillis();
                    log.info("\u6b63\u5728\u521b\u5efa\u4e34\u65f6\u8ba2\u5355, memberId {}", (Object)memberVo.getMember().getId());
                    TempOrderVo tempOrder = this.orderMainApi.newTempOrderByFasions(fashionDetailVoList, this.organizationCode, minAddressCode);
                    tempOrder.setBuyType(request);
                    log.info("\u521b\u5efa\u4e34\u65f6\u8ba2\u5355\u8017\u65f6 {} ms, memberId {}, \u7ed3\u679c {}", new Object[]{System.currentTimeMillis() - createTempOrderTime, memberVo.getMember().getId(), JSON.toJSONString((Object)tempOrder)});
                    ((TempOrderItemVo)((TempOrderStoreVo)tempOrder.getStoreList().get(0)).getOrderItems().get(0)).setActivityId(activityInfoVO.getActivityId());
                    BaseResponse baseResponse = this.activitiesService.makeOrder(tempOrder, address, memberVo, fashionDetailVoList, minAddressCode);
                    return baseResponse;
                }
                userLocker = null;
                log.error("\u7528\u6237\u9501\u83b7\u53d6\u5931\u8d25, memberId {}", (Object)memberVo.getMember().getId());
                BaseResponse baseResponse = new BaseResponse("info", "\u60a8\u7684\u8bf7\u6c42\u6b63\u5728\u5904\u7406, \u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4");
                return baseResponse;
            }
            catch (Exception e) {
                log.error("\u8bda\u901a\u6d3b\u52a8\u5546\u54c1\u514d\u8d39\u9886\u53d6\u4e0b\u5355\u5f02\u5e38, memberId {}", (Object)memberVo.getMember().getId(), (Object)e);
                BaseResponse baseResponse = new BaseResponse("error", "\u8bf7\u8054\u7cfb\u8bda\u610f\u901a\u5ba2\u670d\u4e13\u7ebf 400-820-2095");
                return baseResponse;
            }
            finally {
                log.info("\u7528\u6237\u4e0b\u5355\u8017\u65f6 {} ms, memberId {}", (Object)(System.currentTimeMillis() - orderTime), (Object)memberVo.getMember().getId());
                if (!Lang.isEmpty((Object)userLocker)) {
                    userLocker.unlock();
                }
            }
        }
        log.error("\u7528\u6237\u91cd\u590d\u8bf7\u6c42\u62e6\u622a, memberId {}", (Object)memberVo.getMember().getId());
        return new BaseResponse("info", "\u60a8\u7684\u8bf7\u6c42\u6b63\u5728\u5904\u7406, \u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4");
    }
}

