/*
 * Decompiled with CFR 0.152.
 */
package activities.web.service;

import activities.api.ActivityDefinitionApi;
import activities.dto.modeldto.ActivityDefinitionDto;
import activities.dto.modeldto.ActivityGoodsDto;
import activities.vo.ActivityGoodsVo;
import activities.vo.ActivityInfoVO;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import goods.api.GoodsConfigApi;
import goods.model.Goods;
import goods.model.GoodsPicture;
import goods.model.repository.GoodsPictureRepos;
import goods.model.repository.GoodsRepos;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import utils.Lang;
import utils.data.BeanMapper;

@Service
public class ActivityDefinitionService {
    private static final Logger log = LoggerFactory.getLogger(ActivityDefinitionService.class);
    @MotanReferer
    private GoodsConfigApi goodsConfigApi;
    @MotanReferer
    private ActivityDefinitionApi activityDefinitionApi;
    private final GoodsRepos goodsRepos;
    private final GoodsPictureRepos goodsPictureRepos;

    @Autowired
    public ActivityDefinitionService(GoodsRepos goodsRepos, GoodsPictureRepos goodsPictureRepos) {
        this.goodsRepos = goodsRepos;
        this.goodsPictureRepos = goodsPictureRepos;
    }

    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ActivityInfoVO getActivityData(String organizationCode, String activityCode) {
        List activityDefinitions = this.activityDefinitionApi.findByOrganizationCodeAndActivityCode(organizationCode, activityCode);
        if (Lang.isEmpty((Object)activityDefinitions)) {
            return null;
        }
        if (activityDefinitions.size() > 1) {
            log.error("\u5728\u7ebf\u7684\u6d3b\u52a8\u6570\u636e\u4e0d\u662f\u552f\u4e00");
            return null;
        }
        ActivityDefinitionDto activityDefinition = (ActivityDefinitionDto)activityDefinitions.get(0);
        List activityGoodsVos = null;
        if (Lang.isEmpty((Object)activityDefinition.getEndTime()) || new Date().before(activityDefinition.getEndTime())) {
            List activityGoodsList = activityDefinition.getActivityGoodses().stream().filter(activityGoods -> activityGoods.getIsDelete() == false && activityGoods.getIsOnline() != false && this.goodsConfigApi.isUpGoodsId(activityGoods.getGoodsId(), organizationCode)).collect(Collectors.toList());
            activityGoodsVos = BeanMapper.mapList(activityGoodsList, ActivityGoodsDto.class, ActivityGoodsVo.class);
            List goodsIds = activityGoodsVos.stream().map(ActivityGoodsVo::getGoodsId).collect(Collectors.toList());
            long batchQueryGoodsTime = System.currentTimeMillis();
            Vector goodsListNew = new Vector();
            goodsIds.parallelStream().forEach(goodsId -> {
                Goods goodsTemp = (Goods)this.goodsRepos.findOne((Serializable)((Object)goodsId));
                goodsTemp.setGoodsPictures(Collections.singletonList(this.goodsPictureRepos.findMinIndexPictrueByGoodsId(goodsId)));
                goodsListNew.add(goodsTemp);
            });
            log.info("\u6279\u91cf\u67e5\u8be2 goods \u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - batchQueryGoodsTime));
            Map<String, Goods> goodsIdMap = goodsListNew.stream().collect(Collectors.toMap(Goods::getId, goods -> goods));
            activityGoodsVos.parallelStream().forEach(activityGoodsVo -> {
                Goods goodsPO = (Goods)goodsIdMap.get(activityGoodsVo.getGoodsId());
                activityGoodsVo.setGoodsName(goodsPO.getName());
                if (!Lang.isEmpty((Object)goodsPO.getGoodsPictures())) {
                    GoodsPicture firstPic = (GoodsPicture)goodsPO.getGoodsPictures().stream().sorted(Comparator.comparing(GoodsPicture::getShowIndex)).collect(Collectors.toList()).get(0);
                    activityGoodsVo.setGoodsPicture(firstPic.getPicturePath());
                }
            });
            log.info("\u52a0\u8f7d {} \u6761 \u6d3b\u52a8\u5546\u54c1\u6570\u636e", (Object)activityGoodsVos.size());
        }
        ActivityInfoVO activityInfoVO = new ActivityInfoVO();
        activityInfoVO.setActivityId(activityDefinition.getId());
        activityInfoVO.setBeginTime(activityDefinition.getBeginTime());
        activityInfoVO.setEndTime(activityDefinition.getEndTime());
        activityInfoVO.setActivityGoodsVOs(activityGoodsVos);
        return activityInfoVO;
    }
}

