/*
 * Decompiled with CFR 0.152.
 */
package activities.web.service.Impl;

import activities.web.service.ActivitiesService;
import cart.api.OrderMainApi;
import cart.api.PaymentApi;
import cart.api.dto.order.OrderMainDto;
import cart.api.dto.payment.PaymentConfigDto;
import cart.api.vo.FashionDetailVo;
import cart.api.vo.TempOrderItemVo;
import cart.api.vo.TempOrderStoreVo;
import cart.api.vo.TempOrderVo;
import com.alibaba.fastjson.JSON;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import goods.api.ProductFashionApi;
import goods.model.Goods;
import goods.model.ProductFashion;
import goods.model.repository.GoodsRepos;
import goods.vo.FashionIdAndCountVo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import ma.glasnost.orika.MapperFacade;
import member.api.MemberAddressApi;
import member.api.dto.shop.MemberAddressDto;
import member.api.vo.MemberVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import sinomall.global.common.response.BaseResponse;
import utils.Lang;

@Service
public class ActivitiesServiceImpl
implements ActivitiesService {
    private static final Logger log = LoggerFactory.getLogger(ActivitiesServiceImpl.class);
    @MotanReferer
    ProductFashionApi productFashionApi;
    @MotanReferer
    MemberAddressApi memberAddressApi;
    @MotanReferer
    OrderMainApi orderMainApi;
    @MotanReferer
    PaymentApi paymentApi;
    private final MapperFacade mapperFacade;
    private final GoodsRepos goodsRepos;

    @Autowired
    public ActivitiesServiceImpl(MapperFacade mapperFacade, GoodsRepos goodsRepos) {
        this.mapperFacade = mapperFacade;
        this.goodsRepos = goodsRepos;
    }

    public BaseResponse<String> makeOrder(TempOrderVo tempOrderVo, MemberAddressDto address, MemberVo memberVo, List<FashionDetailVo> fashionDetailVoList, String areaCode) {
        log.info("\u6b63\u5728\u67e5\u8be2\u7b2c\u4e09\u65b9\u5e93\u5b58, memberId {}, areaCode {}", (Object)memberVo.getMember().getId(), (Object)areaCode);
        long queryFashionStockStatusTime = System.currentTimeMillis();
        Map stockQueryResp = this.productFashionApi.queryFashionStockStatus(this.mapperFacade.mapAsList(fashionDetailVoList, FashionIdAndCountVo.class), areaCode, tempOrderVo.getRealOrganizationId());
        log.info("\u67e5\u8be2\u7b2c\u4e09\u65b9\u5e93\u5b58\u8017\u65f6 {} ms, memberId {}, \u7ed3\u679c {}", new Object[]{System.currentTimeMillis() - queryFashionStockStatusTime, memberVo.getMember().getId(), JSON.toJSONString((Object)stockQueryResp)});
        String status = (String)stockQueryResp.get("status");
        if ("error".equals(status)) {
            log.error("\u7b2c\u4e09\u65b9\u5e93\u5b58\u67e5\u8be2\u5931\u8d25 memberId {}, status {}", (Object)memberVo.getMember().getId(), (Object)status);
            return new BaseResponse("info", "\u5546\u54c1\u5e93\u5b58\u67e5\u8be2\u5931\u8d25, \u8bf7\u66f4\u6362\u5546\u54c1\u6216\u6536\u8d27\u5730\u5740\u6216\u7a0d\u540e\u518d\u8bd5");
        }
        boolean noStockFlag = (Boolean)((Map)stockQueryResp.get("data")).get("noStockFlag");
        if (noStockFlag) {
            log.info("\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3 memberId {}, fashionDetailVoList {}, areaCode {}", new Object[]{memberVo.getMember().getId(), JSON.toJSONString(fashionDetailVoList), areaCode});
            return new BaseResponse("info", "\u60a8\u9009\u62e9\u5546\u54c1\u8be5\u5730\u533a\u5e93\u5b58\u4e0d\u8db3, \u8bf7\u66f4\u6362\u5546\u54c1\u6216\u6536\u83b7\u5730\u5740");
        }
        long saveMemberAddressTime = System.currentTimeMillis();
        log.info("\u6b63\u5728\u4fdd\u5b58 memberAddress memberId {}", (Object)memberVo.getMember().getId());
        MemberAddressDto memberAddress = this.memberAddressApi.saveOrUpdateAddress(address);
        log.info("\u4fdd\u5b58 memberAddress \u8017\u65f6 {} ms, memberId {}", (Object)(System.currentTimeMillis() - saveMemberAddressTime), (Object)memberVo.getMember().getId());
        if (tempOrderVo.getOrderAttrs() == null) {
            tempOrderVo.setOrderAttrs(new ArrayList());
        }
        double shippingFee = 0.0;
        for (TempOrderStoreVo group : tempOrderVo.getStoreList()) {
            BigDecimal fee = this.orderMainApi.queryShippingFee(group.getStoreId(), group.getOrderItems(), memberAddress.getId());
            if (fee != null) {
                shippingFee += fee.doubleValue();
            }
            group.setShippingFee(fee);
        }
        BigDecimal sumPriceBig = BigDecimal.ZERO;
        List storeList = tempOrderVo.getStoreList();
        for (TempOrderStoreVo tempOrderStoreVo : storeList) {
            for (TempOrderItemVo tempOrderItemVo : tempOrderStoreVo.getOrderItems()) {
                FashionDetailVo fashionDetailVo = new FashionDetailVo();
                fashionDetailVo.setCount(tempOrderItemVo.getCount());
                fashionDetailVo.setGoodsId(tempOrderItemVo.getGoodsId());
                fashionDetailVo.setProductFashionId(tempOrderItemVo.getProductFashionId());
                fashionDetailVoList.add(fashionDetailVo);
                sumPriceBig = sumPriceBig.add(tempOrderItemVo.getSalePrice().multiply(new BigDecimal(tempOrderItemVo.getCount())));
            }
        }
        tempOrderVo.setSumShippingFee(new BigDecimal(shippingFee));
        BigDecimal totalPriceBigDecimal = sumPriceBig.add(tempOrderVo.getSumShippingFee());
        tempOrderVo.setNeedPayPrice(totalPriceBigDecimal);
        tempOrderVo.setSumScore(BigDecimal.ZERO);
        tempOrderVo.setSumPrice(sumPriceBig);
        long createOrderTime = System.currentTimeMillis();
        log.info("\u6b63\u5728\u521b\u5efa\u8ba2\u5355 memberId {}", (Object)memberVo.getMember().getId());
        Map resMap = this.orderMainApi.createOrder(tempOrderVo, memberAddress.getId(), memberVo.getUser().getId(), memberVo.getMember().getId(), PaymentConfigDto.PAYMENT_CONFIG_CODE_FREE_GET);
        log.info("\u521b\u5efa\u8ba2\u5355 \u8017\u65f6 {} ms, memberId {}, api\u7ed3\u679c {}", new Object[]{System.currentTimeMillis() - createOrderTime, memberVo.getMember().getId(), JSON.toJSONString((Object)resMap)});
        if (resMap.get("status") != "error") {
            Map resData = (Map)resMap.get("data");
            if (Lang.isEmpty((Object)resData) || Lang.isEmpty(resData.get("sucOrderList"))) {
                log.info("\u521b\u5efa\u8ba2\u5355\u5931\u8d25 memberId {}", (Object)memberVo.getMember().getId());
                return new BaseResponse("error", "\u8bf7\u8054\u7cfb\u8bda\u610f\u901a\u5ba2\u670d\u4e13\u7ebf 400-820-2095");
            }
            List sucOrders = (List)resData.get("sucOrderList");
            if (sucOrders.size() == 1) {
                OrderMainDto orderMain = (OrderMainDto)sucOrders.get(0);
                long preemptionStockTime = System.currentTimeMillis();
                log.info("\u6b63\u5728\u9884\u5360\u5e93\u5b58 memberId {}, \u8ba2\u5355\u53f7 {}", (Object)memberVo.getMember().getId(), (Object)orderMain.getOrderNo());
                Map returnMap = this.orderMainApi.occupyStock(orderMain);
                log.info("\u9884\u5360\u5e93\u5b58\u8017\u65f6 {} ms, memberId {}, \u8ba2\u5355\u53f7 {}, \u7ed3\u679c {}", new Object[]{System.currentTimeMillis() - preemptionStockTime, memberVo.getMember().getId(), orderMain.getOrderNo(), JSON.toJSONString((Object)returnMap)});
                String returnCode = returnMap.get("returnCode").toString();
                if (!"success".equals(returnCode)) {
                    log.info("\u9884\u5360\u5e93\u5b58\u5931\u8d25 memberId {}, \u8ba2\u5355\u53f7 {}, returnCode = {}", new Object[]{memberVo.getMember().getId(), orderMain.getOrderNo(), returnCode});
                    this.orderMainApi.cancelOrder(orderMain.getOrderNo(), OrderMainApi.CancelOrderType.ERROR);
                    return new BaseResponse("error", "\u8bf7\u8054\u7cfb\u8bda\u610f\u901a\u5ba2\u670d\u4e13\u7ebf 400-820-2095");
                }
                log.info("\u9884\u5360\u5e93\u5b58\u6210\u529f, memberId {}, \u8ba2\u5355\u53f7 {}, returnCode = {}", new Object[]{memberVo.getMember().getId(), orderMain.getOrderNo(), returnCode});
                this.paymentApi.updatePaymentStatus(orderMain.getPaymentId(), "1");
                long confirmTime = System.currentTimeMillis();
                log.info("\u6b63\u5728\u786e\u8ba4\u8ba2\u5355, memberId {}, \u8ba2\u5355\u53f7 {}", (Object)memberVo.getMember().getId(), (Object)orderMain.getOrderNo());
                this.orderMainApi.confirmOrder(orderMain.getOrderNo());
                log.info("\u786e\u8ba4\u8ba2\u5355\u8017\u65f6 {} ms, memberId {}, \u8ba2\u5355\u53f7 {}", new Object[]{System.currentTimeMillis() - confirmTime, memberVo.getMember().getId(), orderMain.getOrderNo()});
                return new BaseResponse(true, "\u8bf7\u6c42\u6210\u529f", (Object)orderMain.getOrderNo());
            }
            log.info("\u8ba2\u5355\u6570\u91cf\u5f02\u5e38 memberId {}", (Object)memberVo.getMember().getId());
            return new BaseResponse("error", "\u8bf7\u8054\u7cfb\u8bda\u610f\u901a\u5ba2\u670d\u4e13\u7ebf 400-820-2095");
        }
        log.info("\u521b\u5efa\u8ba2\u5355\u5931\u8d25 memberId {}", (Object)memberVo.getMember().getId());
        return new BaseResponse("error", "\u8bf7\u8054\u7cfb\u8bda\u610f\u901a\u5ba2\u670d\u4e13\u7ebf 400-820-2095");
    }

    public List<FashionDetailVo> getFashionDetailVoListByGoodsId(String goodsId) {
        ArrayList<FashionDetailVo> fashionDetailVoList = new ArrayList<FashionDetailVo>();
        ProductFashion productFashion = null;
        Goods goodsPO = (Goods)this.goodsRepos.findOne((Serializable)((Object)goodsId));
        if (!Lang.isEmpty((Object)goodsPO)) {
            List productFashions;
            if (!Lang.isEmpty((Object)goodsPO.getProductFashion()) && goodsPO.getSku().equals(goodsPO.getProductFashion().getProductCode())) {
                productFashion = goodsPO.getProductFashion();
            } else if (!Lang.isEmpty((Object)goodsPO.getProduct()) && !Lang.isEmpty((Object)(productFashions = goodsPO.getProduct().getProductFashions()))) {
                if (productFashions.size() == 1 && goodsPO.getSku().equals(((ProductFashion)productFashions.get(0)).getProductCode())) {
                    productFashion = (ProductFashion)productFashions.get(0);
                } else {
                    for (ProductFashion pf : productFashions) {
                        if (!pf.getProductCode().equals(goodsPO.getSku())) continue;
                        productFashion = pf;
                        break;
                    }
                }
            }
        }
        if (!Lang.isEmpty(productFashion)) {
            FashionDetailVo fashionDetailVo = new FashionDetailVo();
            fashionDetailVo.setGoodsId(goodsId);
            fashionDetailVo.setCount(Integer.valueOf(1));
            fashionDetailVo.setProductFashionId(productFashion.getId());
            fashionDetailVoList.add(fashionDetailVo);
        }
        return fashionDetailVoList;
    }
}

