/*
 * Decompiled with CFR 0.152.
 */
package activities.web.service.Impl;

import activities.api.ActivityGoodsApi;
import activities.vo.ActivityInfoVO;
import activities.web.req.ct.score.activity.TestMakeOrderReq;
import activities.web.service.ActivitiesService;
import activities.web.service.ActivityDefinitionService;
import activities.web.service.TestCtScoreActivityService;
import cart.api.OrderMainApi;
import cart.api.vo.TempOrderItemVo;
import cart.api.vo.TempOrderStoreVo;
import cart.api.vo.TempOrderVo;
import com.alibaba.fastjson.JSON;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import java.math.BigDecimal;
import java.util.List;
import java.util.concurrent.TimeUnit;
import member.api.MemberApi;
import member.api.dto.core.CoreUserDto;
import member.api.dto.shop.MemberAddressDto;
import member.api.vo.MemberVo;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import sinomall.global.common.response.BaseResponse;
import utils.Lang;

@Service
public class TestCtScoreActivityServiceImpl
implements TestCtScoreActivityService {
    private static final Logger log = LoggerFactory.getLogger(TestCtScoreActivityServiceImpl.class);
    @Value(value="${organization.code}")
    private String organizationCode;
    @Value(value="${ct-score.activity.code}")
    private String activityCode;
    @MotanReferer
    private OrderMainApi orderMainApi;
    @MotanReferer
    private MemberApi memberApi;
    @MotanReferer
    private ActivityGoodsApi activityGoodsApi;
    private final ActivitiesService activitiesService;
    private final RedisTemplate redisTemplate;
    private final RedissonClient redisClient;
    private final ActivityDefinitionService activityDefinitionService;
    private static final String ACTIVITY_INFO_CACHE_KEY = "ACTIVITY-WEB:CT-SCORE:ACTIVITY-INFO";
    private static final String FASHION_DETAIL_VO_LIST_BY_GOODS_ID_CACHE_KEY_PREFIX = "ACTIVITY-WEB:CT-SCORE:FASHION-DETAIL-VOS:GOODS-ID:";
    private static final String TEST_MAKE_ORDER_LOCK_REQUEST_KEY_PREFIX = "CT-SCORE-ACTIVITY:TEST:MAKE-ORDER:REQUEST-ID:";
    private static final String TEST_MAKE_ORDER_LOCK_USER_KEY_PREFIX = "CT-SCORE-ACTIVITY:TEST:MAKE-ORDER:MEMBER-ID:";

    @Autowired
    public TestCtScoreActivityServiceImpl(ActivitiesService activitiesService, RedisTemplate redisTemplate, RedissonClient redisClient, ActivityDefinitionService activityDefinitionService) {
        this.activitiesService = activitiesService;
        this.redisTemplate = redisTemplate;
        this.redisClient = redisClient;
        this.activityDefinitionService = activityDefinitionService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseResponse<String> testMakeOrder(TestMakeOrderReq testMakeOrderReq) {
        BoundValueOperations activityInfoCache = this.redisTemplate.boundValueOps((Object)ACTIVITY_INFO_CACHE_KEY);
        ActivityInfoVO activityInfoVO = (ActivityInfoVO)activityInfoCache.get();
        if (Lang.isEmpty((Object)activityInfoVO) && !Lang.isEmpty((Object)(activityInfoVO = this.activityDefinitionService.getActivityData(this.organizationCode, this.activityCode)))) {
            activityInfoCache.set((Object)activityInfoVO, 1L, TimeUnit.DAYS);
        }
        if (Lang.isEmpty((Object)testMakeOrderReq) || Lang.isEmpty((Object)testMakeOrderReq.getRequestId())) {
            return new BaseResponse("error", "\u8bf7\u6c42\u53c2\u6570 [requestId] - \u8bf7\u6c42 id \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Lang.isEmpty((Object)testMakeOrderReq.getGoodsId())) {
            return new BaseResponse("error", "\u8bf7\u6c42\u53c2\u6570 [goodsId] - \u7528\u6237 goodsId \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Lang.isEmpty((Object)testMakeOrderReq.getMemberId())) {
            return new BaseResponse("error", "\u8bf7\u6c42\u53c2\u6570 [memberId] - \u7528\u6237 memberId \u4e0d\u80fd\u4e3a\u7a7a");
        }
        long memberVoTime = System.currentTimeMillis();
        MemberVo memberVo = this.memberApi.getMemberInfo(testMakeOrderReq.getMemberId());
        log.info("\u67e5\u8be2 memberVO \u8017\u65f6 {} ms, memberId {}", (Object)(System.currentTimeMillis() - memberVoTime), (Object)testMakeOrderReq.getMemberId());
        if (Lang.isEmpty((Object)memberVo) || !CoreUserDto.USER_TYPE_CT_SCORE_ACTIVITY.equals(memberVo.getUser().getUserType())) {
            log.error("\u65e0\u6548\u7684 memberId {}", (Object)testMakeOrderReq.getMemberId());
            return new BaseResponse("info", "\u60a8\u6ca1\u6709\u8d44\u683c\u53c2\u4e0e\u672c\u6b21\u6d3b\u52a8");
        }
        if (activityInfoVO.getActivityGoodsVOs().stream().noneMatch(activityGoodsVo -> activityGoodsVo.getGoodsId().equals(testMakeOrderReq.getGoodsId()) && activityGoodsVo.getGiftClass().equals(memberVo.getUser().getSource()))) {
            log.warn("\u975e\u6cd5\u7684 goodsId {}, memberId {}", (Object)testMakeOrderReq.getGoodsId(), (Object)testMakeOrderReq.getMemberId());
            return new BaseResponse("info", "\u60a8\u9009\u62e9\u7684\u5546\u54c1\u65e0\u6548, \u8bf7\u66f4\u6362\u5546\u54c1\u540e");
        }
        String requestLockKey = TEST_MAKE_ORDER_LOCK_REQUEST_KEY_PREFIX + testMakeOrderReq.getMemberId() + "_" + testMakeOrderReq.getRequestId();
        BoundValueOperations requestLocker = this.redisTemplate.boundValueOps((Object)requestLockKey);
        if (requestLocker.setIfAbsent((Object)true).booleanValue()) {
            requestLocker.expire(30L, TimeUnit.MINUTES);
            RLock userLocker = null;
            long orderTime = System.currentTimeMillis();
            try {
                long lockMemberTime = System.currentTimeMillis();
                String userLockKey = TEST_MAKE_ORDER_LOCK_USER_KEY_PREFIX + testMakeOrderReq.getMemberId();
                userLocker = this.redisClient.getLock(userLockKey);
                userLocker.lock(3L, TimeUnit.MINUTES);
                if (userLocker.isLocked()) {
                    log.info("\u9501\u7528\u6237 memberId {}, \u8017\u65f6 {} ms", (Object)memberVo.getMember().getId(), (Object)(System.currentTimeMillis() - lockMemberTime));
                    long getEffectiveOrderCountTime = System.currentTimeMillis();
                    BigDecimal orderCount = this.activityGoodsApi.getEffectiveOrderCount(testMakeOrderReq.getMemberId(), activityInfoVO.getActivityId());
                    log.info("\u67e5\u8be2\u7528\u6237\u6709\u6548\u8ba2\u5355\u8017\u65f6 {} ms, memberId {}", (Object)(System.currentTimeMillis() - getEffectiveOrderCountTime), (Object)memberVo.getMember().getId());
                    if (orderCount.intValue() > 0) {
                        log.info("\u7528\u6237\u5df2\u53c2\u4e0e\u6d3b\u52a8");
                        BaseResponse baseResponse = new BaseResponse("info", "\u60a8\u5df2\u53c2\u4e0e\u6d3b\u52a8");
                        return baseResponse;
                    }
                    long getFashionDetailVoListTime = System.currentTimeMillis();
                    BoundValueOperations fashionDetailVoListCache = this.redisTemplate.boundValueOps((Object)(FASHION_DETAIL_VO_LIST_BY_GOODS_ID_CACHE_KEY_PREFIX + testMakeOrderReq.getGoodsId()));
                    List fashionDetailVoList = (List)fashionDetailVoListCache.get();
                    if (Lang.isEmpty((Object)fashionDetailVoList) && !Lang.isEmpty((Object)(fashionDetailVoList = this.activitiesService.getFashionDetailVoListByGoodsId(testMakeOrderReq.getGoodsId())))) {
                        fashionDetailVoListCache.set((Object)fashionDetailVoList, 10L, TimeUnit.MINUTES);
                    }
                    log.info("\u83b7\u53d6\u4e0b\u5355\u89c4\u683c\u8017\u65f6 {} ms", (Object)(System.currentTimeMillis() - getFashionDetailVoListTime));
                    if (Lang.isEmpty((Object)fashionDetailVoList)) {
                        log.error("\u4e0b\u5355\u5931\u8d25 : goodsId {} \u65e0\u6cd5\u627e\u5230 ProductFashion \u6570\u636e", (Object)testMakeOrderReq.getGoodsId());
                        BaseResponse baseResponse = new BaseResponse("info", "\u8be5\u5546\u54c1\u65e0\u6cd5\u8d2d\u4e70, \u8bf7\u9009\u62e9\u5176\u4ed6\u5546\u54c1");
                        return baseResponse;
                    }
                    MemberAddressDto address = new MemberAddressDto();
                    address.setMember(memberVo.getMember());
                    address.setUsername("\u6d4b\u8bd5\u4eba\u5458");
                    address.setPhone("13888888888");
                    address.setDetailaddress("\u6d4b\u8bd5\u5730\u5740\u8bf7\u52ff\u53d1\u8d27");
                    address.setAddressDetail("\u6d4b\u8bd5\u5730\u5740\u8bf7\u52ff\u53d1\u8d27");
                    address.setProvinceCode("110000");
                    address.setProvinceName("\u5317\u4eac");
                    address.setCityCode("110100");
                    address.setCityName("\u5317\u4eac");
                    address.setAreaCode("110101");
                    address.setAreaName("\u4e1c\u57ce\u533a");
                    address.setTownCode("d8a15c70-9c8a-44b6-bc34-06b457ecfaaf");
                    address.setTownName("\u5185\u73af\u5230\u4e09\u73af\u91cc");
                    address.setEmail("test@test.com");
                    long createTempOrderTime = System.currentTimeMillis();
                    log.info("\u6b63\u5728\u521b\u5efa\u4e34\u65f6\u8ba2\u5355, memberId {}", (Object)testMakeOrderReq.getMemberId());
                    TempOrderVo tempOrder = this.orderMainApi.newTempOrderByFasions(fashionDetailVoList, this.organizationCode, address.getAreaCode());
                    log.info("\u521b\u5efa\u4e34\u65f6\u8ba2\u5355\u8017\u65f6 {} ms, memberId {}, \u7ed3\u679c {}", new Object[]{System.currentTimeMillis() - createTempOrderTime, testMakeOrderReq.getMemberId(), JSON.toJSONString((Object)tempOrder)});
                    ((TempOrderItemVo)((TempOrderStoreVo)tempOrder.getStoreList().get(0)).getOrderItems().get(0)).setActivityId(activityInfoVO.getActivityId());
                    BaseResponse baseResponse = this.activitiesService.makeOrder(tempOrder, address, memberVo, fashionDetailVoList, address.getTownCode());
                    return baseResponse;
                }
                log.error("\u7528\u6237\u9501\u83b7\u53d6\u5931\u8d25, memberId {}", (Object)testMakeOrderReq.getMemberId());
                BaseResponse baseResponse = new BaseResponse("info", "\u60a8\u7684\u8bf7\u6c42\u6b63\u5728\u5904\u7406, \u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4");
                return baseResponse;
            }
            catch (Exception e) {
                log.error("\u4e0b\u5355\u5f02\u5e38", (Throwable)e);
                BaseResponse baseResponse = new BaseResponse("error", "\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6216\u7a0d\u540e\u91cd\u8bd5");
                return baseResponse;
            }
            finally {
                log.info("\u7528\u6237\u4e0b\u5355\u8017\u65f6 {} ms, memberId {}", (Object)(System.currentTimeMillis() - orderTime), (Object)testMakeOrderReq.getMemberId());
                if (!Lang.isEmpty((Object)userLocker)) {
                    userLocker.unlock();
                }
            }
        }
        log.error("\u7528\u6237\u91cd\u590d\u8bf7\u6c42\u62e6\u622a, memberId {}", (Object)testMakeOrderReq.getMemberId());
        return new BaseResponse("info", "\u60a8\u7684\u8bf7\u6c42\u6b63\u5728\u5904\u7406, \u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4");
    }
}

