/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.repository.zoo;

import ai.djl.Application;
import ai.djl.MalformedModelException;
import ai.djl.repository.Artifact;
import ai.djl.repository.MRL;
import ai.djl.repository.zoo.BaseModelLoader;
import ai.djl.repository.zoo.Criteria;
import ai.djl.repository.zoo.ModelLoader;
import ai.djl.repository.zoo.ModelNotFoundException;
import ai.djl.repository.zoo.ModelZooResolver;
import ai.djl.repository.zoo.ZooModel;
import ai.djl.repository.zoo.ZooProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;

public abstract class ModelZoo {
    private static final Map<String, ModelZoo> MODEL_ZOO_MAP = new ConcurrentHashMap<String, ModelZoo>();
    private static ModelZooResolver resolver;
    private Map<String, ModelLoader> modelLoaders = new ConcurrentHashMap<String, ModelLoader>();

    public abstract String getGroupId();

    public Collection<ModelLoader> getModelLoaders() {
        return this.modelLoaders.values();
    }

    public ModelLoader getModelLoader(String name) {
        return this.modelLoaders.get(name);
    }

    public abstract Set<String> getSupportedEngines();

    protected final void addModel(MRL mrl) {
        this.modelLoaders.put(mrl.getArtifactId(), new BaseModelLoader(mrl));
    }

    protected final void addModel(ModelLoader loader) {
        this.modelLoaders.put(loader.getArtifactId(), loader);
    }

    public static void setModelZooResolver(ModelZooResolver resolver) {
        ModelZoo.resolver = resolver;
    }

    public static void registerModelZoo(ZooProvider provider) {
        ModelZoo zoo = provider.getModelZoo();
        MODEL_ZOO_MAP.put(zoo.getGroupId(), zoo);
    }

    public static Collection<ModelZoo> listModelZoo() {
        return MODEL_ZOO_MAP.values();
    }

    public static ModelZoo getModelZoo(String groupId) {
        ModelZoo zoo = MODEL_ZOO_MAP.get(groupId);
        if (zoo == null && resolver != null && (zoo = resolver.resolve(groupId)) != null) {
            MODEL_ZOO_MAP.putIfAbsent(groupId, zoo);
        }
        return zoo;
    }

    public static boolean hasModelZoo(String groupId) {
        return MODEL_ZOO_MAP.containsKey(groupId);
    }

    public static <I, O> ZooModel<I, O> loadModel(Criteria<I, O> criteria) throws IOException, ModelNotFoundException, MalformedModelException {
        return criteria.loadModel();
    }

    public static Map<Application, List<Artifact>> listModels() throws IOException, ModelNotFoundException {
        return ModelZoo.listModels(Criteria.builder().build());
    }

    public static Map<Application, List<Artifact>> listModels(Criteria<?, ?> criteria) throws IOException, ModelNotFoundException {
        String artifactId = criteria.getArtifactId();
        ModelZoo modelZoo = criteria.getModelZoo();
        String groupId = criteria.getGroupId();
        String engine = criteria.getEngine();
        Application application = criteria.getApplication();
        TreeMap<Application, List<Artifact>> models = new TreeMap<Application, List<Artifact>>(Comparator.comparing(Application::getPath));
        for (ModelZoo zoo : ModelZoo.listModelZoo()) {
            if (modelZoo != null) {
                if (groupId != null && !modelZoo.getGroupId().equals(groupId)) continue;
                Set<String> supportedEngine = modelZoo.getSupportedEngines();
                if (engine != null && !supportedEngine.contains(engine)) continue;
            }
            for (ModelLoader loader : zoo.getModelLoaders()) {
                Application app = loader.getApplication();
                String loaderArtifactId = loader.getArtifactId();
                if (artifactId != null && !artifactId.equals(loaderArtifactId) || application != Application.UNDEFINED && app != Application.UNDEFINED && !app.matches(application)) continue;
                List<Artifact> artifacts = loader.listModels();
                models.compute(app, (key, val) -> {
                    if (val == null) {
                        val = new ArrayList();
                    }
                    val.addAll(artifacts);
                    return val;
                });
            }
        }
        return models;
    }

    static {
        ServiceLoader<ZooProvider> providers = ServiceLoader.load(ZooProvider.class);
        for (ZooProvider provider : providers) {
            ModelZoo.registerModelZoo(provider);
        }
    }
}

