/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.ndarray;

import ai.djl.ndarray.BytesSupplier;
import ai.djl.util.JsonUtils;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

class BytesSupplierImpl
implements BytesSupplier {
    private byte[] buf;
    private String value;
    private Object obj;

    BytesSupplierImpl(byte[] buf) {
        this.buf = buf;
    }

    BytesSupplierImpl(String value) {
        this.value = value;
    }

    BytesSupplierImpl(Object obj) {
        this.obj = obj;
    }

    @Override
    public byte[] getAsBytes() {
        if (this.buf == null) {
            if (this.value == null) {
                this.value = JsonUtils.toJson(this.obj) + '\n';
            }
            this.buf = this.value.getBytes(StandardCharsets.UTF_8);
        }
        return this.buf;
    }

    @Override
    public String getAsString() {
        if (this.value == null) {
            this.value = this.obj != null ? JsonUtils.toJson(this.obj) + '\n' : new String(this.buf, StandardCharsets.UTF_8);
        }
        return this.value;
    }

    @Override
    public Object getAsObject() {
        if (this.obj != null) {
            return this.obj;
        }
        if (this.value != null) {
            return this.value;
        }
        return this.buf;
    }

    @Override
    public ByteBuffer toByteBuffer() {
        return ByteBuffer.wrap(this.getAsBytes());
    }
}

