package api;

import dto.VoteDetailDto;
import dto.VoteQueryResultDto;
import sinomall.global.common.response.BaseResponse;

import java.util.List;

/**
 * @author 陈圣融
 * @date 2018-03-14
 * 竞价投票api
 **/
public interface BiddingVoteApi {

    /**
     * 系统随机确认供应商
     *
     * @param biddingCode 竞价编号
     * @return BaseResponse
     */
    BaseResponse randomConfirmSupplier(String biddingCode);
    /**
     * 投票接口
     * @param voteDetailDto
     */
    BaseResponse voteSelectionSupplier(VoteDetailDto voteDetailDto);

    /**
     * 查询的投票详情
     * @param biddingNo
     * @return
     */
    List<VoteQueryResultDto> voteDetailsQuery(String biddingNo);
}
