package api.query;

import dto.*;
import org.springframework.data.domain.Page;
import sinomall.global.common.response.BaseResponse;

import java.util.List;

/**
 *
 * @author 陈圣融
 * @date 2018/03/14
 * 符合性审查api
 */
public interface BiddingConformityReviewQueryApi {

    /**
     * 获取竞价小组成员信息
     *
     * @param biddingNo 竞价编号
     * @return BaseResponse<List<JcbdBiddingGroupMemberDto>>
     */
    BaseResponse<List<JcbdBiddingGroupMemberDto>> findBiddingGroupMember(String biddingNo);

    /**
     * 符合性审查需求查询接口
     * @param biddingId
     * @return
     */
    List<JcbdBiddingDemandDto> findDemands(String biddingId);
    //=========================================符合性审查页开始==================================
    /**
     * 获取符合性审核列表dto  符合性审核页
     * @param conformityQueryDto
     * @return
     */
    Page<BiddingConformityListDto> getConformityListByQueryDto(BiddingConformityQueryDto conformityQueryDto);

    /**
     * 获取符合性审核信息-供应商需求响应的具体信息-符合性审核页
     * 一次性获取所有数据
     * @param demandCode
     * @return
     */
    List<JcbdBiddingDemandResponseDto> getConformityAuditInfo(String demandCode);

    /**
     * 获取符合性审核概要 -供应商的信息概要
     * @param conformityQueryDto 应该包含biddingCode demandCode
     * @return
     */
    BaseResponse<List<BiddingResponseOutlineDto>> queryConformityOutline(BiddingConformityQueryDto conformityQueryDto);

    /**
     * 获取符合性审核详情（每个供应商）
     * @param conformityQueryDto
     * @return
     */
    BaseResponse<JcbdBiddingDemandResponseDto> getConformityDetail(BiddingConformityQueryDto conformityQueryDto);
    //=========================================符合性审查页结束==================================

    /**
     * 删除选中的竞价小组成员的符合性审查数据
     * @param biddingNo
     * @param email
     * @param groupMemberId
     * @return
     */
    void deleteComplianceAudit(String biddingNo,String email,String groupMemberId);
}
