package api.query;

import dto.BiddingOrderInfoDto;
import dto.JcbdMallOrderDto;
import java.util.List;

/**
 * @author Jian.
 * @date 2018/3/20
 */
public interface BiddingMallOrderQueryApi {

    /**
     * 通过竞价采购id查找采购实物商城订单
     * @param jcbdOrderId
     * @return
     */
    List<JcbdMallOrderDto> findByJcbdOrderId(String jcbdOrderId);

    /**
     * 更新状态
     * @param status
     * @param orderNo
     * @return
     */
    JcbdMallOrderDto updateStatusByOrderNo(String status,String orderNo);
    /**
     * 删除订单
     * @param orderNo
     * @return
     */
    JcbdMallOrderDto deleteJcbdMallOrderByOrderNo(String orderNo);

    /**
     * 通过订单号获得订单类型和供应商名称
     * @param orderNo
     * @return
     */
    BiddingOrderInfoDto getOrderInfoByOrderNo(String orderNo);

    /**
     * 获取订单
     * @param orderNo orderNo
     * @return JcbdMallOrderDto
     */
    JcbdMallOrderDto findByOrderNo(String orderNo);

    /**
     * 更新订单状态
     *
     * @param mallOrderNo String
     * @param status String
     * @param supplierOrderStatus String
     */
    void updateStatusAndSupplierStatus(String mallOrderNo, String status, String supplierOrderStatus);

    /**
     * 取消购买记录订单
     * @param orderNo
     */
    void cancelPurchaseLogOrder(String orderNo);
}
