package api.query;

import dto.BiddingOrderMangerDto;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import query.BiddingOrderManagerListQuery;

import java.util.List;

/**
* @author luoxianwei
* @date 2018/4/14
*/
public interface BiddingOrderManagerApi {

    /**
     * 查询分页获取订单管理列表
     *
     * @param biddingOrderManagerListQuery
     * @param pageable
     * @return BaseResponse<Page<BiddingOrderResultDto>>
     */
    Page<BiddingOrderMangerDto> getBiddingOrderMangerList(BiddingOrderManagerListQuery biddingOrderManagerListQuery, Pageable pageable);

    /**
     * 获取取消订单数量
     * @param biddingOrderManagerListQuery
     * @return
     */
    List<BiddingOrderMangerDto> getCancelOrders(BiddingOrderManagerListQuery biddingOrderManagerListQuery);
}
