package api.query;

import dto.*;
import sinomall.global.common.response.BaseResponse;

import java.util.List;

/**
 * @author Jian.
 * @date 2018/3/20
 */
public interface BiddingOrderQueryApi {

    /**
     * 通过竞价biddingCode查询改竞价的订单
     *
     * @param biddingCode
     * @return
     */
    List<JcbdOrderDto> findByJcbdBiddingId(String biddingCode);

    /**
     * 通过竞价Code查询改竞价的订单
     *
     * @param biddingCode
     * @return
     */
    List<JcbdOrderDto> findAllByBiddingCode(String biddingCode);

    /**
     * 批量查找购买记录
     *
     * @param purchaseLogDto
     * @return
     */
    List<JcbdBiddingPurchaseLogDto> findPurchaseLogs(JcbdBiddingPurchaseLogDto purchaseLogDto);


    /**
     * 查询是否竞价订单
     *
     * @param parentOrderNo
     * @return
     */
    public BiddingOrderAffiliationDto checkIsBiddingOrder(String parentOrderNo);

    /**
     * 查询竞价订单信息
     * @param bdOrderNo
     * @return
     */
    public JcbdOrderDto findJcbdOrder(String bdOrderNo);


    /**
     * 查找竞价下的临时订单
     * 默认isDelete 为false
     * @param biddingCode
     * @return
     */
    List<JcbdTempOrderDto> findTempOrderByBiddingCode(String biddingCode);

    /**
     *
     * @param orderNo
     * @return
     */
    BiddingOrderOutlineInfoDto findOrderOutlineInfo(String orderNo);

    /**
     * 获取竞价订单
     *
     * @param jdbdOrderId String
     * @return JcbdOrderDto
     */
    JcbdOrderDto findById(String jdbdOrderId);

    /**
     * 跟据商城订单号查询竞价订单号
     * @param mallOrderNo
     * @return
     */
    BaseResponse queryBiddingOrderNoByMallOrderNo(String mallOrderNo);

    /**
     * 修改订单状态
     * @return
     */
    JcbdOrderDto updateStatus(String orderNo,String status);
}
