package api.query;


import dto.*;
import org.springframework.data.domain.Page;
import query.BiddingOrderManagerListQuery;
import query.BiddingOrderResultListQuery;
import sinomall.global.common.response.BaseResponse;

import java.util.List;

public interface BiddingQueryApi {

    /**
     * 根据竞价编号查询竞价信息
     * @param biddingCode
     * @return
     */
    JcbdBiddingDto findByBiddingCodeAndIsDelete(String biddingCode);

    /**
     * 查询所有的竞价信息
     * @return
     */
    List<JcbdBiddingDto> findAllJcbdBidding();

    /**
     * 批量通过竞价编号查找竞价信息
     * @param binddingNo
     * @return
     */
    List<JcbdBiddingDto> findJcbdBiddingByBiddingNo(List<String> binddingNo);


    /**
     * 根据角色码和当前竞价状态以及用途查询可操作方式
     * @param roleCode
     * @param status
     * @param module
     * @return
     */
    List<JcbdRoleOperationDto> findByRoleCodeAndStatusAndModuleOrderByShowIndex(String roleCode,String status,String module);

    /**
     * 根据竞价编号和状态查询报价相同的供应商数
     * @param biddingNo
     * @param status
     * @return
     */
    List<JcbdBdProviderDto> findByBiddingNoAndStatus(String biddingNo,String status);

    /**
     * 根据竞价编号和邮箱查询小组成员状态
     * @param biddingNo
     * @param email
     */
    JcbdBiddingGroupMemberDto findGroupStatus(String email,String biddingNo);
}
