package api.query;

import dto.*;
import org.springframework.data.domain.Page;
import query.BiddingDemandListQuery;
import query.BiddingDemandRespQuery;
import query.SupplierBiddingDamandQuery;
import sinomall.global.common.response.BaseResponse;

import java.util.List;

/**
 * @author 陈圣融
 * @date 2018-03-14
 * 竞价响应查询api
 **/
public interface BiddingResponseQueryApi {

    /**
     * 新建竞价时获取当前所有可用供应商
     * <p>
     * 调用外部接口
     * @param biddingNo 竞价编号
     * @return BaseResponse<List<BiddingSupplierDTO>>
     */
    BaseResponse<List<BiddingSupplierDTO>> getAllSupplier(String biddingNo);

    /**
     * 验证供应商响应sku有效性接口
     *
     * @param storeId
     * @param sku
     * @return 有效则返回商品链接
     */
    ProvSkuEffectieResultDto provBiddingSkuEffective(String storeId, List<String> sku);


    /**
     * 查询竞价需求最终成交供应商信息
     * @param demandCode
     * @return
     */
    BaseResponse<BiddingResultSupplierInfoQueryDto> getBiddingResultSupplierInfo(String demandCode);

    /**
     * 供应商需求响应查询接口
     * @param biddingDemandRespQuery 查询参数
     * @return
     */
    public BaseResponse<JcbdBiddingDemandResponseDto> queryBiddingDemandResponse(BiddingDemandRespQuery biddingDemandRespQuery);


    /**
     * 供应商竞价响应 需求概要信息查询(供应商)
     *
     * @param supplierBiddingDamandQuery
     * @return
     */
    public BaseResponse<Page<BiddingResponseDemandOutlineDto>> supplierBiddingResponseDemandOutline(SupplierBiddingDamandQuery supplierBiddingDamandQuery);

    /**
     * 供应商竞价响应概要信息查询
     *
     * @param biddingNo 竞价编号
     * @param demandCode 需求编号
     * @return
     */
    public BaseResponse<List<BiddingResponseOutlineDto>> queryBiddingResponseOutline(String biddingNo,String demandCode);

    /**
     * 比价信息查询
     *
     * @param biddingNo 竞价编号
     * @return
     */
    public BaseResponse<BiddingPriceParityDto> queryBiddingPriceParity(String biddingNo);


    /**
     * 批量查询竞价响应
     * @param demandRspIds
     * @return
     */
    List<JcbdBiddingDemandResponseDto> findAll(List<String> demandRspIds);

    /**
     * 查询该竞价下所有需求目标供应商是否已经全部响应
     * @param jcbdBiddingNo
     * @param responseProviderId
     * @return
     */
    BaseResponse isAllDemandAreResponse(String jcbdBiddingNo,String responseProviderId);

    /**
     * 查询该竞价下目标供应商所有需求响应是否全部符合
     * @param jcbdBiddingNo
     * @param responseProviderId
     * @return
     */
    BaseResponse demandResponseIsAllAccord(String jcbdBiddingNo,String responseProviderId);

    /**
     * 查询该竞价所有需求在该供应商的响应
     * @param parms
     * @return
     */
    Page<DemandResponseQueryDto> findDemandAndResponse(DemanResponseParmDto parms);

    /**
     * 查询该竞价需求下的所有sku
     * @param jcbdBiddingNo
     * @param supplierId
     * @return
     */
    List<String> findBiddingResponseSkus(String jcbdBiddingNo, String supplierId);


    /**
     * 通过竞价编号查询已成交供应商需求响应列表
     * @param biddingDemandListQuery
     * @return
     */
    BaseResponse<Page<BiddingResultDemandQueryDto>> getBiddingResultDemandList(BiddingDemandListQuery biddingDemandListQuery);

    /**
     * 根据sku获取商品价格以及需求id
     * @param biddingNo
     * @param sku
     */
    JcbdBiddingDemandResponseDto findProviderResponsePrice(String biddingNo, String sku);

    /**
     * 是否有修改sku
     * @param biddingNo
     * @param supplierId
     * @return
     */

    BaseResponse findModifySkuFlag(String biddingNo, String supplierId);

    /**
     * 获取供应商信息
     * @param biddingId
     * @param supplierId
     * @return
     */
    JcbdBdProviderDto getProviderByBiddingNoAndSupplierId(String biddingId, String supplierId);
}
