package api.query;

import dto.JcbdRoleOperationDto;
import query.BiddingOperatorQuery;

import java.util.List;

/**
 *
 * 竞价状态查询api
 *
 * Created by miaohao on 2018/3/16.
 */
public interface BiddingRoleOperationQueryApi {

    /**
     * 跟据角色码查询可查看的竞价状态
     * @param roleCodes
     * @return List<JcbdRoleOperationDto>
     */
    List<JcbdRoleOperationDto> getAllStatusByRoles(List<String> roleCodes);

    /**
     * 根据角色码和当前竞价状态查询可操作方式
     * @param roleCode
     * @param status
     * @return
     */
    List<JcbdRoleOperationDto>findByRoleCodeAndStatus(String roleCode,String status);

    /**
     * 根据角色码和当前竞价状态以及用途查询可操作方式
     * @param roleCode
     * @param status
     * @param module
     * @return List<JcbdRoleOperationDto>
     */
    List<JcbdRoleOperationDto> findByRoleCodeAndStatusAndModuleOrderByShowIndex(String roleCode,String status,String module);

    /**
     * 根据竞价编号及用户角色查询用户对该竞价的操作
     * @param biddingCode
     * @param memberId
     * @return
     */
    List<JcbdRoleOperationDto> getOperatorBiddingOperateByBiddingCode(BiddingOperatorQuery biddingOperatorQuery);

    /**
     * 通过模块名和竞价状态获取可展示的标签
     * @param status
     * @param module
     * @return
     */
    List<String> getBiddingShowTitle(String status,String module);

    /**
     * 根据竞价编号及状态状态查询供应商对该竞价的操作
     * @param biddingNo
     * @param status
     * @return
     */
    List<JcbdRoleOperationDto> getSupplierBiddingOperateByBiddingCode(String biddingNo, String status);
}
