package definition;

import java.util.HashMap;
import java.util.Map;

/**
* @author luoxianwei
* @date 2018/4/14
* 审核人员竞价状态枚举类
*/
public enum BiddingAuditStatus {

    //审核人员
    AUDITOR_RESULT_AUDIT_WAIT(null,"待审核"),
    AUDITOR_RESULT_AUDIT_NOT("0","审核不通过"),
    AUDITOR_RESULT_AUDIT_YES("1","审核通过");



    public static Map<String, BiddingAuditStatus> biddingAuditStatusMap = new HashMap<>();
    static {
        biddingAuditStatusMap.put(AUDITOR_RESULT_AUDIT_WAIT.getValue(),AUDITOR_RESULT_AUDIT_WAIT);
        biddingAuditStatusMap.put(AUDITOR_RESULT_AUDIT_NOT.getValue(),AUDITOR_RESULT_AUDIT_NOT);
        biddingAuditStatusMap.put(AUDITOR_RESULT_AUDIT_YES.getValue(),AUDITOR_RESULT_AUDIT_YES);
    }

    private String value;
    private String description;

    BiddingAuditStatus(String value, String description) {
        this.value = value;
        this.description = description;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

}
