package definition;

import lombok.Getter;
import lombok.Setter;

import java.util.HashMap;
import java.util.Map;

/**
 * 业务码
 *
 * @author Drury
 * @date 2018-03-15
 */
public enum BiddingBusinessCode {

    /**
     * 对报价相同的供应商投票
     */
    BIDDING_VOTE_TO_SUPPLIER("1", "对报价相同的供应商投票");


    /**
     * 业务码
     */
    @Getter
    @Setter
    private String value;

    /**
     * 业务描述
     */
    @Getter
    @Setter
    private String description;

    BiddingBusinessCode(String value, String description) {
        this.value = value;
        this.description = description;
    }

    public static Map<String, BiddingBusinessCode> biddingConformAuditStatusMap = new HashMap<>();

    static {
        biddingConformAuditStatusMap.put(BIDDING_VOTE_TO_SUPPLIER.getValue(), BIDDING_VOTE_TO_SUPPLIER);
    }
}
