package definition;

import lombok.Getter;
import lombok.Setter;

import java.util.HashMap;
import java.util.Map;

/**
 * 竞价需求符合性审查审核结果枚举类
 *
 * @author Drury
 * @date 2018-03-15
 */
public enum BiddingConformAuditStatus {

    /**
     * 符合, 审核状态为 1
     */
    ACCORD("1", "符合"),

    /**
     * 不符合, 审核状态为 0
     */
    NOT_ACCORD("0", "不符合");

    /**
     * 审核状态
     */
    @Getter
    @Setter
    private String value;

    /**
     * 描述
     */
    @Getter
    @Setter
    private String description;

    BiddingConformAuditStatus(String value, String description) {
        this.value = value;
        this.description = description;
    }

    public static Map<String, BiddingConformAuditStatus> biddingConformAuditStatusMap = new HashMap<>();

    static {
        biddingConformAuditStatusMap.put(ACCORD.getValue(), ACCORD);
        biddingConformAuditStatusMap.put(NOT_ACCORD.getValue(), NOT_ACCORD);
    }
}
