package definition;

import java.util.HashMap;
import java.util.Map;

/**
 * Created on 2018/3/31.
 * 竞价需求响应状态
 * @author junyang.dong
 */
public enum BiddingDemandResStatus {

    /**
     * 未响应 状态为0
     */
    NOT_DEMAND_RESPONSE_STATUS("0","未响应"),
    /**
     * 已响应 状态为1
     */
    DEMAND_RESPONSE_STATUS("1","已响应");

    public static Map<String, BiddingDemandResStatus> biddingProviderResStatusMap = new HashMap<>();
    static {
        biddingProviderResStatusMap.put(NOT_DEMAND_RESPONSE_STATUS.getCode(),NOT_DEMAND_RESPONSE_STATUS);
        biddingProviderResStatusMap.put(DEMAND_RESPONSE_STATUS.getCode(),DEMAND_RESPONSE_STATUS);
    }

    private String code;
    private String description;

    BiddingDemandResStatus(String code, String description){
        this.code = code;
        this.description = description;
    }


    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}
