package definition;

import lombok.Getter;
import lombok.Setter;

import java.util.HashMap;
import java.util.Map;

/**
 * @author wangtao.
 * @date 2018年3月26日13:43:45.
 */
public enum BiddingGroupMemberStatus {


    /**
     * 有效 1
     */
    VALID(1, "有效的"),

    /**
     * 无效 0
     */
    INVALID(0, "无效的");

    /**
     * 状态值
     */
    @Getter
    @Setter
    private Integer value;

    /**
     * 描述
     */
    @Getter
    @Setter
    private String description;

    BiddingGroupMemberStatus(Integer value, String description) {
        this.value = value;
        this.description = description;
    }

    public static Map<String, BiddingGroupMemberStatus> biddingGroupMemberStatusMap = new HashMap<>();

    static {
        biddingGroupMemberStatusMap.put(VALID.getValue().toString(), VALID);
        biddingGroupMemberStatusMap.put(INVALID.getValue().toString(), INVALID);
    }
}
