package definition;

import java.util.HashMap;
import java.util.Map;

/**
 * 竞价操作码枚举类（如有遗漏，请自行添加）
 * <p>
 * Created by miaohao on 2018/3/19.
 */
public enum BiddingOperateCode {
    /**
     * 竞价操作码
     */
    NEW_BIDDING("0", "新建竞价采购"),
    MODIFY_BIDDING("1", "修改竞价采购"),
    SUBMIT_BIDDING("2", "提交竞价采购审核"),
    AUDIT_BIDDING_PASS("3_1", "审核竞价采购"),
    AUDIT_BIDDING_NOPASS("3_2", "审核竞价采购"),
    ISSUE_BIDDING("4", "发布竞价"),
    ABANDON_RESPONSE("5", "放弃响应"),
    RESPOND_BIDDING("6", "竞价响应"),
    MODIFY_RESPONSE("7", "修改响应"),
    START_CONFORMITY_REVIEW("8", "开启符合性审查"),
    IN_CONFORMITY_REVIEW_PASS("9_1", "符合性审查通过"),
    IN_CONFORMITY_REVIEW_NO_PASS("9_2", "符合性审查不通过"),
    RESTART_CONFORMITY_REVIEW("10", "重新发起审查"),

    //供应商=1
    START_QUOTED_PRICE_EQUALS_ONE("11_1", "开启报价"),
    //供应商>1
    START_QUOTED_PRICE_OVER_ONE_VOTE("11_2", "开启报价-投票决定"),

    START_QUOTED_PRICE_OVER_ONE_RANDOM("11_3", "开启报价-随机决定"),

    RANDOM_CONFIRM_SUPPLIER("12", "系统随机确定供应商"),
    VOTE_CONFIRM_SUPPLIER("13", "开启投票确定供应商"),

    //平票
    VOTE_PLANE_TICKETS("14_1", "投票"),
    //不平票
    VOTE_NO_PLANE_TICKETS("14_2", "投票"),
    SUBMIT_BIDDING_RESULT("15", "提交竞价结果审核"),
    AUDIT_BIDDING_RESULT_PASS("16_1", "竞价结果审核通过"),
    AUDIT_BIDDING_RESULT_NO_PASS("16_2", "竞价结果审核不通过"),
    //（sku有效）
    CONFIRM_BIDDING_RESULT_YES("17_1", "确认竞价结果"),
    //（sku缺少）
    CONFIRM_BIDDING_RESULT_NO("17_2", "确认竞价结果"),
    SUBMIT_BIDDING_SKU("18", "提交sku修改"),
    AUDIT_BIDDING_SKU_PASS("19_1", "审核sku通过"),
    AUDIT_BIDDING_SKU_NO_PASS("19_2", "审核sku不通过"),
    FINISH_BIDDING("20", "竞价终止"),
    DO_BUY("21", "执行采购"),
    AUDIT_ORDER("22", "订单审核"),
    CONFIRM_ORDER("23", "确认订单"),
    WAITTING_GET("24", "等待收货"),
    /**
     * 供应商操作码
     */
    SUPPLIER_INIT("1001","初始化供应商状态");
//    supplier_response("1001","");
//    supplier_init("1001","初始状态");
//    supplier_init("1001","初始状态");

    public static Map<String, BiddingOperateCode> biddingOperateCodeMap = new HashMap<>();

    static {
        biddingOperateCodeMap.put(NEW_BIDDING.getCode(), NEW_BIDDING);
        biddingOperateCodeMap.put(MODIFY_BIDDING.getCode(), MODIFY_BIDDING);
        biddingOperateCodeMap.put(SUBMIT_BIDDING.getCode(), SUBMIT_BIDDING);
        biddingOperateCodeMap.put(AUDIT_BIDDING_PASS.getCode(), AUDIT_BIDDING_PASS);
        biddingOperateCodeMap.put(AUDIT_BIDDING_NOPASS.getCode(), AUDIT_BIDDING_NOPASS);
        biddingOperateCodeMap.put(ISSUE_BIDDING.getCode(), ISSUE_BIDDING);
        biddingOperateCodeMap.put(ABANDON_RESPONSE.getCode(), ABANDON_RESPONSE);
        biddingOperateCodeMap.put(RESPOND_BIDDING.getCode(), RESPOND_BIDDING);
        biddingOperateCodeMap.put(MODIFY_RESPONSE.getCode(), MODIFY_RESPONSE);
        biddingOperateCodeMap.put(START_CONFORMITY_REVIEW.getCode(), START_CONFORMITY_REVIEW);
        biddingOperateCodeMap.put(IN_CONFORMITY_REVIEW_PASS.getCode(), IN_CONFORMITY_REVIEW_PASS);
        biddingOperateCodeMap.put(IN_CONFORMITY_REVIEW_NO_PASS.getCode(), IN_CONFORMITY_REVIEW_NO_PASS);
        biddingOperateCodeMap.put(RESTART_CONFORMITY_REVIEW.getCode(), RESTART_CONFORMITY_REVIEW);
        biddingOperateCodeMap.put(START_QUOTED_PRICE_EQUALS_ONE.getCode(), START_QUOTED_PRICE_EQUALS_ONE);
        biddingOperateCodeMap.put(START_QUOTED_PRICE_OVER_ONE_VOTE.getCode(), START_QUOTED_PRICE_OVER_ONE_VOTE);
        biddingOperateCodeMap.put(START_QUOTED_PRICE_OVER_ONE_RANDOM.getCode(), START_QUOTED_PRICE_OVER_ONE_RANDOM);
        biddingOperateCodeMap.put(RANDOM_CONFIRM_SUPPLIER.getCode(), RANDOM_CONFIRM_SUPPLIER);
        biddingOperateCodeMap.put(VOTE_CONFIRM_SUPPLIER.getCode(), VOTE_CONFIRM_SUPPLIER);
        biddingOperateCodeMap.put(VOTE_PLANE_TICKETS.getCode(), VOTE_PLANE_TICKETS);
        biddingOperateCodeMap.put(VOTE_NO_PLANE_TICKETS.getCode(), VOTE_NO_PLANE_TICKETS);
        biddingOperateCodeMap.put(SUBMIT_BIDDING_RESULT.getCode(), SUBMIT_BIDDING_RESULT);
        biddingOperateCodeMap.put(AUDIT_BIDDING_RESULT_PASS.getCode(), AUDIT_BIDDING_RESULT_PASS);
        biddingOperateCodeMap.put(AUDIT_BIDDING_RESULT_NO_PASS.getCode(), AUDIT_BIDDING_RESULT_NO_PASS);
        biddingOperateCodeMap.put(CONFIRM_BIDDING_RESULT_YES.getCode(), CONFIRM_BIDDING_RESULT_YES);
        biddingOperateCodeMap.put(CONFIRM_BIDDING_RESULT_NO.getCode(), CONFIRM_BIDDING_RESULT_NO);
        biddingOperateCodeMap.put(SUBMIT_BIDDING_SKU.getCode(), SUBMIT_BIDDING_SKU);
        biddingOperateCodeMap.put(AUDIT_BIDDING_SKU_PASS.getCode(), AUDIT_BIDDING_SKU_PASS);
        biddingOperateCodeMap.put(AUDIT_BIDDING_SKU_NO_PASS.getCode(), AUDIT_BIDDING_SKU_NO_PASS);
        biddingOperateCodeMap.put(FINISH_BIDDING.getCode(), FINISH_BIDDING);
        biddingOperateCodeMap.put(DO_BUY.getCode(), DO_BUY);
        biddingOperateCodeMap.put(AUDIT_ORDER.getCode(), AUDIT_ORDER);
        biddingOperateCodeMap.put(CONFIRM_ORDER.getCode(), CONFIRM_ORDER);
        biddingOperateCodeMap.put(WAITTING_GET.getCode(), WAITTING_GET);
    }


    private String code;

    private String codeName;

    BiddingOperateCode(String code, String codeName) {
        this.code = code;
        this.codeName = codeName;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getCodeName() {
        return codeName;
    }

    public void setCodeName(String codeName) {
        this.codeName = codeName;
    }
}
