package definition;

import java.util.HashMap;
import java.util.Map;

/**
 * 竞价状态
 *
 * @author 陈圣融
 * @date 2018-03-24
 **/
public enum BiddingOrderStatus {
    //竞价订单状态
    ORDER_STATUS_INREVIEW("1","审核中"),
    ORDER_STATUS_AUDITFAILURE("2","审核不通过"),
    ORDER_STATUS_TOBECONFIRMED("3","待确认"),
    ORDER_STATUS_TOBERECEIVED("4","待收货"),
    ORDER_STATUS_HAVEGOODS("5","已收货"),
    ORDER_STATUS_COMPLETED("6","已完成"),
    ORDER_STATUS_HAVEBEENCANCELLED("7","已取消"),
    ORDER_STATUS_REJECTION("8","拒收"),
//    ORDER_STATUS_ERROR("9","错误订单"),

    //供应商订单状态
    SUPPLIER_ORDER_STATUS_TOBECONFIRMED("1","待确认"),
    SUPPLIER_ORDER_STATUS_CONFIRMED("2","已确认"),
    SUPPLIER_ORDER_STATUS_CANCELLED("3","已取消");


    public static Map<String, BiddingOrderStatus> biddingOrderStatusMap = new HashMap<>();
    static{
        biddingOrderStatusMap.put(ORDER_STATUS_INREVIEW.getCode(),ORDER_STATUS_INREVIEW);
        biddingOrderStatusMap.put(ORDER_STATUS_AUDITFAILURE.getCode(),ORDER_STATUS_AUDITFAILURE);
        biddingOrderStatusMap.put(ORDER_STATUS_TOBECONFIRMED.getCode(),ORDER_STATUS_TOBECONFIRMED);
        biddingOrderStatusMap.put(ORDER_STATUS_TOBERECEIVED.getCode(),ORDER_STATUS_TOBERECEIVED);
        biddingOrderStatusMap.put(ORDER_STATUS_HAVEGOODS.getCode(),ORDER_STATUS_HAVEGOODS);
        biddingOrderStatusMap.put(ORDER_STATUS_COMPLETED.getCode(),ORDER_STATUS_COMPLETED);
        biddingOrderStatusMap.put(ORDER_STATUS_HAVEBEENCANCELLED.getCode(),ORDER_STATUS_HAVEBEENCANCELLED);
        biddingOrderStatusMap.put(ORDER_STATUS_REJECTION.getCode(),ORDER_STATUS_REJECTION);
//        biddingOrderStatusMap.put(ORDER_STATUS_ERROR.getCode(),ORDER_STATUS_ERROR);
    }

    public static Map<String, BiddingOrderStatus> biddingSupplierOrderStatusMap = new HashMap<>();
    static{
        biddingSupplierOrderStatusMap.put(SUPPLIER_ORDER_STATUS_TOBECONFIRMED.getCode(),SUPPLIER_ORDER_STATUS_TOBECONFIRMED);
        biddingSupplierOrderStatusMap.put(SUPPLIER_ORDER_STATUS_CONFIRMED.getCode(),SUPPLIER_ORDER_STATUS_CONFIRMED);
        biddingSupplierOrderStatusMap.put(SUPPLIER_ORDER_STATUS_CANCELLED.getCode(),SUPPLIER_ORDER_STATUS_CANCELLED);
    }
    private String code;
    private String description;

    BiddingOrderStatus(String code, String description) {
        this.code = code;
        this.description = description;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}
