package definition;

import lombok.Getter;
import lombok.Setter;

import java.util.HashMap;
import java.util.Map;

/**
 * 竞价需求地区供应商响应状态枚举类
 *
 * @author Drury
 * @date 2018/3/20
 */
public enum BiddingProviderAddRespStatus {

    /**
     * 满足, 状态为 1
     */
    ACCORD("1", "满足"),

    /**
     * 不满足, 状态为 0
     */
    NOT_ACCORD("0", "不满足");

    /**
     * 审核状态
     */
    @Getter
    @Setter
    private String value;

    /**
     * 描述
     */
    @Getter
    @Setter
    private String description;

    BiddingProviderAddRespStatus(String value, String description) {
        this.value = value;
        this.description = description;
    }

    public static Map<String, BiddingProviderAddRespStatus> bddingProviderAddRespStatusMap = new HashMap<>();

    static {
        bddingProviderAddRespStatusMap.put(ACCORD.getValue(), ACCORD);
        bddingProviderAddRespStatusMap.put(NOT_ACCORD.getValue(), NOT_ACCORD);
    }

}
