package definition;

import java.util.HashMap;
import java.util.Map;

/**
 * 竞价状态枚举类（如有遗漏，请自行添加）
 *
 * Created by miaohao on 2018/3/16.
 */
public enum BiddingStatus {

    //采购经办人、竞价小组
    OM_SUBMIT_WAIT("om_0","待提交"),
    OM_AUDIT_WAIT("om_1","待审核"),
    OM_AUDIT_NO("om_2","审核不通过"),
    OM_ISSUE_WAIT("om_3","待发布"),
    OM_RESPONSE_WAIT("om_4","待响应"),
    OM_BIDDING_END("om_5","竞价终止"),
    OM_RESPONSE_STOP("om_6","响应结束"),
    OM_CONFORM_AUDIT_IN("om_7","符合性审查中"),
    OM_CONFORM_AUDIT_NO("om_8","符合性审查不通过"),
    OM_CONFORM_AUDIT_YES("om_9","符合性审查通过"),
    //作为查询条件用,存库的是下面两个（庙浩）
    OM_RESULT_SELECT_WAIT("om_10","待选择竞价结果"),

    OM_RESULT_SELECT_WAIT_VOTE("om_10_1","待选择竞价结果"),
    OM_RESULT_SELECT_WAIT_RANDOM("om_10_2","待选择竞价结果"),

    OM_VOTING("om_11","投票中"),
    OM_VOTE_EVEN("om_12","平票"),
    OM_RESULT_SUBMIT_WAIT("om_13","待提交竞价结果"),
    OM_RESULT_AUDIT_WAIT("om_14","待审核竞价结果"),
    OM_RESULT_AUDIT_NOT("om_15","竞价结果审核不通过"),
    OM_RESULT_CONFIRM_WAIT("om_16","待确认竞价结果"),
    OM_SKU_MAKEUP_WAIT("om_17","待补录商品编码"),
    OM_SKU_AUDIT_WAIT("om_18","待审核商品编码"),
    OM_SKU_AUDIT_NOT("om_19","商品编码审核不通过"),
    OM_DO_BUY("om_20","执行采购"),
    M_AUDIT_YES("m_1","审核已通过"),
    M_VOTED("m_2","已投票"),
    M_CONFORM_AUDIT_OK("m_3","已审查"),
    M_Bidding_AUDIT_OK("m_4","已审核"),

    //竞价小组
//    MEMBER_SUBMIT_WAIT("21","待提交"),
//    MEMBER_AUDIT_WAIT("22","待审核"),
//    MEMBER_AUDIT_YES("23","审核已通过"),
//    MEMBER_AUDIT_NO("24","审核不通过"),
//    MEMBER_ISSUE_WAIT("25","待发布"),
//    MEMBER_RESPONSE_WAIT("26","待响应"),
//    MEMBER_BIDDING_END("27","竞价终止"),
//    MEMBER_RESPONSE_STOP("28","响应结束"),
//    MEMBER_CONFORM_AUDIT_IN("29","符合性审查中"),
//    MEMBER_CONFORM_AUDIT_NO("30","符合性审查不通过"),
//    MEMBER_CONFORM_AUDIT_YES("31","符合性审查通过"),
//    MEMBER_RESULT_SELECT_WAIT("32","待选择竞价结果"),
//    MEMBER_VOTING("33","投票中"),
//    MEMBER_VOTED("34","已投票"),
//    MEMBER_VOTE_EVEN("35","平票"),
//    MEMBER_RESULT_SUBMIT_WAIT("36","待提交竞价结果"),
//    MEMBER_RESULT_AUDIT_WAIT("37","待审核竞价结果"),
//    MEMBER_RESULT_AUDIT_NOT("38","竞价结果审核不通过"),
//    MEMBER_RESULT_CONFIRM_WAIT("39","待确认竞价结果"),
//    MEMBER_SKU_MAKEUP_WAIT("40","待补录商品编码"),
//    MEMBER_SKU_AUDIT_WAIT("41","待审核商品编码"),
//    MEMBER_SKU_AUDIT_NOT("42","商品编码审核不通过"),
//    MEMBER_DO_BUY("43","执行采购"),

    //审核人员
    AUDITOR_RESULT_AUDIT_WAIT("a_0","待审核竞价结果"),
    AUDITOR_RESULT_AUDIT_NOT("a_1","竞价结果审核不通过"),
    AUDITOR_RESULT_AUDIT_YES("a_2","竞价结果审核通过"),

    //供应商
    SUPPLIER_RESPONSE_NOT("s_0","未响应"),

    //作为查询条件用,存库的是下面两个（庙浩）
    SUPPLIER_RESPONSED("s_1_1","已响应"),

    SUPPLIER_RESPONSE_YES("s_1","已响应"),
    //勾选了不满足、不符合下的已响应
    SUPPLIER_RESPONSE_YES_GIVEUP("s_1_2","已响应"),

    SUPPLIER_RESPONSE_GIVEUP("s_2","已放弃"),

    //作为查询条件用,存库的是下面两个（庙浩）
    SUPPLIER_AUDIT_IN("s_3","审查中"),
    //可能成交
    SUPPLIER_AUDIT_IN_YES("s_3_1","审查中"),
    //完全不可能成交
    SUPPLIER_AUDIT_IN_NOT("s_3_2","审查中"),

    //作为查询条件用,存库的是下面两个（庙浩）
    SUPPLIER_BIDDING_DONE("s_4","已成交"),

    //确认竞价结果前，不可执行采购的已成交
    SUPPLIER_BIDDING_YES("s_4_0","已成交"),
    //确认竞价结果后，通过sku审核后，可执行采购的已成交
    SUPPLIER_BIDDING_YES_AGAIN("s_4_1","已成交"),

    SUPPLIER_SKU_MAKEUP_WAIT("s_5","待补录商品编码"),
    SUPPLIER_SKU_AUDIT_WAIT("s_6","待审核商品编码"),
    SUPPLIER_SKU_AUDIT_NOT("s_7","商品编码审核不通过"),
    SUPPLIER_BIDDING_NOT("s_8","未成交"),
    SUPPLIER_BIDDING_END("s_9","已终止");

    public static Map<String, BiddingStatus> biddingStatusMap = new HashMap<>();
    static {
        biddingStatusMap.put(OM_SUBMIT_WAIT.getValue(),OM_SUBMIT_WAIT);
        biddingStatusMap.put(OM_AUDIT_WAIT.getValue(),OM_AUDIT_WAIT);
        biddingStatusMap.put(OM_AUDIT_NO.getValue(),OM_AUDIT_NO);
        biddingStatusMap.put(OM_ISSUE_WAIT.getValue(),OM_ISSUE_WAIT);
        biddingStatusMap.put(OM_RESPONSE_WAIT.getValue(),OM_RESPONSE_WAIT);
        biddingStatusMap.put(OM_BIDDING_END.getValue(),OM_BIDDING_END);
        biddingStatusMap.put(OM_RESPONSE_STOP.getValue(),OM_RESPONSE_STOP);
        biddingStatusMap.put(OM_CONFORM_AUDIT_IN.getValue(),OM_CONFORM_AUDIT_IN);
        biddingStatusMap.put(OM_CONFORM_AUDIT_NO.getValue(),OM_CONFORM_AUDIT_NO);
        biddingStatusMap.put(OM_CONFORM_AUDIT_YES.getValue(),OM_CONFORM_AUDIT_YES);

        biddingStatusMap.put(OM_RESULT_SELECT_WAIT.getValue(),OM_RESULT_SELECT_WAIT);
        biddingStatusMap.put(OM_RESULT_SELECT_WAIT_VOTE.getValue(),OM_RESULT_SELECT_WAIT_VOTE);
        biddingStatusMap.put(OM_RESULT_SELECT_WAIT_RANDOM.getValue(),OM_RESULT_SELECT_WAIT_RANDOM);
        biddingStatusMap.put(OM_VOTING.getValue(),OM_VOTING);
        biddingStatusMap.put(OM_VOTE_EVEN.getValue(),OM_VOTE_EVEN);
        biddingStatusMap.put(OM_RESULT_SUBMIT_WAIT.getValue(),OM_RESULT_SUBMIT_WAIT);
        biddingStatusMap.put(OM_RESULT_AUDIT_WAIT.getValue(),OM_RESULT_AUDIT_WAIT);
        biddingStatusMap.put(OM_RESULT_AUDIT_NOT.getValue(),OM_RESULT_AUDIT_NOT);
        biddingStatusMap.put(OM_RESULT_CONFIRM_WAIT.getValue(),OM_RESULT_CONFIRM_WAIT);
        biddingStatusMap.put(OM_SKU_MAKEUP_WAIT.getValue(),OM_SKU_MAKEUP_WAIT);
        biddingStatusMap.put(OM_SKU_AUDIT_WAIT.getValue(),OM_SKU_AUDIT_WAIT);
        biddingStatusMap.put(OM_SKU_AUDIT_NOT.getValue(),OM_SKU_AUDIT_NOT);
        biddingStatusMap.put(OM_DO_BUY.getValue(),OM_DO_BUY);
        biddingStatusMap.put(M_AUDIT_YES.getValue(),M_AUDIT_YES);
        biddingStatusMap.put(M_VOTED.getValue(),M_VOTED);
        biddingStatusMap.put(M_Bidding_AUDIT_OK.getValue(),M_Bidding_AUDIT_OK);

//        biddingStatusMap.put(MEMBER_SUBMIT_WAIT.getValue(),MEMBER_SUBMIT_WAIT);
//        biddingStatusMap.put(MEMBER_AUDIT_WAIT.getValue(),MEMBER_AUDIT_WAIT);
//        biddingStatusMap.put(MEMBER_AUDIT_YES.getValue(),MEMBER_AUDIT_YES);
//        biddingStatusMap.put(MEMBER_AUDIT_NO.getValue(),MEMBER_AUDIT_NO);
//        biddingStatusMap.put(MEMBER_ISSUE_WAIT.getValue(),MEMBER_ISSUE_WAIT);
//        biddingStatusMap.put(MEMBER_RESPONSE_WAIT.getValue(),MEMBER_RESPONSE_WAIT);
//        biddingStatusMap.put(MEMBER_BIDDING_END.getValue(),MEMBER_BIDDING_END);
//        biddingStatusMap.put(MEMBER_RESPONSE_STOP.getValue(),MEMBER_RESPONSE_STOP);
//        biddingStatusMap.put(MEMBER_CONFORM_AUDIT_IN.getValue(),MEMBER_CONFORM_AUDIT_IN);
//        biddingStatusMap.put(MEMBER_CONFORM_AUDIT_NO.getValue(),MEMBER_CONFORM_AUDIT_NO);
//        biddingStatusMap.put(MEMBER_CONFORM_AUDIT_YES.getValue(),MEMBER_CONFORM_AUDIT_YES);
//        biddingStatusMap.put(MEMBER_RESULT_SELECT_WAIT.getValue(),MEMBER_RESULT_SELECT_WAIT);
//        biddingStatusMap.put(MEMBER_VOTING.getValue(),MEMBER_VOTING);
//        biddingStatusMap.put(MEMBER_VOTED.getValue(),MEMBER_VOTED);
//        biddingStatusMap.put(MEMBER_VOTE_EVEN.getValue(),MEMBER_VOTE_EVEN);
//        biddingStatusMap.put(MEMBER_RESULT_SUBMIT_WAIT.getValue(),MEMBER_RESULT_SUBMIT_WAIT);
//        biddingStatusMap.put(MEMBER_RESULT_AUDIT_WAIT.getValue(),MEMBER_RESULT_AUDIT_WAIT);
//        biddingStatusMap.put(MEMBER_RESULT_AUDIT_NOT.getValue(),MEMBER_RESULT_AUDIT_NOT);
//        biddingStatusMap.put(MEMBER_RESULT_CONFIRM_WAIT.getValue(),MEMBER_RESULT_CONFIRM_WAIT);
//        biddingStatusMap.put(MEMBER_SKU_MAKEUP_WAIT.getValue(),MEMBER_SKU_MAKEUP_WAIT);
//        biddingStatusMap.put(MEMBER_SKU_AUDIT_WAIT.getValue(),MEMBER_SKU_AUDIT_WAIT);
//        biddingStatusMap.put(MEMBER_SKU_AUDIT_NOT.getValue(),MEMBER_SKU_AUDIT_NOT);
//        biddingStatusMap.put(MEMBER_DO_BUY.getValue(),MEMBER_DO_BUY);

        biddingStatusMap.put(AUDITOR_RESULT_AUDIT_WAIT.getValue(),AUDITOR_RESULT_AUDIT_WAIT);
        biddingStatusMap.put(AUDITOR_RESULT_AUDIT_NOT.getValue(),AUDITOR_RESULT_AUDIT_NOT);
        biddingStatusMap.put(AUDITOR_RESULT_AUDIT_YES.getValue(),AUDITOR_RESULT_AUDIT_YES);

        biddingStatusMap.put(SUPPLIER_RESPONSE_NOT.getValue(),SUPPLIER_RESPONSE_NOT);
        biddingStatusMap.put(SUPPLIER_RESPONSED.getValue(),SUPPLIER_RESPONSED);
        biddingStatusMap.put(SUPPLIER_RESPONSE_YES.getValue(),SUPPLIER_RESPONSE_YES);
        biddingStatusMap.put(SUPPLIER_RESPONSE_YES_GIVEUP.getValue(),SUPPLIER_RESPONSE_YES_GIVEUP);
        biddingStatusMap.put(SUPPLIER_RESPONSE_GIVEUP.getValue(),SUPPLIER_RESPONSE_GIVEUP);
        biddingStatusMap.put(SUPPLIER_AUDIT_IN.getValue(),SUPPLIER_AUDIT_IN);
        biddingStatusMap.put(SUPPLIER_AUDIT_IN_YES.getValue(),SUPPLIER_AUDIT_IN_YES);
        biddingStatusMap.put(SUPPLIER_AUDIT_IN_NOT.getValue(),SUPPLIER_AUDIT_IN_NOT);
        biddingStatusMap.put(SUPPLIER_BIDDING_DONE.getValue(),SUPPLIER_BIDDING_DONE);
        biddingStatusMap.put(SUPPLIER_BIDDING_YES.getValue(),SUPPLIER_BIDDING_YES);
        biddingStatusMap.put(SUPPLIER_BIDDING_YES_AGAIN.getValue(),SUPPLIER_BIDDING_YES_AGAIN);
        biddingStatusMap.put(SUPPLIER_SKU_MAKEUP_WAIT.getValue(),SUPPLIER_SKU_MAKEUP_WAIT);
        biddingStatusMap.put(SUPPLIER_SKU_AUDIT_WAIT.getValue(),SUPPLIER_SKU_AUDIT_WAIT);
        biddingStatusMap.put(SUPPLIER_SKU_AUDIT_NOT.getValue(),SUPPLIER_SKU_AUDIT_NOT);
        biddingStatusMap.put(SUPPLIER_BIDDING_NOT.getValue(),SUPPLIER_BIDDING_NOT);
        biddingStatusMap.put(SUPPLIER_BIDDING_END.getValue(),SUPPLIER_BIDDING_END);
    }

    private String value;
    private String description;

    BiddingStatus(String value, String description) {
        this.value = value;
        this.description = description;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}
