package definition;

import lombok.Getter;
import lombok.Setter;

import java.util.HashMap;
import java.util.Map;

/**
 * 符合性审查临界值
 * @author 张代春
 * @date 2018/3/21
 */
public enum ConformanceAuditThreshold {

    /**
     * 符合性审查临界值
     */
    Threshold(2, "符合性审查临界值");

    /**
     * 审核状态
     */
    @Getter
    @Setter
    private Integer value;

    /**
     * 描述
    */
    @Getter
    @Setter
    private String description;

    ConformanceAuditThreshold(Integer value, String description) {
        this.value = value;
        this.description = description;
    }

    public static Map<Integer, ConformanceAuditThreshold> conformanceAuditThreshold = new HashMap<>();

    static {
        conformanceAuditThreshold.put(Threshold.getValue(), Threshold);
    }
}
