package definition;

import java.util.HashMap;
import java.util.Map;

/**
 * @author Jian.
 * @date 2018/3/19
 */
public enum MailTemplateEnum {

    /*
    * code规则：首位为模板号，2位为邮件标题参数数量，3位为邮件内容参数数量
    * 例子:1_1_4,就是1号模板，需要传1个邮件标题参数，4个邮件内容参数
    * */
    BID_AUDIT("1_1_5","竞价审核"),
    BID_CONFORMANCE_AUDIT("2_1_5","竞价符合性审核"),
    BID_CONFORMANCE_AUDIT_UNLOCK("3_1_5","竞价符合性审查解锁"),
    BID_VOTE_START("4_1_6","竞价开启投票"),
    BID_RESULT_AUDIT("5_1_6","竞价结果审批"),
    BID_TERMINATED("6_1_5","竞价终止"),
    BID_RESULT_NOTIFY("7_2_5","竞价结果通知"),
    SUPPLIER_CONFIRM_BIDRESULT("8_1_2","供应商确认竞价结果"),
    SKU_NOT_APPROVED("9_1_5","商品编码审核不通过"),
    ORDER_AUDIT("10_1_7","订单审批"),
    ORDER_CONFIRM("11_1_4","订单确认"),
    PRICE_CHANGED_AFTER_ORDER_CONFIRMED("12_1_1","订单确认后价格变动通知"),
    BID_ISSUE("13_1_5","发布竞价");

    public static Map<String, MailTemplateEnum> mailTemplateEnumMap = new HashMap<>();
    static {
        mailTemplateEnumMap.put(BID_AUDIT.getTemplateCode(),BID_AUDIT);
        mailTemplateEnumMap.put(BID_CONFORMANCE_AUDIT.getTemplateCode(),BID_CONFORMANCE_AUDIT);
        mailTemplateEnumMap.put(BID_CONFORMANCE_AUDIT_UNLOCK.getTemplateCode(),BID_CONFORMANCE_AUDIT_UNLOCK);
        mailTemplateEnumMap.put(BID_VOTE_START.getTemplateCode(),BID_VOTE_START);
        mailTemplateEnumMap.put(BID_RESULT_AUDIT.getTemplateCode(),BID_RESULT_AUDIT);
        mailTemplateEnumMap.put(BID_TERMINATED.getTemplateCode(),BID_TERMINATED);
        mailTemplateEnumMap.put(BID_RESULT_NOTIFY.getTemplateCode(),BID_RESULT_NOTIFY);
        mailTemplateEnumMap.put(SUPPLIER_CONFIRM_BIDRESULT.getTemplateCode(),SUPPLIER_CONFIRM_BIDRESULT);
        mailTemplateEnumMap.put(SKU_NOT_APPROVED.getTemplateCode(),SKU_NOT_APPROVED);
        mailTemplateEnumMap.put(ORDER_AUDIT.getTemplateCode(),ORDER_AUDIT);
        mailTemplateEnumMap.put(ORDER_CONFIRM.getTemplateCode(),ORDER_CONFIRM);
        mailTemplateEnumMap.put(PRICE_CHANGED_AFTER_ORDER_CONFIRMED.getTemplateCode(),PRICE_CHANGED_AFTER_ORDER_CONFIRMED);
        mailTemplateEnumMap.put(BID_ISSUE.getTemplateCode(),BID_ISSUE);
    }

    private String templateCode;

    private String description;

    MailTemplateEnum(String templateCode, String description) {
        this.templateCode = templateCode;
        this.description = description;
    }

    public String getTemplateCode() {
        return templateCode;
    }

    public void setTemplateCode(String templateCode) {
        this.templateCode = templateCode;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}
