package definition;

import java.util.HashMap;
import java.util.Map;

/**
 * @program: parent
 * @author: taofeng
 * @create: 2018-04-12
 * <p>
 * 附件_业务代码
 **/
public enum MallAttachmentBusinessCode {

    BIDBASE_ATTACH_BUSCODE("BIDBASE_ATTACH_BUSCODE", "竞价基本信息页附件"),
    BIDRESUL_ATTACH_BUSCODE("BIDRESUL_ATTACH_BUSCODE", "竞价结果审核页附件"),
    OPERATIVEBUY_ATTACH_BUSCODE("OPERATIVEBUY_ATTACH_BUSCODE", "执行采购页附件"),
    SUPBIDRELEV_ATTACH_BUSCODE("SUPBIDRELEV_ATTACH_BUSCODE", "供应商竞价响应页附件");

    private String value;
    private String description;

    public static Map<String, MallAttachmentBusinessCode> MallAttachmentBusinessCodeMap = new HashMap<>();

    static {
        MallAttachmentBusinessCodeMap.put(BIDBASE_ATTACH_BUSCODE.getValue(), BIDBASE_ATTACH_BUSCODE);
        MallAttachmentBusinessCodeMap.put(BIDRESUL_ATTACH_BUSCODE.getValue(), BIDRESUL_ATTACH_BUSCODE);
        MallAttachmentBusinessCodeMap.put(OPERATIVEBUY_ATTACH_BUSCODE.getValue(), OPERATIVEBUY_ATTACH_BUSCODE);
        MallAttachmentBusinessCodeMap.put(SUPBIDRELEV_ATTACH_BUSCODE.getValue(), SUPBIDRELEV_ATTACH_BUSCODE);
    }

    MallAttachmentBusinessCode(String value, String description) {
        this.value = value;
        this.description = description;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}
