package dto;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 符合性审查审核列表数据封装 DTO
 *
 * @author Drury
 * @date 2018/3/19
 */
@Data
public class BiddingConformReviewAuditListDTO implements Serializable {

    /**
     * 需求编号
     */
    private String biddingCode;

    /**
     * 商品描述
     */
    private String goodsDesription;

    /**
     * 规格参数.
     */
    private String specification;

    /**
     * 要求到货日期
     */
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date dateRequiredDelivery;

    /**
     * 最低采购数量
     */
    private Long minPurchaseAmount;

    /**
     * 竞价需求地址列表
     */
    private List<JcbdDemandAddressNumDto> jcbdDemandAddressNums;

    /**
     * 审查项数量
     */
    private Integer checkItemCount;

    /**
     * 响应供应商数量
     */
    private Integer demandResponseCount;

    /**
     * 已审查供应商数
     */
    private Integer auditSupplierCount;

}
