package dto;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 竞价符合性审核数据封装 DTO
 * @author Drury
 * @date 2018-03-15
 */
@Data
public class BiddingConformityAuditDTO implements Serializable {

    /**
     * 竞价编号
     */
    private String biddingNo;

    /**
     * 竞价需求编号
     */
    private String demandCode;

    /**
     * 审核人 ID
     */
    private String auditorId;

    /**
     * 审核人邮箱
     */
    private String email;

    /**
     * 符合性审核信息
     */
    private List<BiddingConformAuditSupplierDTO> suppliers;

}
